@extends( 'layouts.app')

@section('title')
Installment Plan Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('installment.all')}}">Installments</a></li>
        <li class="active">Installment Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Installment Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Unit Type</td>
                                                    <td> {{$installment->plotType ? $installment->plotType->name : ''}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Unit Size</td>
                                                    <td> {{$installment->plotSize ? $installment->plotSize->name : ''}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Cost Amount</td>
                                                    <td> {{number_format($installment->cost_amount)}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Down Payment</td>
                                                    <td> {{number_format($installment->down_payment / 100 * $installment->cost_amount)}} ({{round($installment->down_payment)}} %) </td>
                                                </tr>
                                                <tr>
                                                    <td>Confirmation Fee</td>
                                                    <td> {{number_format($installment->confirmation_fee / 100 * $installment->cost_amount)}} ({{round($installment->confirmation_fee)}} %) </td>
                                                </tr>
                                                @if($installment->plot_belting_fee)
                                                <tr>
                                                    <td>Unit Belting Fee</td>
                                                    <td> {{number_format($installment->plot_belting_fee / 100 * $installment->cost_amount)}} ({{round($installment->plot_belting_fee)}} %) </td>
                                                </tr>
                                                @endif
                                                @if($installment->six_installment)
                                                <tr>
                                                    <td>Every Sixth Installment</td>
                                                    <td> {{number_format($installment->six_installment / 100 * $installment->cost_amount / 8)}} ({{round($installment->six_installment)}} %) </td>
                                                </tr>
                                                @endif
                                                 <tr>
                                                    <td>Possession Fee</td>
                                                    <td> {{number_format($installment->possession_fee / 100 * $installment->cost_amount)}} ({{round($installment->possession_fee)}} %) </td>
                                                </tr>
                                                 <tr>
                                                    <td>Installment (per)</td>
                                                    <td> {{number_format($installment->installment / 100 * $installment->cost_amount / $installment->total_months)}} ({{round($installment->installment)}} %) </td>
                                                </tr>
                                                <tr>
                                                    <td>Total Months</td>
                                                    <td> {{$installment->total_months}} months</td>
                                                </tr>
                                                <tr>
                                                    <td>Status</td>
                                                    @if($installment->status == true)
                                                    <td>Active </td>
                                                    @else
                                                    <td> InActive </td>
                                                    @endif
                                                </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$installment->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$installment->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop