@extends('layouts.app')

@section('title')
Edit Installment Plan 
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Installment Plan</h3>
                            <p class="text-muted m-b-30 font-13"> Upate the information </p>
                            <form class="form-horizontal" action="{{route('installment.update')}}" method="post" autocomplete="off">
                                <input type="hidden" name="id" value="{{$ins->id}}">

                               {{csrf_field()}}
                                <div class="form-group col-md-6">
                                    <label for="exampleInputuname" class="col-sm-5 control-label"> Unit Type <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">

                                            <select class="form-control select2" name="plot_type">
                                                <option value="" selected="" >None</option>
                                                @foreach($types as $type)
                                                @if($ins->plot_type == $type->id)
                                                <option selected="" value="{{$type->id}}">{{$type->name}}</option>
                                                @else
                                                <option  value="{{$type->id}}">{{$type->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        @if ($errors->has('plot_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('plot_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class="form-group col-md-6">
                                    <label for="exampleInputuname" class="col-sm-5 control-label"> Unit Size <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">

                                            <select class="form-control select2" name="plot_size">
                                                <option value="" selected="" >None</option>
                                                @foreach($sizes as $size)
                                                @if($ins->plot_size == $size->id)
                                                <option selected="" value="{{$size->id}}">{{$size->name}}</option>
                                                @else
                                                <option value="{{$size->id}}">{{$size->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        @if ($errors->has('plot_size'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('plot_size') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Cost Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                             <input  type="integer" class="form-control" id='cost-amount' name="cost_amount" value="{{$ins->cost_amount}}" id="exampleInputuname" placeholder="Cost of Land">

                                        @if ($errors->has('cost_amount'))
                                    <span class="help-block" id='cost-amount-label'>
                                        <strong>{{ $errors->first('cost_amount') }}</strong>
                                    </span>
                                @endif
                                <div  id='cost-amount-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group col-md-6">
                                    <label for="exampleInputuname" class="col-sm-5 control-label">Schedule Type<span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">

                                            <select class="form-control select2" name="schedule_type">



                                                @if($ins->schedule_type) == \App\InstallmentPlan::percentage)
                                                <option  value="{{\App\InstallmentPlan::manual}}">Manual</option>
                                                 <option  selected="" value="{{\App\InstallmentPlan::percentage}}">Percentage</option>
                                                @else
                                                 <option  selected="" value="{{\App\InstallmentPlan::manual}}">Manual</option>
                                                <option  value="{{\App\InstallmentPlan::percentage}}">Percentage</option>
                                                @endif


                                            </select>
                                        @if ($errors->has('schedule_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                 <div class="clearfix"></div>
                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Down Payment <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                             <input  type="integer" class="form-control" id='down-payment' name="down_payment" value="{{$ins->down_payment / 100 * $ins->cost_amount}}" id="exampleInputuname" placeholder="Down Payment">

                                        @if ($errors->has('down_payment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('down_payment') }}</strong>
                                    </span>
                                @endif
                                <div  id='down-payment-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>




                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Confirmation Fee <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                             <input  type="integer" class="form-control" id='confirmation-fee' name="confirmation_fee" value="{{$ins->confirmation_fee / 100 * $ins->cost_amount}}" id="exampleInputuname" placeholder="Confirmation Fee">

                                        @if ($errors->has('confirmation_fee'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('confirmation_fee') }}</strong>
                                    </span>
                                @endif
                                <div  id='confirmation-fee-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>
                                 <div class="clearfix"></div>
                               <div class="form-group col-md-6" >
                                   <label for="inputPassword3" class="col-sm-5 control-label">Unit Belting Fee <br> (For Residential) <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                             <input  type="integer" class="form-control" id='plot-belting-fee' name="plot_belting_fee" value="{{$ins->plot_belting_fee / 100 * $ins->cost_amount}}" id="exampleInputuname" placeholder="Plot Belting Fee">

                                        @if ($errors->has('plot_belting_fee'))
                                        <span class="help-block" >
                                        <strong>{{ $errors->first('plot_belting_fee') }}</strong>
                                    </span>
                                @endif
                                <div  id='plot-belting-fee-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>

                                 <div class="form-group col-md-6"   >
                                     <label for="inputPassword3" class="col-sm-5 control-label">Every Sixth Installment <br> (for Farm houses)<span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                             <input  type="integer" class="form-control" id='six_installment' name="six_installment" value="{{$ins->six_installment / 100 * $ins->cost_amount / 8}}" id="exampleInputuname" placeholder="8 Six Month Installment">

                                        @if ($errors->has('six_installment'))
                                        <span class="help-block" >
                                        <strong>{{ $errors->first('six_installment') }}</strong>
                                    </span>
                                @endif
                                <div  id='six-installment-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>

                               <div class="clearfix"></div>
                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Possession Fee <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                            <input  type="integer" class="form-control" id="possession-fee" name="possession_fee" value="{{$ins->possession_fee / 100 * $ins->cost_amount}}" id="exampleInputuname" placeholder="Possession Fee">

                                        @if ($errors->has('possession_fee'))
                                        <span class="help-block" >
                                        <strong>{{ $errors->first('possession_fee') }}</strong>
                                    </span>
                                @endif
                                <div  id='possession-fee-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>


                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Installment <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                            <input  type="integer" class="form-control" id="installment" name="installment" value="{{$ins->installment / 100 * $ins->cost_amount / $ins->total_months}}" id="exampleInputuname" placeholder="Installment">

                                        @if ($errors->has('installment'))
                                    <span class="help-block" id='installment-label'>
                                        <strong>{{ $errors->first('installment') }}</strong>
                                    </span>
                                @endif
                                 <div  id='installment-label'>

                                </div>
                                        </div>
                                    </div>
                                </div>
                                 <div class="clearfix"></div>
                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Total Months <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                            <input  type="integer" class="form-control" id="total-months" name="total_months" value="{{$ins->total_months}}" id="exampleInputuname" placeholder="Total Months">

                                        @if ($errors->has('total_months'))
                                        <span class="help-block" id="total-months-label">
                                        <strong>{{ $errors->first('total_months') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group col-md-6" >
                                    <label for="inputPassword3" class="col-sm-5 control-label">Status <span style="color: red">*</span></label>
                                    <div class="col-sm-7">
                                        <div class="input-group" style="width:220px">
                                            <select class="form-control select2" name="status">

                                                @if($ins->status == 1)
                                                <option value="1" selected="">Active</option>
                                                <option value="0">InActive</option>

                                                @elseif(old('status') == 0)
                                                <option value="1" >Active</option>
                                                <option value="0" selected="">InActive</option>

                                                @else
                                                <option value="1" >Active</option>
                                                <option value="0">InActive</option>
                                                @endif


                                            </select>
                                        @if ($errors->has('status'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('status') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>

    var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
    var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];

//update the cost label
    $("#cost-amount").keyup(function(){
    num=$("#cost-amount").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#cost-amount-label").text(str);

});

//update the down payemnt label
    $("#down-payment").keyup(function(){
    num=$("#down-payment").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#down-payment-label").text(str);

});

//update the confirmation fee label
    $("#confirmation-fee").keyup(function(){
    num=$("#confirmation-fee").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#confirmation-fee-label").text(str);

});

//update the possession fee label
    $("#possession-fee").keyup(function(){
    num=$("#possession-fee").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#possession-fee-label").text(str);

});

//update the plot belting fee label
    $("#plot-belting-fee").keyup(function(){
    num=$("#plot-belting-fee").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#plot-belting-fee-label").text(str);

});

//update the installment label
    $("#installment").keyup(function(){
    num=$("#installment").val();


    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#installment-label").text(str);

});

//update the cost label

    num=$("#cost-amount").val();


    if ((num = num.toString()).length < 9){
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n){ var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#cost-amount-label").text(str);

    }}

//update the down payemnt label

    num=$("#down-payment").val();


    if ((num = num.toString()).length < 9) {
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n){ var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#down-payment-label").text(str);

    }}

//update the confirmation fee label

    num=$("#confirmation-fee").val();


    if ((num = num.toString()).length < 9) {
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n){ var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#confirmation-fee-label").text(str);
   }}


//update the possession fee label

    num=$("#possession-fee").val();


    if ((num = num.toString()).length < 9) {
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n){  var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#possession-fee-label").text(str);
   }}


//update the plot belting fee label

    num=$("#plot-belting-fee").val();


    if ((num = num.toString()).length < 9){
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n) { var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#plot-belting-fee-label").text(str);
   }}


//update the installment label

    num=$("#installment").val();


    if ((num = num.toString()).length < 9){
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (n){ var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';
   $("#installment-label").text(str);

    }}
    </script>



@stop