@extends('layouts.app')

@section('title')
All Registration No 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Registration No</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Registration No.</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Registration Number </label>
                                                        <select id="reg" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($reg as $r)
                                                        <option value="{{$r->id}}">{{$r->number}}</option>
                                                        @endforeach
                                                        </select>

                                                         </div>
                                                </div>
                                                
                                                

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By status</label>
                                                        <select id="status" class="form-control select2">
                                                            <option  value="0">None</option>
                                                            
                                                        <option  value="{{\App\RegistrationNo::open}}">Open</option>
                                                        @role('admin')
                                                        <option  value="{{\App\RegistrationNo::reserved}}">Reserved</option>
                                                        <option  value="{{\App\RegistrationNo::cancel}}">Cancel</option>
                                                        <option  value="{{\App\RegistrationNo::temp_hold}}">Temp Hold</option>
                                                        @endrole
                                                        <option  value="{{\App\RegistrationNo::sold}}">Sold</option>
                                                        
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Seacrch</button>
                                            
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('view-reg-no')
								<a href="{{route('registration_no.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Registration No
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">All Registration Numbers</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Number</th>
                                            <th>Status</th>
                                            <th>Customer</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @permission('edit-reg-no')
                                            <?php $edit_reg = true;?>
                                        @else
                                            <?php $edit_reg = false;?>
                                        @endpermission

                                        @permission('delete-reg-no')
                                            <?php $delete_reg = true;?>
                                        @else
                                            <?php $delete_reg = false;?>
                                        @endpermission

                                        @foreach($allRegistrationNos as $number)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$number->number}}</td>


                                           @if($number->status == \App\RegistrationNo::open)
                                            <td><span class="label label-primary" style="background-color:#cd703d;">Open</span></td>
                                            @elseif($number->status == \App\RegistrationNo::reserved)
                                            <td><span class="label label-default" style="background-color: #337ab7;">Reserved</span></td>
                                            @elseif($number->status == \App\RegistrationNo::sold)
                                            <td><span class="label label-success">Sold</span></td>
                                            @elseif($number->status == \App\RegistrationNo::cancel)
                                            <td><span class="label label-danger">Canceled</span></td>
                                            @elseif($number->status == \App\RegistrationNo::temp_hold)
                                            <td><span class="label label-success">Temporary Hold</span></td>
                                            @endif
                                            @if($number->registration)
                                            <td><a target="_blank" href="{{route('customer.detail',['id'=>$number->registration->customer->id])}}">{{$number->registration->customer->name}} - {{$number->registration->customer->cnic}}</a></td>
                                            @else

                                            <td>{{$number->name}} - {{$number->cnic}} - {{$number->phone_number}} - {{$number->email}}</td>
                                            @endif
                                            <td class="text-nowrap">
                                                @if($edit_reg)
                                                <a href="{{route('registration_no.editView',['id'=>$number->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endif

                                                @if($delete_reg)
                                                <a href="{{route('registration_no.delete',['id'=>$number->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                                <div style="float: right;">{{$allRegistrationNos->links()}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false
        });
    });

        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            reg = $('#reg').val();
            status = $('#status').val();

            if(reg == 0 && status == 0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'reg':reg,'status':status};
            $.get('/registration-no/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });

        
       
    </script>
@stop