@extends('layouts.app')

@section('title')
    Reset DataBase
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="">Reset DataBase</a></li>

    </ol>
@stop
@section('content')
    <div class="container-fluid">

        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    {{-- <div class="pull-right">
                                <a href="" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Reset Database
                                </a>
                            </div> --}}
                    <h3 class="box-title">Reset Database</h3>
                    <hr>
                    <button class="btn  btn-primary" id='postbutton' type='button'>
                        <i class="fa fa-plus-square"></i>&nbsp; Reset Database
                    </button>


                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->



    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="csrf-token"]').attr('content');
            $("#postbutton").click(function() {
              Swal.fire({
                        title: "Are you sure?",
                        text: "you want to clean database!",
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                        showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Sure!'
                    })
                    .then((result) => {
                        if (result.isConfirmed) {
                            $('.preloader').fadeIn();
                            $.ajax({
                                /* the route pointing to the post function */
                                url: '{{ route('reset.database.download') }}',
                                type: 'POST',
                                /* send the csrf-token and the input to the controller */
                                data: {
                                    _token: CSRF_TOKEN
                                },
                                dataType: 'JSON',
                                /* remind that 'data' is the response of the AjaxController */
                                success: function(data) {
                                   
                                    const link = document.createElement('a');
                                    link.setAttribute('href', data.link);
                                    link.setAttribute('download',
                                        'yourfilename.extensionType'
                                        ); // Need to modify filename ...
                                    link.click();
                                    $.ajax({
                                        /* the route pointing to the post function */
                                        url: '{{ route('reset.database.update') }}',
                                        type: 'POST',
                                        /* send the csrf-token and the input to the controller */
                                        data: {
                                            _token: CSRF_TOKEN
                                        },
                                        dataType: 'JSON',
                                        /* remind that 'data' is the response of the AjaxController */
                                        success: function(data) {
                                            $('.preloader').fadeOut();
                                            console.log(data);
                                            Swal.fire("Poof! Your DataBase is cleaned!", {
                                                icon: "success",
                                            });
                                        }
                                    });



                                }
                            });
                        } else {
                          Swal.fire("Your Data is safe!");
                        }
                    });



            });
        });
    </script>
@stop
