@extends('layouts.app')

@section('title')
All Role 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Roles</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								<a href="{{route('role.add')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Role
								</a>
							</div>
                            <h3 class="box-title">All Roles</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project Name</th>
                                            <th>Role Name</th>
                                            <th>Description</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allRoles as $role)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>
                                            @foreach($role->projects as $project)
                                            @if($project->name == 'Super Admin')
                                            <span class="label  " style='background-color: red;'>  {{$project->name}}</span> 
                                            @else
                                           <span class="label label-primary">  {{$project->name}}</span> 
                                           @endif
                                            @endforeach    
                                            </td> 
                                            <td>{{$role->name}} </td>
                                            <td>{{$role->description}} </td>
                                            

                                            <td class="text-nowrap">
                                                @role('admin')

                                                <a href="{{route('role.permission',['id'=>$role->id])}}" class="btn btn-primary">Manage Permissions</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                @endrole
                                            
                                                <a href="{{route('role.edit',['id'=>$role->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                <a href="{{route('role.delete',['id'=>$role->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                         
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop