@extends('layouts.app')

@section('title')
    Role Permissions
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Role Access</li>
    </ol>
@stop

@section('css')

    <style type="text/css">
        .table>tbody>tr>td {
            font-size: 12px !important;
        }
    </style>

@stop

@section('content')
    <div class="container-fluid">

        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Role Permission Management</h3>
                    <form method="post" action="{{ route('role.permission.update') }}">
                        {{ csrf_field() }}
                        <input type="hidden" name="role_id" value="{{ $roles[0]->id }}">

                        <input type="submit" class="btn btn-primary" name="submit" value="Submit"
                            style="float: right;"><br>
                        <hr>


                        <select class="js-example-basic-multiple" name="permission[]" multiple="multiple" style="width: 500px;">
                           
                          
                            <?php $department = 0; ?>

                            @foreach ($permissions as $p)
                           
                                @if ($p->department)
                                    @if ($department == $p->department)
                                       
                                            
                                            @foreach ($roles as $role)
                                                @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                                     
                                                    <option value='{{ $p->id }}' selected><b>{{ $p->display_name }}</b></option>
                                                @else
                                                     
                                                    <option value='{{ $p->id }}' ><b>{{ $p->display_name }}</b></option>
                                                @endif
                                            @endforeach


                                       
                                    @else
                                    <?php $department = $p->department; ?>

                                    {{-- <tr></tr>

                                    <tr>
                                        <td colspan="4"><b style="font-weight: 900;"> --}}
                                                @if ($department == \App\Permission::SALES)
                                                <optgroup label="SALES DEPARTMENT PERMISSIONS">

                                                  </optgroup>
                                                   
                                                @elseif($department == \App\Permission::ACCOUNTS)
                                                <optgroup label="ACCOUNTS DEPARTMENT PERMISSIONS"> </optgroup>
                                                    
                                                @elseif($department == \App\Permission::PROCUREMENT)
                                                <optgroup label="PROCUREMENT DEPARTMENT PERMISSIONS"></optgroup> 
                                                
                                                @endif
                                            </b>
                                        {{-- </td>
                                    </tr>

                                    <tr></tr> --}}

                                    {{-- <tr style="text-align: center;">
                                        <th width="300px" style="text-align: center;">Access</th>
                                    //    @foreach ($roles as $role)
                                            <th style="text-align: center;"> <input type="checkbox"
                                            //        onclick="updateDepartment({{ $department }})"
                                              //      class="form-control selectAllDep{{ $department }}">
                                            //    &nbsp;&nbsp;{{ $role->name }}</th>
                                     //   @endforeach

                                    </tr> --}}

                                    
    
                                        @foreach ($roles as $role)
                                            @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                               
                                                <option value='{{ $p->id }}' selected><b>{{ $p->display_name }}</b></option>
                                            @else
                                               
                                                <option value='{{ $p->id }}' ><b>{{ $p->display_name }}</b></option>
                                            @endif
                                        @endforeach


                                    
                                       
                                    @endif
                                @endif
                            @endforeach



                          </select>
                        <div class="table-responsive">
                        

                            {{-- <table class="table table-bordered" id="myTable">

                                <tbody>

                                    <?php $department = 0; ?>

                                    @foreach ($permissions as $p)
                                   
                                        @if ($p->department)
                                            @if ($department == $p->department)
                                                <tr>
                                                    <td style="text-align: center;"><b>{{ $p->display_name }}</b></td>
                                                    @foreach ($roles as $role)
                                                        @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    checked=""
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @else
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @endif
                                                    @endforeach


                                                </tr>
                                            @else
                                                <?php $department = $p->department; ?>

                                                <tr></tr>

                                                <tr>
                                                    <td colspan="4"><b style="font-weight: 900;">
                                                            @if ($department == \App\Permission::SALES)
                                                                SALES DEPARTMENT PERMISSIONS
                                                            @elseif($department == \App\Permission::ACCOUNTS)
                                                                ACCOUNTS DEPARTMENT PERMISSIONS
                                                            @elseif($department == \App\Permission::PROCUREMENT)
                                                                PROCUREMENT DEPARTMENT PERMISSIONS
                                                            @endif
                                                        </b>
                                                    </td>
                                                </tr>

                                                <tr></tr>

                                                <tr style="text-align: center;">
                                                    <th width="300px" style="text-align: center;">Access</th>
                                                    @foreach ($roles as $role)
                                                        <th style="text-align: center;"> <input type="checkbox"
                                                                onclick="updateDepartment({{ $department }})"
                                                                class="form-control selectAllDep{{ $department }}">
                                                            &nbsp;&nbsp;{{ $role->name }}</th>
                                                    @endforeach

                                                </tr>

                                                <tr>
                                                    <td style="text-align: center;"><b>{{ $p->display_name }}</b></td>
                                                    @foreach ($roles as $role)
                                                        @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    checked=""
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @else
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @endif
                                                    @endforeach


                                                </tr>
                                            @endif
                                        @endif
                                    @endforeach



                                </tbody>
                            </table> --}}

                    </form>
                </div>

            </div>
        </div>
    </div>
    <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script>
        // $(function() {
        //     $('#myTable').DataTable({
        //         'order': false,
        //         'paging': false

        //     });

        // });

        function updateDepartment(id) {

            c_id = '.selectAllDep' + id;
            check_id = '.dep' + id;

            var checked = $(c_id).is(':checked');
            if (checked) {

                $(check_id).each(function() {
                    $(this).prop("checked", true);
                });
            } else {
                $(check_id).each(function() {
                    $(this).prop("checked", false);
                });
            }

        }
     
    </script>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
       $(document).ready(function() {
    $('.js-example-basic-multiple').select2({
        placeholder: 'Select the permissions'
    });
});
    </script>
@stop
