@extends('layouts.app')

@section('title')
    Role Permissions
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Role Access</li>
    </ol>
@stop

@section('css')

    <style type="text/css">
        .table>tbody>tr>td {
            font-size: 12px !important;
        }
    </style>

@stop

@section('content')
    <div class="container-fluid">

        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Role Permission Management</h3>
                    <form method="post" action="{{ route('role.permission.update') }}">
                        {{ csrf_field() }}

                        <select class="form-control" name="select_department" id='select_department' style="width: 500px;"
                            onchange="updateAccordingToSelect(this.value)">
                            <option value='all' >
                                All Departments
                            </option>
                            <option value="{{ \App\Permission::SALES }}">
                                Sales Department
                            </option>
                            <option value="{{ \App\Permission::ACCOUNTS }}">
                                Accounts Department
                            </option>
                            <option value="{{ \App\Permission::PROCUREMENT }}">
                                Procurement Department
                            </option>

                        </select>


                        <input type="hidden" name="role_id" value="{{ $roles[0]->id }}">
                        <input type="submit" class="btn btn-primary" name="submit" value="Submit"
                            style="float: right;"><br>
                        <hr>
                        <div class="table-responsive">

                            <table class="table table-bordered" id="myTable">

                                <tbody>

                                    <?php $department = 0; ?>

                                    @foreach ($permissions as $p)
                                        @if ($p->department)
                                            @if ($department == $p->department)
                                                <tr class='dep_row{{ $department }}'>
                                                    <td style="text-align: center;"><b>{{ $p->display_name }}</b></td>
                                                    @foreach ($roles as $role)
                                                        @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    checked=""
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @else
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @endif
                                                    @endforeach


                                                </tr>
                                            @else
                                                <?php $department = $p->department; ?>

                                                <tr class='dep_row{{ $department }}'></tr>

                                                <tr class='dep_row{{ $department }}'>
                                                    <td colspan="4"><b style="font-weight: 900;">
                                                            @if ($department == \App\Permission::SALES)
                                                                SALES DEPARTMENT PERMISSIONS
                                                            @elseif($department == \App\Permission::ACCOUNTS)
                                                                ACCOUNTS DEPARTMENT PERMISSIONS
                                                            @elseif($department == \App\Permission::PROCUREMENT)
                                                                PROCUREMENT DEPARTMENT PERMISSIONS
                                                            @endif
                                                        </b>
                                                    </td>
                                                </tr>

                                                <tr></tr>

                                                <tr style="text-align: center;" class='dep_row{{ $department }}'>
                                                    <th width="300px" style="text-align: center;">Access</th>
                                                    @foreach ($roles as $role)
                                                        <th style="text-align: center;"> <input type="checkbox"
                                                                onclick="updateDepartment({{ $department }})"
                                                                class="form-control selectAllDep{{ $department }}">
                                                            &nbsp;&nbsp;{{ $role->name }}</th>
                                                    @endforeach

                                                </tr>

                                                <tr class='dep_row{{ $department }}'>
                                                    <td style="text-align: center;"><b>{{ $p->display_name }}</b></td>
                                                    @foreach ($roles as $role)
                                                        @if (\App\PermissionRole::where([['role_id', $role->id], ['permission_id', $p->id]])->first())
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    checked=""
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @else
                                                            <th><input style="height: 20px;" type="checkbox"
                                                                    class="form-control dep{{ $department }}"
                                                                    name="permission[{{ $role->id }}][{{ $p->id }}]">
                                                            </th>
                                                        @endif
                                                    @endforeach


                                                </tr>
                                            @endif
                                        @endif
                                    @endforeach



                                </tbody>
                            </table>

                    </form>
                </div>

            </div>
        </div>
    </div>
    <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script>
        $(function() {
            $('#myTable').DataTable({
                'order': false,
                'paging': false

            });

        });

        function updateDepartment(id) {

            c_id = '.selectAllDep' + id;
            check_id = '.dep' + id;

            var checked = $(c_id).is(':checked');
            if (checked) {

                $(check_id).each(function() {
                    $(this).prop("checked", true);
                });
            } else {
                $(check_id).each(function() {
                    $(this).prop("checked", false);
                });
            }

        }

        function updateAccordingToSelect(id) {
           
            if(id == 'all'){
                $("#select_department option:not(:selected)").each(function() {
                dep_row2 = '.dep_row' +$(this).val();
  $(dep_row2).each(function() {
                $(this).show();
            });
});
            }else
            {
                dep_row = '.dep_row' + id;
            $(dep_row).each(function() {
                $(this).show();
            });
            
            $("#select_department option:not(:selected)").each(function() {
                dep_row2 = '.dep_row' +$(this).val();
  $(dep_row2).each(function() {
                $(this).hide();
            });
});
            }
          
           
           



        }
    </script>
@stop
