@extends('layouts.app')

@section('title')
    Edit Schedule Plan
@stop
@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Edit Schedule Plan</li>
    </ol>
@stop
@section('css')

    <style>
        .chosen-container.chosen-container-single {
            width: 100px !important;
        }
        .newclass {
    text-align: center;
    position: relative;
    right: 115px;
}
    </style>
@stop
@section('content')

    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Schedule Plan</h3>
                    <p class="text-muted m-b-30 font-13"> Update the information </p>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form class="form-horizontal" action="{{ route('schedule.update') }}" method="post" autocomplete="off"
                        onsubmit="return validatePossessionDate(this)">
                        <input type="hidden" name="id" value="{{ $plan->id }}">

                        {{ csrf_field() }}



                        <div class="col-md-12">

                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">

                                        <div class="col-sm-12">

                                            <label for="inputPassword3" class=" control-label">Total Months <span
                                                    style="color: red">*</span></label>

                                            <div class="input-group" style="width:100%">
                                                <input type="number" class="form-control" name="total_months"
                                                    value="{{ $plan->total_months }}" id="exampleInputuname"
                                                    placeholder="Total Months">

                                                @if ($errors->has('total_months'))
                                                    <span class="help-block" id="total-months-label">
                                                    <strong>{{ $errors->first('total_months') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>




                                <div class="col-sm-4">
                                    <div class="form-group">

                                        <div class="col-sm-12">

                                            <label for="inputPassword3" class=" control-label">Late Fine Percentage <span
                                                    style="color: red">*</span></label>

                                            <div class="input-group" style="width:100%">
                                                <input type="float" class="form-control" name="fine"
                                                    value="{{ $plan->fine }}" id="exampleInputuname"
                                                    placeholder="Late Fine Percentage">

                                                @if ($errors->has('fine'))
                                                    <span class="help-block" id="fine-label">
                                                        <strong>{{ $errors->first('fine') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>




                                <div class="col-sm-4">
                                    <div class="form-group">

                                        <div class="col-sm-12">

                                            <label for="inputPassword3" class="control-label">Possession date </label>

                                            <div class="input-group" style="width:100%">
                                                <input type="date" min="{{ date('Y-m-d') }}" class="form-control"
                                                    name="possession_date" value="{{ $plan->possession_date }}"
                                                    id="possession_date">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-md-12">
                            <hr>
                        </div>

                        <div class="col-md-12">

                            <div class="row">


                                <div class="col-sm-6">

                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Down Payment
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">

                                                    <select class='form-control select-options' name="down_payment_priority"
                                                        id='down_payment_priority' style="width:10rem">


                                                        <option value="{{ $down_payment_priority }}" selected>
                                                            {{ $down_payment_priority }}</option>

                                                    </select>
                                                </div>


                                                <input type="number" step="any" style="margin-top: 0.5%;"
                                                    class="form-control" name="down_payment"
                                                    value="{{ $plan->down_payment }}" id="exampleInputuname"
                                                    placeholder="Enter Down payment %" min="1" max="100">



                                                @if ($errors->has('down_payment'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('down_payment') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Installment
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $installment_priority }}" class="form-control"
                                                        style="width:10rem" name="installment_priority"> --}}
                                                    <select class='form-control select-options'
                                                        name="installment_priority" id='installment_priority'
                                                        style="width:10rem">
                                                        <option value='{{ $installment_priority }}' selected>
                                                            {{ $installment_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top: 0.5%"
                                                    class="form-control" name="monthly_installment"
                                                    value="{{ $plan->monthly_installment }}" id="exampleInputuname"
                                                    placeholder="Installment %" min="1" max="100">

                                                @if ($errors->has('monthly_installment'))
                                                    <span class="help-block" id='installment-label'>
                                                        <strong>{{ $errors->first('monthly_installment') }}</strong>
                                                    </span>
                                                @endif

                                            </div>
                                        </div>
                                    </div>
                                </div>





                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Possession
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $possession_priority }}" class="form-control"
                                                        style="width:10rem" name="possession_priority"> --}}

                                                    <select class='form-control select-options' name="possession_priority"
                                                        id='possession_priority' style="width:10rem">
                                                        <option value='{{ $possession_priority }}' selected>
                                                            {{ $possession_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="possession"
                                                    value="{{ $plan->possession }}" id="exampleInputuname"
                                                    placeholder="Enter Possession %" min="0" max="100">

                                                @if ($errors->has('possession'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('possession') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-sm-6">

                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Allotment
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $allotment_priority }}" class="form-control"
                                                        style="width:10rem" name="allotment_priority"> --}}

                                                    <select class='form-control select-options' name="allotment_priority"
                                                        id='allotment_priority' style="width:10rem">
                                                        <option value='{{ $allotment_priority }}' selected>
                                                            {{ $allotment_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="allotment" value="{{ $plan->allotment }}"
                                                    id="exampleInputuname" placeholder="Enter Allotment %" min="0"
                                                    max="100">

                                                @if ($errors->has('allotment'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('allotment') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Confirmation
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">
                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $confirmation_priority }}" class="form-control"
                                                        style="width:10rem" name="confirmation_priority"> --}}

                                                    <select class='form-control select-options'
                                                        name="confirmation_priority" id='confirmation_priority'
                                                        style="width:10rem">

                                                        <option value='{{ $confirmation_priority }}' selected>
                                                            {{ $confirmation_priority }}</option>


                                                    </select>
                                                </div>
                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="confirmation"
                                                    value="{{ $plan->confirmation }}" id="exampleInputuname"
                                                    placeholder="Enter confirmation %" min="0" max="100">

                                                @if ($errors->has('confirmation'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('confirmation') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Booking
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $booking_priority }}" class="form-control"
                                                        style="width:10rem" name="booking_priority"> --}}

                                                    <select class='form-control select-options' name="booking_priority"
                                                        id='booking_priority' style="width:10rem">
                                                        <option value='{{ $booking_priority }}' selected>
                                                            {{ $booking_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top: 0.5%"
                                                    class="form-control" name="booking" value="{{ $plan->booking }}"
                                                    id="exampleInputuname" placeholder="Enter booking %" min="0"
                                                    max="100">

                                                @if ($errors->has('booking'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('booking') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>




                              



                                <div class="col-sm-6">

                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | File
                                            Processing <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $file_processing_priority }}" class="form-control"
                                                        style="width:10rem" name="file_processing_priority"> --}}

                                                    <select class='form-control select-options'
                                                        name="file_processing_priority" id='file_processing_priority'
                                                        style="width:10rem">

                                                        <option value='{{ $file_processing_priority }}' selected>
                                                            {{ $file_processing_priority }}</option>


                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="file_processing"
                                                    value="{{ $plan->file_processing }}" id="exampleInputuname"
                                                    placeholder="Enter file processing %" min="0" max="100">

                                                @if ($errors->has('file_processing'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('file_processing') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Registration
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $registration_priority }}" class="form-control"
                                                        style="width:10rem" name="registration_priority"> --}}

                                                    <select class='form-control select-options'
                                                        name="registration_priority" id='registration_priority'
                                                        style="width:10rem">

                                                        <option value='{{ $registration_priority }}' selected>
                                                            {{ $registration_priority }}</option>

                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="registration"
                                                    value="{{ $plan->registration }}" id="exampleInputuname"
                                                    placeholder="Enter Registration %" min="0" max="100">

                                                @if ($errors->has('registration'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('registration') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Ballon
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">

                                                <div class="input-group-addon" style="padding: 0;">


                                                    <select class='form-control select-options' name="ballon_priority"
                                                        id='ballon_priority' style='width:100px;'>
                                                        <option value='{{ $ballon_priority }}' selected>
                                                            {{ $ballon_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="ballon" value="{{ $plan->ballon }}"
                                                    id="exampleInputuname" placeholder="Enter Ballon %" min="0"
                                                    max="100">

                                                @if ($errors->has('ballon'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('ballon') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-sm-6" style="height: 50px;">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-5 control-label">Priority | Balloting
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-7">
                                            <div class="input-group" style="width:100%">
                                            
                                                <div class="newclass" style="padding: 0;">
                                                    {{-- <input type="number" min="0" max="10"
                                                        value="{{ $bulleting_priority }}" class="form-control"
                                                        style="width:10rem" name="bulleting_priority"> --}}

                                                    <select class='form-control select-options' name="bulleting_priority"
                                                        id='bulleting_priority' style='width:10rem;'>
                                                        <option value='{{ $bulleting_priority }}' selected>
                                                            {{ $bulleting_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%; margin-left:100px; margin-top: -38px; width: 70%;"
                                                    class="form-control" name="balloting" value="{{ $plan->bulleting }}"
                                                    id="bulleting" placeholder="Enter Balloting %" min="0"
                                                    max="100">

                                                @if ($errors->has('bulleting'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('bulleting') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-sm-7" style="margin-left: 15px;">
                                    <div class="form-group">
                                        <label for="inputPassword3" class="col-sm-4 control-label">Priority | Semi Annual Installment
                                            <span style="color: red">*</span></label>
                                        <div class="col-sm-6" >
                                            <div class="input-group" >

                                                <div class="input-group-addon" style="padding: 0;">


                                                    <select class='form-control select-options'
                                                        name="semi_annual_priority" id='semi_annual_priority'
                                                        style='width:10rem;'>
                                                        <option value='{{ $semi_annual_installment_priority }}' selected>
                                                            {{ $semi_annual_installment_priority }}</option>



                                                    </select>
                                                </div>

                                                <input type="number" step="any" style="margin-top:0.5%"
                                                    class="form-control" name="semi_annual"
                                                    value="{{ $plan->semi_installment }}" id="semi_annual"
                                                    placeholder="Enter Semi Annual Installment %" min="0"
                                                    max="100">

                                                @if ($errors->has('semi_annual'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('semi_annual') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>



                        <div class="form-group m-b-0">
                            <div class="col-sm-offset-4 col-sm-8">
                                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="margin-left: 20%; width: 20%;">Save</button>
                            </div>
                        </div>


                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script type="text/javascript">
        function validatePossessionDate(self) {
            var selectedPossessionDate = formatDate($('#possession_date').val());
            var curentPossessionDate = formatDate('{{ $plan->possession_date }}');

            if (selectedPossessionDate != curentPossessionDate) {
                if (confirm(
                        'Are You Sure you want to change your possession date? It will effect all previous possession dates.'
                    )) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }

            return false;
        }

        function formatDate(date) {
            var d = new Date(date),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();

            if (month.length < 2)
                month = '0' + month;
            if (day.length < 2)
                day = '0' + day;

            return [year, month, day].join('-');
        }
        var disabledOptions = [];

        function totalPriority(id) {

            value = $('#' + id).find(":selected").val();

            for (var i = 0; i <= {{ \App\Receipt::total_payment_head }}; i++) {
                if (value != i) {
                    $('#' + id).append(`<option value='` + i + `'>` + i + `</option>`);
                } else if (value == i) {
                    // $('.select-options').not().find('option[value="' + selectedOption + '"]').prop('disabled', true);
                    $('.select-options').each(function() {

                        if (this.id != id) {
                            if (value != '0') {
                                $(this).find('option').prop('disabled', false);
                                $(this).find('option[value="' + value + '"]').prop('disabled', true);


                            }
                        }
                    });
                    if (value != '0') {
                        disabledOptions.push(value);
                    }



                    $('.select-options').each(function() {
                        var selectedOption = $(this).find(':selected').val();
                        if (disabledOptions.includes(selectedOption)) {
                            $('.select-options').not('#' + this.id).find('option[value="' + selectedOption + '"]')
                                .prop('disabled', true)

                        }
                    });

                }

            }
        }

        // $('.select-options').change(function() {

        //     var selectedOption = $(this).val();

        //     $('.select-options').find('option[value="' + selectedOption + '"]').prop('disabled', false);
        //   });
        $('.select-options').on('change', function() {

            $('.select-options').chosen('destroy');
            var selectedValues = [];
            var currentId = $(this).attr('id');
           
            $('.select-options').each(function() {
                // if (this.id != currentId) {
                var currentSelected = $(this).find(':selected').val();
                if (currentSelected != '' && currentSelected != 0) {
                    console.log('current_selected:',currentSelected);
                    selectedValues.push(currentSelected);
                }
                // }
            });
            // $('.select-options').each(function() {
            //     var selectedOption = $(this).find(':selected').val();
            //     console.log('selected_option',selectedOption);
            //     if (selectedValues.includes(selectedOption)) {
            //         $('.select-options').not('#' + this.id).find('option[value="' + selectedOption + '"]')
            //             .prop('disabled', true)

            //     }
            // });
            $('.select-options').each(function() {
                // if (this.id != currentId) {
                    $(this).find('option').prop('disabled', false);
                    for (var i = 0; i < selectedValues.length; i++) {
                        var selectedOption = $(this).find(':selected').val();
                        if(selectedOption != selectedValues[i]){
                        $(this).find('option[value="' + selectedValues[i] + '"]').prop('disabled', true);
                    }
                }
                // }
            });
          
            // $('.select-options').trigger("chosen:updated");
           $('.select-options').chosen();
        });


        totalPriority('down_payment_priority');
        totalPriority('installment_priority');
        totalPriority('possession_priority');
        totalPriority('allotment_priority');
        totalPriority('confirmation_priority');
        totalPriority('booking_priority');
        // totalPriority('development_priority');
        totalPriority('file_processing_priority');
        totalPriority('registration_priority');

        totalPriority('ballon_priority');
        totalPriority('bulleting_priority');
        totalPriority('semi_annual_priority');





        $('.select-options').chosen();
    </script>
@stop
