@extends('layouts.app')

@section('title')
Schedule Plan Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="">Schedule Plan</a></li>

      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                <a href="{{route('schedule.editView',['id'=>$plan->id])}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Update Schedule
                                </a>
                            </div>
                            <h3 class="box-title">Schedule Plan Detail</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>

                                               
                                                <tr>
                                                    <td>Priority | Down Payment</td>
                                                    <td>{{round($down_payment_priority)}} - ({{round($plan->down_payment)}} %) </td>
                                                </tr>


                                                 <tr>
                                                    <td>Priority | Monthly Installment</td>
                                                    <td>{{round($installment_priority)}} - ({{round($plan->monthly_installment)}} %) </td>
                                                </tr>
                                                 

                                                 <tr>
                                                    <td>Priority | Possession</td>
                                                    <td>{{round($possession_priority)}} -  ({{round($plan->possession)}} %) </td>
                                                </tr>




                                                 <tr>
                                                    <td>Priority | Allotment</td>
                                                    <td>{{round($allotment_priority)}} - ({{round($plan->allotment)}} %) </td>
                                                </tr>


                                                 <tr>
                                                    <td>Priority | Confirmation</td>
                                                    <td>{{round($confirmation_priority)}} - ({{round($plan->confirmation)}} %) </td>
                                                </tr>
                                                  <tr>
                                                    <td>Priority | Booking</td>
                                                    <td>{{round($booking_priority)}} - ({{round($plan->booking)}} %) </td>
                                                </tr>

                                                 

 <tr>
                                                    <td>Priority | File Processing</td>
                                                    <td>{{round($file_processing_priority)}} - ({{round($plan->file_processing)}} %) </td>
                                                </tr>

                                                 <tr>
                                                    <td>Priority | Registration</td>
                                                    <td>{{round($registration_priority)}} -  ({{round($plan->registration)}} %) </td>
                                                </tr>

                                                <tr>
                                                    <td>Priority | Ballon</td>
                                                    <td>{{round($ballon_priority)}} -  ({{round($plan->ballon)}} %) </td>
                                                </tr>
                                                <tr>
                                                    <td>Priority | Balloting</td>
                                                    <td>{{round($bulleting_priority)}} -  ({{round($plan->bulleting)}} %) </td>
                                                </tr>
                                                <tr>
                                                    <td>Priority | Semi Annual Installment</td>
                                                    <td>{{round($semi_annual_installment_priority)}} -  ({{round($plan->semi_installment)}} %) </td>
                                                </tr>




                                                <tr>
                                                    <td>Possession Date</td>
                                                    <td> {{$plan->possession_date ? date('d-F-Y' , strtotime( $plan->possession_date)) : 'system default date'}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Voucher Valid After</td>
                                                    <td> {{$plan->voucher_valid_after ? date('d-F-Y' , strtotime( $plan->voucher_valid_after)) : 'no date added'}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Total Months</td>
                                                    <td> {{$plan->total_months}} months</td>
                                                </tr>

                                                <tr>
                                                    <td>Late Fine</td>
                                                    <td> {{$plan->fine}}</td>
                                                </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$plan->updated_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->



@stop