@extends('layouts.app')


@section('title')
    SMS Log
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('email-sms.index') }}"> Email Sms Type</a></li>


        <li class="active"> SMS Log</li>

    </ol>
@stop

@section('content')
    <!-- .container-fluid -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12" style="margin-top: 15px;">
                <div class="panel panel-info">
                    <div class="panel-heading">Search SMS</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">

                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Title</label>
                                                <select id="title" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach($email_sms_type as $email)
                                                    <option value="{{$email->name}}">{{$email->name}}</option>
                                                    
                                                    @endforeach

                                                    
                                                </select>

                                            </div>
                                        </div>
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Number</label>

                                                <select id="mobile" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach($customer_mobile as $mobile)
                                                    <option value="{{$mobile->mobile_number}}">{{$mobile->mobile_number}}</option>
                                                    @endforeach
                                                   
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By status</label>
                                                <select id="status" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    <option value="1">Success</option>
                                                    <option value="2">Fail</option>

                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                    </div>

                                </div>
                                <div class="form-actions">
                                    <button type="button" class="btn btn-success search-customer"> <i
                                            class="fa fa-check"></i> Search</button>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">


                    </div>
                    <h3 class="box-title">All SMS</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>

                                    <th>Title</th>
                                    <th>Receiver Number</th>
                                    <th>Content</th>
                                    <th>Total Character</th>
                                    <th>Time</th>
                                    <th>Status</th>

                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $count = 1; ?>
                                @foreach ($sms_log as $log)
                                    <tr>
                                        <td>{{ $count++ }}</td>
                                        <td>{{ $log->title }}</td>
                                        <td>{{ $log->receiver_number }}</td>
                                        <td>{{ $log->content }}</td>
                                        <td>{{ $log->total_charcter }}</td>



                                        <td>{{ date('Y-m-d h:i:s A', strtotime($log->created_at)) }}</td>
                                        <td>

                                            @if ($log->status == 1)
                                                <span class="label label-success">Success</span>
                                            @else
                                                <span class="label label-danger">Fail</span>
                                            @endif
                                        </td>


                                        <td>
                                            @if ($log->status != 1)
                                                <form action="{{ route('emaillog.resend-email') }}" method="post"
                                                    style='display: inline;'>

                                                    {!! csrf_field() !!}

                                                    <input type='hidden' name='value' value="{{ $log->id }}">

                                                    <button class="btn btn-link btn-s" style="color:red;" type="submit"
                                                        name="action" value="resend" data-toggle="confirmation"
                                                        data-title="Are you sure to resend?">
                                                        <i class="fa fa-paper-plane-o" aria-hidden="true"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </td>

                                    </tr>
                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- ./container-fluid -->
@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        $(document).ready(function() {
            $('#myTable').DataTable();
        });
        $('.search-customer').on('click', function() {
                $('.preloader').fadeIn();
                title = $('#title').val();
                mobile = $('#mobile').val();
               
                status = $('#status').val();
                


                if (title == 0 && mobile == 0  && status == 0) {
                    toastr.warning("please select any option.");
                    $('.preloader').fadeOut();
                    return false;
                }

                var data = {
                    'title': title,
                    'mobile': mobile,
                  
                    'status': status,
                     
                };

                $.get('{{route("smslog.index.updateTable")}}', data, function(data) {
                    document.getElementById('update-table').innerHTML = data;

                    $('#myTable').DataTable({
                        'pageLength': 50,
                        'paging': false,
                        'searching': false,
                        'info': true,
                        'dom': 'Bfrtip',
                        'buttons': [
                            'copy', 'csv', 'excel', 'pdf', 'print'
                        ]
                    });
                    toastr.success("Search updated.");


                    $('.preloader').fadeOut();
                });
            });
    </script>
@stop
