@extends('layouts.app')

@section('title')
Edit  Category 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-unit-category')
        <li ><a href="{{route('unitCategory.all')}}"> Categories </a></li>
        @endpermission
        <li class="active">Edit Category</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit  Category</h3>
                            <p class="text-muted m-b-30 font-13"> Update the information </p>
                            <form class="form-horizontal" action="{{route('unitCategory.update')}}" method="post" style="margin-top: 40px;">
                                <input type='hidden' name='id' value='{{$category->id}}'>
                               {{csrf_field()}}
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{$category->name}}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Amount<span style="color: red">*</span><br> (use percent 
                                        @if($category->is_percent)
                                            <input type="checkbox" onclick="percentCheckbox()" name="is_percent" checked="" id="is_percent" value="1">
                                        @else
                                            <input type="checkbox" onclick="percentCheckbox()" name="is_percent" id="is_percent" value="1">
                                        @endif
                                    
                                    )</label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                        @if($category->is_percent)
                                            <span class="input-group-addon" style="font-size: 12px; padding: 8px" id="amount_input">%</span>
                                        @else
                                            <span class="input-group-addon" style="font-size: 12px; padding: 8px" id="amount_input">PKR</span>
                                        @endif

                                            <input  type="text" class="form-control" name="percent" value="{{$category->percent}}" id="exampleInputuname" placeholder="Percentage">
                                        @if ($errors->has('percent'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('percent') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Is Percent<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">
                                            <select class="form-control chosen-select" name="is_percent">
                                                @if($category->is_percent)
                                                <option value="0">NO</option>
                                                <option selected="" value="1">YES</option>
                                                @else
                                                <option selected="" value="0">NO</option>
                                                <option value="1">YES</option>

                                                @endif
                                                
                                            </select>

                                            
                                        @if ($errors->has('is_percent'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('is_percent') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div> -->

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100px;">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>

        function percentCheckbox() {

        if($('#is_percent').prop("checked") == false) {
            document.getElementById('amount_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('amount_input').innerHTML = '%';
        }
    }

    </script>

@stop
