@extends('layouts.app')

@section('title')
@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp

Edit  {{$map}} 
@stop

@section('breadcrumb')
@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
         @permission('view-unit-floor')
        <li ><a href="{{route('unitFloor.all')}}"> {{$map}}s </a></li>
        @endpermission
        <li class="active">Edit {{$map}}</li>
      </ol>
@stop
@section('content')

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp

@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Edit {{$map}}</h3><hr>
                            <form class="form-horizontal" action="{{route('unitFloor.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$floor->id}}">
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{$floor->name}}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Block<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width: 29%;">

                                            <select style="width: 300px" name="unit_block_id" class="form-control chosen-select">
                                                <option value="" selected="">None</option>
                                                @foreach($blocks as $b)
                                                @if($floor->unit_block_id == $b->id)
                                                <option selected="" value="{{$b->id}}">{{$b->name}}</option>
                                                @else
                                                <option value="{{$b->id}}">{{$b->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>

                                        @if ($errors->has('unit_block_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('unit_block_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <div class="input_fields_wrap1">
                                        <button type="button" style="float: left!important;" class="btn btn-default add_field_button" >Add New Type</button>
                                        <div class="clearfix"></div>
                                        <div>
                                            @foreach($floor->unitFloors as $b)
                                            

                                <div class="form-group" style="margin-left: -2px;">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Type <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width: 29%;">

                                            <select style="width: 300px" name="type[]" class="form-control chosen-select">
                                                @foreach($types as $type)
                                                @if($b->unit_type_id == $type->id)
                                                <option selected="" value="{{$type->id}}">{{$type->name}}</option>
                                                @else
                                                <option value="{{$type->id}}">{{$type->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>

                                        @if ($errors->has('type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                @endforeach
                                        </div>
                                    </div>


                                </div>

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100px;">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script type="text/javascript">
    $(document).ready(function() {
    var max_fields      = 5; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap1"); //Fields wrapper
     var wrapper1         = $(".input_fields_wrap"); //Fields wrapper
    var add_button      = $(".add_field_button"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
$(wrapper).prepend('<div><br><br><div class="form-group"><label for="exampleInputuname" class="col-sm-2 control-label"> Type <span style="color: red">*</span></label><div class="col-sm-10"><div class="input-group" ><select style="width: 300px" name="type[]" class="form-control chosen-select">@foreach($types as $t)<option value="{{$t->id}}">{{$t->name}}</option>@endforeach</select></div></div></div>   <a href="#" class="remove_field">Remove</a>'); //add input box

$('.chosen-select').chosen-select();
        $(".bdpk").datepicker(
{
  dateFormat: "dd-mm-yy"
});
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});
</script>
@stop