@extends('layouts.app')

@section('title')

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp

All  {{$map}}s 
@stop

@section('breadcrumb')

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp

<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All {{$map}}s</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">

                                 <!-- <a href="{{route('unitFloor.oldRates')}}" class="btn  btn-default">
                                    &nbsp; Old Rates
                                </a> -->

                                <a href="{{route('unitFloor.addView')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add new  {{$map}}
                                </a>
                            </div>
                            <h3 class="box-title">All  {{$map}}s</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Block</th>
                                            <th>Type</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allUnitFloors as $floor)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$floor->name}}</td>
                                            <td>{{$floor->unitBlock? $floor->unitBlock->name : ''}}</td>

                                           <td>@foreach($floor->unitFloors as $b)
                                            @if($b->type) 
                                            [{{$b->type->name}}]
                                            <br>
                                            @endif

                                            @endforeach
                                           </td>
                                            <td class="text-nowrap">
                                                 @permission('edit-unit-floor')
                                                <a href="{{route('unitFloor.editView',['id'=>$floor->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                 @permission('delete-unit-floor')
                                                <a href="{{route('unitFloor.delete',['id'=>$floor->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':false,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        
    
    </script>
@stop