@extends('layouts.app')

@section('title')
Old Rates 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Streets</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	
                            <h3 class="box-title">Old Rates</h3>

                            <div class="table-responsive">
                                <table  class="table table-striped">

                                    @foreach($allFloors as $floor)
                                    <tr>
                                        <td><b>Street {{$floor->name}}</b></td>

                                        @foreach($allUnitTypes[$floor->id] as $type)

                                        <td>
                                           <b>{{$type->type->name}}</b>
                                           


                                           <ul>
                                        @foreach($allUnitRates[$floor->id][$type->id] as $rates)
                                        <br><li>{{number_format($rates->rate)}}  - [ {{date('d M,Y',strtotime($rates->created_at))}} - {{date('d M,Y',strtotime($rates->updated_at))}} ]</li>
                                        @endforeach
                                        <b><li>{{number_format($newRates[$floor->id][$type->id]->rate)}} - {{date('d M,Y',strtotime($newRates[$floor->id][$type->id]->created_at))}}</li></b>
                                    </ul>

                                        </td>

                                        @endforeach
                                        
                                    </tr>

                                    @endforeach

                                        
                                    

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();
    });
    
    </script>
@stop