@extends('layouts.app')

@section('title')
    Add New Chart of Account
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-chart-of-account')
            <li><a href="{{ route('chart-of-account.all') }}">Chart of Account</a></li>
        @endpermission

        <li class="active">Add Account</li>
    </ol>
@stop
@section('content')

    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                <div class="white-box1">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Add New Account</h3>
                    <p class="text-muted m-b-30 font-13"> Add Information </p>
                    <div class="col-md-6">
                        <form class="form-horizontal" action="{{ route('chart-of-account.insert') }}" method="post">
                            {{ csrf_field() }}

                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> SubAccount of </label>
                                <div class="col-sm-8">
                                    <div class="input-group" style="width: 100%">

                                        <select class="form-control chosen-select" name="sub_account_id" onchange="getSubAccount(this.value)">
                                            <option value=''>None</option>
                                            @foreach ($accounts as $a)
                                                <option value="{{ $a->id }}">{{ $a->number }} -
                                                    {{ $a->name }}</option>
                                            @endforeach
                                        </select>


                                        @if ($errors->has('sub_account_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('sub_account_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Type <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <div class="input-group" style="width:100%;display: inline-block;">

                                        <select class="form-control chosen-select" name="account_type" id="account_type_id"
                                            onchange="getdata(this.value)">
                                            <option>None</option>
                                            @foreach ($types as $t)
                                                <option value="{{ $t->id }}">{{ $t->number }} -
                                                    {{ $t->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" id="account_type_id_hidden" name="account_type_id" value="">
                                        @if ($errors->has('account_type_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('account_type_id') }}</strong>
                                            </span>
                                        @endif



                                    </div>

                                </div>

                            </div>


                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Name <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <div class="input-group" style="width: 100%">

                                        <input type="text" class="form-control" name="name"
                                            value="{{ old('name') }}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('name') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            


                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Number <span
                                        style="color: red">*</span></label>
                                <div class="col-sm-8">
                                    <div class="input-group" style="width: 100%">

                                        <input type="text" class="form-control" name="number"
                                            value="{{ old('number') }}" id="account_number" placeholder="Number" readonly>
                                        @if ($errors->has('number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('number') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-4 control-label"> Description </label>
                                <div class="col-sm-8">
                                    <div class="input-group" style="width: 100%">

                                        <textarea rows="4" class="form-control" name="description">{{ old('description') }} </textarea>
                                        @if ($errors->has('description'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('description') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>







                            <div class=" col-sm-4">&nbsp;</div>
                            <div class=" col-sm-4">
                                <div class="form-group ">
                                    <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                        style="width: 100%; margin-left: 100px;">Save</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    <div class="col-md-6">

                        <div id="type-div" style="border: 1px solid #015c4e; display: none;padding: 8px">

                            <div style="display: inline;" id="type-result">

                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script>
        function updateSummary(id) {

            console.log(id);
            var data = {
                'id': id
            };
            $.get('/chart-of-account/get-account-description', data, function(data) {


                document.getElementById('type-result').innerHTML = data;
                document.getElementById('type-div').style.display = 'block';
            });

        }
        function getdata(id){
            var data = {
                'id': id
            };
            $.get('{{route("chart-of-account.getNumber")}}', data, function(data) {

$('#account_number').val(data);
$('#account_type_id_hidden').val(id);
              
            });
        }
        function getSubAccount(id){
            if(id != ''){

                var data = {
                'id': id
            };
            $.get('{{route("chart-of-account.SubgetNumber")}}', data, function(data) {

                // $('#my-select').val(valueToSelect);
               
                $('#account_type_id option[value!="'+data.account_type+'"]').prop('disabled', true);    
                $('#account_type_id').val(data.account_type).trigger('chosen:updated');
                 $('#account_number').val(data.number);
                 $('#account_type_id_hidden').val(data.account_type);
              
            });
            }
           else if(id == ''){
    $('#account_type_id option').prop('disabled', false);
    $('#account_type_id').val('').trigger('chosen:updated');
    $('#account_number').val('');  
    $('#account_type_id_hidden').val('');   
  
  } 
           
            // 
        }
    </script>
@stop
