@extends('layouts.app')

@section('title')
Closing Balance Report
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Closing Report</li>
      </ol>
@stop
@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<style type="text/css">
    b {
        font-weight: 700;
    }
    .btm-margin{
        border-bottom: 3px solid white;
    }
    .bg-grey {
        background-color: #efefef;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .pd-5{
        padding:5px;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    
    /*.us_table_bdr*/
    /*{*/
        
    /*}*/
    
    table {
    border-collapse: collapse !important;
  
}


    .us_table_bdr
    {
          border: 2px solid black !important;
    }
    
    .us_table_bdr>tbody>tr>td, .us_table_bdr>tbody>tr>th, .us_table_bdr>tfoot>tr>td, .us_table_bdr>tfoot>tr>th {
    border: 1px solid gray !important;
    /*border-collapse: collapse !important;*/
    }
    .border_th
    {
       border: 2px solid black !important;
    }

       @media print {
         .us_table_bdr
    {
          border:3px solid black !important;
    }
    
     .border_th
    {
        border:3px solid black  !important;
    }
     .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px !important;
    font-size: 12px;
    /*border: 1px solid #ccc;*/
    }
    table.dataTable{
        border:none;
        border-collapse: collapse !important;
    }

    .br-btm {
           /*border-bottom: 1px solid #e6e3e3;*/
    }
    .br-right {
         /*border-right: 1px solid #e6e3e3;*/
    }
    .txt-c {
        text-align: center;
    }
    table.dataTable thead td, table.dataTable thead th {
    /*border-bottom: none !important;*/
    }
  table.dataTable.no-footer {
    /*border-bottom: none !important;*/
    }
    a{
        color: black !important
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    /*border-bottom: none !important;*/
    }
     .bdr thead tr th  {
    /*border: 1px solid #2e3233 !important;*/
    /*background: #eee;*/
    }
    .container-fluid {
    padding: 3px 0px 5px;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
    }
</style>
<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">


                                    
    <div class="white-box" style="text-align: center;" id="update-report">
        <h3><strong>{{env('APP_NAME')}}</strong></h3>
        <h4 ><strong>DAILY {{$account->name}}  REPORT  </strong></h4>
        <h6>From {{date('d/m/Y',strtotime($from))}} to  {{date('d/m/Y',strtotime($to))}}</h6>
        
        
        <div class="text-left" style="height:70px;">
        <button  class="btn btn-default btn-outline no-print" style="position: relative;left: 5%;bottom: 3rem;z-index: 9999;background-color: rgba(0, 0, 0, 0.1);border: 1px solid black;border: 1px solid rgba(0, 0, 0, 0.3);" onclick="window.print();return false;" type="button"> <span> Print</span> </button>
        </div>
                                    
        <div class="row" style="    margin-top: -10rem;">

            @if($level == 3)
        

        <div class="col-md-12 pro-cart" >
            
            
            <table id="example1" class="table table-bordered bdr" style="font-size:12px;">
                     <thead>
                        <tr>
                             <th class="border_th" style="width: 235.861px !important;">Code</th>
                            <th class="border_th" style="width: 185.861px !important;">Name</th>
                            <th class="border_th" style="width: 120.861px !important;">Date</th>
                            <th class="border_th" style="width: 80.861px !important;">Num</th>
                            <th class="border_th" style="width: 130.861px !important;">Cheque No.</th>
                            <th class="border_th" >Party</th>
                            <th class="border_th" >Narration</th>
                            <th class="border_th" >Account</th>
                            <th class="border_th" >Debit</th>
                            <th class="border_th" >Credit</th>
                            <th class="border_th" >Balance</th>
                        </tr>

                     </thead>
                     <tbody>
                        <tr>
                            <?php $balance = $pre_balance; $debit = $credit = 0;?>
                            <td   style="text-align:left; padding-left: 2%; font-size: 12px;"><b>{{$account->number}}</b> </td>
                            <td   style="text-align:left; padding-left: 2%; font-size: 12px;"><b>{{$account->name}}</b> </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-left" style="padding-left: 2%;">OPENING BALANCE</td>
                            <td></td>
                            
                            <td></td>
                            <td></td>
                            


                            @if($balance < 0)
                            <td class="text-right"><b>({{number_format(abs($balance))}})</b></td>
                            @else
                            <td class="text-right"><b>{{number_format($balance)}}</b></td>
                            @endif
                            
                        </tr>

                        @foreach($transactions as $t)
                        <tr>
                            <td></td>
                            @if($t->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td class="text-left" style="padding-left: 2%;">CRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td class="text-left" style="padding-left: 2%;">BRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td class="text-left" style="padding-left: 2%;">CPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td class="text-left" style="padding-left: 2%;">BPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td class="text-left" style="padding-left: 2%;">JV-{{$t->voucher_no}}</td>
                                            @else
                                            <td></td>
                                            @endif
                            <td class="text-left" style="padding-left: 2%;">{{date('d/m/Y',strtotime($t->date))}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->entry_no}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->cheaque_no}}
                            </td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->controlAccount ? $t->controlAccount->name : ''}}
                            </td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->memo}}</td>
                            
                            <td class="text-left">
                                @foreach($accountHit[$t->entry_no] as $acc)
                                {{$acc->account->number}} - {{$acc->account->name}}<br>
                                @endforeach
                            </td>
                            <td class="text-left">{{$t->amount > 0 ? number_format(abs($t->amount)) : ''}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td class="text-left">{{$t->amount < 0 ? number_format(abs($t->amount)) : ''}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>

                           
                            <?php $balance += $t->amount;?>
                           

                            @if($balance < 0)
                            <td class="text-right">({{number_format(abs($balance))}})</td>
                            @elseif($balance > 0)
                            <td class="text-right">{{number_format($balance)}}</td>
                            @else
                            <td class="text-right"><u>-</u></td>
                            @endif
                        </tr>
                        @endforeach

                        <tr ><td></td>
                            <td   style="text-align:left; padding-left: 2%; font-size: 12px;">CLOSING BALANCE </td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            
                             <td class="text-right" style="font-size:12px; ">
                                @if($debit < 0)
                                ({{number_format(abs(number_format($debit)))}})
                                @elseif($debit > 0)
                                {{number_format($debit)}}
                                @else
                                -
                                @endif
                            </td>
                            <td class="text-right" style="font-size:12px;">
                                @if($credit < 0)
                                ({{number_format(abs(number_format($credit)))}})
                                @elseif($credit > 0)
                                {{number_format($credit)}}
                                @else
                                -
                                @endif
                            </td>
                            @if($balance < 0)
                            <td class="text-right" style="font-size:12px;">({{number_format(abs($balance))}})</td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;">{{number_format($balance)}}</td>
                            @else
                            <td class="text-right">-</td>
                            @endif

                        </tr>

                 </tbody>
            </table>

        </div>
        <div class="row">
                                   
                                    <div class="col-md-12">

                                                            <div class="col-md-4 col-xs-4 text-center">
                                   &nbsp;
                                    </div>

                                <div class="col-md-4 col-xs-4 text-center">
                                    &nbsp;
                                    </div>
                            </div>
                        </div>
                        
                        
                        
                      <br><br><br>
                            <div class="col-md-12">

                                <div class="col-md-4 col-xs-4 text-center">
                                   <span><b></b></span> 
                                    <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                  <div style="border-top: 1px solid black;"> Prepared By</div>
                                    </div>
                                </div>


                                <div class="col-md-4 col-xs-4 text-center">
                                <span><b></b></span> 
                                <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                <div style="border-top: 1px solid black;">Checked By</div>
                                </div>
                                </div>
                                

                                    <div class="col-md-4 col-xs-4 text-center">
                                <span><b></b></span> 
                                <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                <div style="border-top: 1px solid black;">Approved By</div>
                                </div>
                                </div>
                                
                                
                            </div>
                            <br><br><br>

        @elseif($level == 2)

        <div class="col-md-12 pro-cart" >
            <table id="example1" class="table table-bordered bdr us_table_bdr" style="font-size:12px;">
                     <thead>
                        <tr>
                   
                            <th class="border_th" style="width: 235.861px !important;">Code</th>
                            <th class="border_th" style="width: 185.861px !important;">Name</th>
                            <th class="border_th" style="width: 120.861px !important;">Date</th>
                            <th class="border_th" style="width: 80.861px !important;">Num</th>
                            <th class="border_th" style="width: 130.861px !important;">Cheque No.</th>
                            <th class="border_th" >Party</th>
                            <th class="border_th" >Narration</th>
                            <th class="border_th" >Debit</th>
                            <th class="border_th" >Credit</th>
                            <th class="border_th" >Balance</th>
                            
                        </tr>

                     </thead>
                     <tbody>
                       
                            <?php $balance = 0; $debit = $credit = 0;$tdebit = $tcredit = $tbalance = 0;?>
                            
                       
                        
                        @foreach($childAccounts as $cA)
                        
                        <tr>
                            <?php $balance = $preBalance[$cA->id]; $debit = $credit = 0;?>
                            <td   style="text-align:left;padding-left:2%;font-size: 12px;"><b>{{$cA->number}}</b> </td>
                             <td   style="text-align:left;padding-left:2%;font-size: 12px;"><b>{{$cA->name}}</b> </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-left" style="padding-left: 2%;">OPENING BALANCE</td>
                         
                            <td></td>
                            <td></td>
                            
                            @if($balance < 0)
                            <td class="text-right" style="font-size:12px;"><b>({{number_format(abs($balance))}})</b></td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;"><b>{{number_format($balance)}}</b></td>
                            @else
                            <td class="text-right">-</td>
                            @endif
    
                            
                        </tr>

                        @foreach($transactions[$cA->id] as $t)
                        <tr><td></td>
                            @if($t->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td class="text-left" style="padding-left: 2%;">CRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td class="text-left" style="padding-left: 2%;">BRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td class="text-left" style="padding-left: 2%;">CPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td class="text-left" style="padding-left: 2%;">BPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td class="text-left" style="padding-left: 2%;">JV-{{$t->voucher_no}}</td>
                                            @else
                                            <td></td>
                                            @endif
                            <td class="text-left" style="padding-left: 2%;">{{date('d/m/Y',strtotime($t->date))}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->entry_no}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->cheaque_no}}
                            </td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->controlAccount ? $t->controlAccount->name : ''}}
                            </td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->memo}}</td>
                            
                            
                            <td class="text-right">{{$t->amount > 0 ? number_format(abs($t->amount)) : ''}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td class="text-right">{{$t->amount < 0 ? number_format(abs($t->amount)) : ''}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>

                        
                            
                            <?php $balance += $t->amount;?>
                            

                            @if($balance < 0)
                            <td class="text-right">({{number_format(abs($balance))}})</td>
                            @else
                            <td class="text-right">{{number_format($balance)}}</td>
                            @endif
                        </tr>
                        @endforeach

                        <tr >
                            <td></td>
                            <td   style="text-align:left; padding-left: 2%; font-size: 12px;">CLOSING BALANCE </td>
                            <td></td>
                            <td ></td>
                            <td ></td>
                            
                            
                            <td ></td>
                            <td ></td>
                            
                           <td class="text-right" style="font-size:12px; ">
                                @if($debit < 0)
                                ({{number_format(abs(number_format($debit)))}})
                                @elseif($debit > 0)
                                {{number_format($debit)}}
                                @else
                                -
                                @endif
                            </td>
                            <td class="text-right" style="font-size:12px;">
                                @if($credit < 0)
                                ({{number_format(abs(number_format($credit)))}})
                                @elseif($credit > 0)
                                {{number_format($credit)}}
                                @else
                                -
                                @endif
                           </td>
                            @if($balance < 0)
                            <td class="text-right" style="font-size:12px;">({{number_format(abs($balance))}})</td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;">{{number_format($balance)}}</td>
                            @else
                           <td>-</td> 
                            @endif


                        </tr>
                        
                        <tr >
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            
                           
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>

                        </tr>
                        
                        <?php $tdebit += $debit;$tcredit += $credit; $tbalance += $balance;?>
                        
                        @endforeach


                        <tr >
                            <td></td>
                             <td   style="text-align:left;font-size: 14px;"><b>TOTAL {{$account->name}}</b> </td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            <td></td>
                            <td ></td>
                            
                           <td class="text-right" style="font-size:14px; "><b>
                                @if($tdebit < 0)
                                ({{number_format(abs(number_format($tdebit)))}})
                                @elseif($tdebit > 0)
                                {{number_format($tdebit)}}
                                @else
                                -
                                @endif
                            </b></td>
                            <td class="text-right" style="font-size:14px;"><b>
                                @if($tcredit < 0)
                                ({{number_format(abs(number_format($tcredit)))}})
                                @elseif($tcredit > 0)
                                {{number_format($tcredit)}}
                                @else
                                -
                                @endif
                            </b></td>
                            @if($tbalance < 0)
                            <td class="text-right" style="font-size:14px;"><b>({{number_format(abs($tbalance))}})</b></td>
                            @elseif($tbalance > 0)
                            <td class="text-right" style="font-size:14px;"><b>{{number_format($tbalance)}}</b></td>
                            @else
                            <td>-</td>
                            @endif

                        </tr>


                        

                    
                 </tbody>
            </table>
            
            
               
        
                        <div class="col-md-12 printableArea" >
                            
                              <div class="text-center">
                            
                                <h3><strong>{{env('APP_NAME')}}</strong></h3>
                                <h4 ><strong>SUMMARY {{$account->name}} </strong></h4>
                                <h6>From {{date('d/m/Y',strtotime($from))}} to  {{date('d/m/Y',strtotime($to))}}</h6>
                            
                            </div>
                        
            
            <table id="example1" class="table table-bordered bdr" style="font-size:12px;">
                     <thead>
                        <tr>
                            <th>Code</th>
                            <th>Head Of Account</th>
                       
                            <th>Balance</th>
                        </tr>

                     </thead>
                     <tbody>
                        
                            <?php $balance = 0; $debit = $credit = 0;$tdebit = $tcredit = $tbalance = 0;?>
                        
                        @foreach($childAccounts as $cA)
                        
                     
                           <?php $balance = $preBalance[$cA->id]; $debit = $credit = 0;?>
                        

                        @foreach($transactions[$cA->id] as $t)
                       
                            
                         
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            
                          
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                           

                        
                            
                            <?php $balance += $t->amount;?>
                            

                    
                       
                        @endforeach

                        <tr >
                           <td   style="text-align:left;font-size: 12px;"><b>{{$cA->number}}</b> </td>
                             <td   style="text-align:left;font-size: 12px;"><b>{{$cA->name}}</b> </td> 

                         
                            @if($balance < 0)
                            <td class="text-right" style="font-size:12px;"><b>({{number_format(abs($balance))}})</b></td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;"><b>{{number_format($balance)}}</b></td>
                            @else
                            <td class="text-right">-</td>
                            @endif


                        </tr>
                  
                        
                        <?php $tdebit += $debit;$tcredit += $credit; $tbalance += $balance;?>
                        
                        @endforeach


                        <tr >
                            <td></td>
                             <td   style="text-align:left;font-size: 14px;"><b>TOTAL {{$account->name}}
                            
                           
                            @if($tbalance < 0)
                            <td class="text-right" style="font-size:14px;"><b>({{number_format(abs($tbalance))}})</b></td>
                            @elseif($tbalance > 0)
                            <td class="text-right" style="font-size:14px;"><b>{{number_format($tbalance)}}</b></td>
                            @else
                            <td class="text-right">-</td>
                            @endif

                        </tr>


                        

                    
                 </tbody>
            </table>



<br><br><br>
                            <div class="col-md-12">

                                <div class="col-md-4 col-xs-4 text-center">
                                   <span><b></b></span> 
                                    <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                  <div style="border-top: 1px solid black;"> Prepared By</div>
                                    </div>
                                </div>


                                <div class="col-md-4 col-xs-4 text-center">
                                <span><b></b></span> 
                                <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                <div style="border-top: 1px solid black;">Checked By</div>
                                </div>
                                </div>
                                

                                    <div class="col-md-4 col-xs-4 text-center">
                                <span><b></b></span> 
                                <div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
                                <div style="border-top: 1px solid black;">Approved By</div>
                                </div>
                                </div>
                                
                                
                            </div>
                            
                            
                            
        </div>
        

        </div>
                          

                    


                            
                            
                            <div class="text-right col-md-12" style="height:70px;">
                            <button  class="btn btn-default btn-outline no-print" id="summary_print" style="margin-top: 2rem;margin-right: 5rem;background-color: rgba(0, 0, 0, 0.1);border: 1px solid black;border: 1px solid rgba(0, 0, 0, 0.3);"  type="button"> <span> Print Summary</span> </button>
                            </div>
                            
                            
                            <br><br><br>
       
        
        
        @elseif($level == 1)

        <div class="col-md-12 pro-cart table-responsive" >
            <table id="example1" class="table table-bordered bdr us_table_bdr" style="font-size:12px;border-left:none; border-right:none;">
                     <thead>
                        <tr>
                            <th class="border_th">Code</th>
                            <th class="border_th">Account</th>
                            <th style="width:120px" class="border_th">Date</th>
                            <th class="border_th">Num</th>
                            <th class="border_th">Cheque No.</th>
                            <th class="border_th">Party</th>
                            <th class="border_th">Narration</th>
                            <th class="border_th">Debit</th>
                            <th class="border_th">Credit</th>
                            <th class="border_th">Balance</th>
                        </tr>
                     </thead>
                     <tbody>
                       
                            <?php $balance = 0; $debit = $credit = 0;$ttdebit = $ttcredit = $ttbalance = 0;?>
                   
                        
                        @foreach($childAccounts as $cA)
                        
                        <tr>
                            <?php $balance = 0; $debit = $credit = 0;$tdebit = $tcredit = $tbalance = 0;?>
                            <td   style="text-align:left;font-size: 14px;"><b>{{$cA->number}} </b> </td>
                            <td   style="text-align:left;font-size: 14px;"><b>{{$cA->name}}</b> </td>

                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                         
                            
                            <td></td>
                            <td></td>
                            
                            <td></td>
    
                            
                        </tr>
                        
                        @foreach($subChild[$cA->id] as $sCA)
                        
                        <tr>
                            <?php $balance = $preBalance[$sCA->id]; $debit = $credit = 0;?>

                            <td   style="text-align:left;font-size: 12px;"><b>{{$sCA->number}} </b> </td>

                            <td   style="text-align:left;font-size: 12px;"><b> {{$sCA->name}}</b> </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td class="text-left" style="padding-left: 2%;">OPENING BALANCE</td>
                         
                            
                            <td></td>
                            <td></td>
                            
                            @if($balance < 0)
                            <td class="text-right" style="font-size:12px;"><b>({{number_format(abs($balance))}})</b></td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;"><b>{{number_format($balance)}}</b></td>
                            @else
                            <td class="text-right">-</td>
                            @endif
                            
                           
    
                            
                        </tr>

                        @foreach($transactions[$sCA->id] as $t)
                        <tr>
                            <td></td>
                            @if($t->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td class="text-left" style="padding-left: 2%;">CRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td class="text-left" style="padding-left: 2%;">BRV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td class="text-left" style="padding-left: 2%;">CPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td class="text-left" style="padding-left: 2%;">BPV-{{$t->voucher_no}}</td>
                                            @elseif($t->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td class="text-left" style="padding-left: 2%;">JV-{{$t->voucher_no}}</td>
                                            @else
                                            <td></td>
                                            @endif
                            <td class="text-left" style="padding-left: 2%;">{{date('d/m/Y',strtotime($t->date))}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->entry_no}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->cheaque_no}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->controlAccount ? $t->controlAccount->name : ''}}</td>
                            <td class="text-left" style="padding-left: 2%;">{{$t->memo}}</td>
                            
                            
                            <td class="text-right">{{$t->amount > 0 ? number_format(abs($t->amount)) : '-'}} 
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            </td>
                            <td class="text-right">{{$t->amount < 0 ? number_format(abs($t->amount)) : '-'}}
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            </td>

                        
                            
                            <?php $balance += $t->amount;?>
                            

                            @if($balance < 0)
                            <td class="text-right">({{number_format(abs($balance))}})</td>
                            @elseif($balance > 0)
                            <td class="text-right">{{number_format($balance)}}</td>
                            @else
                            <td class="text-right"><u>-</u></td>
                            @endif
                        </tr>
                        @endforeach

                        <tr >

                            <td   style="text-align:left;  font-size: 12px;"><b> {{$sCA->number}} </b> </td>

                            <td   style="text-align:left;  font-size: 12px;">CLOSING BALANCE</td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            
                            
                            <td ></td>
                            <td ></td>
                            
                             <td class="text-right" style="font-size:12px;"><b><u>
                                @if($debit < 0)
                                ({{number_format(abs(number_format($debit)))}})
                                @elseif($debit > 0)
                                {{number_format($debit)}}
                                @else
                                -
                                @endif
                             </u></b></td>
                            <td class="text-right" style="font-size:12px;"><b><u>
                                @if($credit < 0)
                                ({{number_format(abs(number_format($credit)))}})
                                @elseif($credit > 0)
                                {{number_format($credit)}}
                                @else
                                -
                                @endif
                            </u></b></td>
                           @if($balance < 0)
                            <td class="text-right" style="font-size:12px;"><u><b>({{number_format(abs($balance))}})</b></u></td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;"><u><b>{{number_format($balance)}}</b></u></td>
                            @else
                            <td class="text-right"><u>-</u></td>
                            @endif

                        </tr>
                        
                       
                        
                        <?php $tdebit += $debit;$tcredit += $credit; $tbalance += $balance;?>
                        
                        @endforeach


                        <tr >
                            <td   style="text-align:left;font-size: 14px;"><b> </b> </td>

                             <td   style="text-align:left;font-size: 14px;"></td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            
                           
                            <td ></td>
                            <td ><b> Total</b> </td>
                            
                            <td class="text-right" style="font-size:14px; "><b><u>
                                @if($tdebit < 0)
                                ({{number_format(abs(number_format($tdebit)))}})
                                @elseif($tdebit > 0)
                                {{number_format($tdebit)}}
                                @else
                                -
                                @endif
                            </u></b></td>
                            <td class="text-right" style="font-size:14px;"><b><u>
                                @if($tcredit < 0)
                                ({{number_format(abs(number_format($tcredit)))}})
                                @elseif($tcredit > 0)
                                {{number_format($tcredit)}}
                                @else
                                -
                                @endif
                            </u></b></td>
                            @if($tbalance < 0)
                            <td class="text-right" style="font-size:14px;"><b><u>({{number_format(abs($tbalance))}})</u></b></td>
                            @elseif($tbalance > 0)
                            <td class="text-right" style="font-size:14px;"><b><u>{{number_format($tbalance)}}</u></b></td>
                            @else
                            <td>-</td>
                            @endif

                        </tr>
                        
                        
                        <tr >
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            
                           
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>

                        </tr>
                        
                        <?php $ttdebit += $tdebit;$ttcredit += $tcredit; $ttbalance += $tbalance;?>
                        @endforeach
                        
                        
                        <tr >
                                
                            <td   style="text-align:left;"><b> </b> </td>
                            <td   style="text-align:left;"> </td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            <td   style="text-align:left;">  </td>
                            <td   ><b> Sub Total - Bank Balances & TDR</b> </td>
                            <td ></td>
                            <td ></td>
                            <td id="sum_of_tdr_html" ></td>
                            
                            
                        </tr>
                        
                        
                        
                        <tr >
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>
                            <td style="border-left:none !important; border-right:none !important;"></td>

                        </tr>
                        
                        
                        
                        <tr >
                             <td   style="text-align:left;font-size: 14px;"><b> </b> </td>

                             <td   style="text-align:left;font-size: 14px;"> </td>
                            <td ></td>
                            <td ></td>
                            <td ></td>
                            
                           
                            <td ></td>
                            <td style="padding: 2rem;"><b> Total</b></td>
                            
                            <td class="text-right" style="font-size:14px; "><b><u>
                                @if($ttdebit < 0)
                                ({{number_format(abs(number_format($ttdebit)))}})
                                @elseif($ttdebit > 0)
                                {{number_format($ttdebit)}}
                                @else
                                -
                                @endif
                            </u></b></td>
                            <td class="text-right" style="font-size:14px;"><b><u>
                                @if($ttcredit < 0)
                                ({{number_format(abs(number_format($ttcredit)))}})
                                @elseif($ttcredit > 0)
                                {{number_format($ttcredit)}}
                                @else
                                -
                                @endif
                            </u></b></td>
                           @if($ttbalance < 0)
                            <td class="text-right" style="font-size:14px;"><u><b>({{number_format(abs($ttbalance))}})</b></u></td>
                            @elseif($ttbalance > 0)
                            <td class="text-right" style="font-size:14px;"><u><b>{{number_format($ttbalance)}}</b></u></td>
                            @else
                            <td>-</td>
                            @endif

                        </tr>
                        

                    
                 </tbody>
            </table>
            
            
            
        
                        <div class="col-md-12 pro-cart table-responsive printableArea" >
                            
                            <div class="text-center">
                            
                                <h3><strong>{{env('APP_NAME')}}</strong></h3>
                                <h4 ><strong>SUMMARY {{$account->name}} </strong></h4>
                                <h6>From {{date('d/m/Y',strtotime($from))}} to  {{date('d/m/Y',strtotime($to))}}</h6>
                            
                            </div>

                <table id="example1" class="table table-bordered bdr" style="font-size:12px;">
                     <thead>
                        <tr>
                            <th style="border-top: 1px solid;border-left: 1px solid;border-right: none;border-bottom: 1px solid;">Code</th>
                            <th style="border-top: 1px solid;border-left: none;border-right: none;border-bottom: 1px solid;">Head Of Account</th>
                         
                            <th style="border-top: 1px solid;border-right: 1px solid;border-bottom: 1px solid;border-left:none;">Balance</th>
                        </tr>

                     </thead>
                     <tbody>
                       
                            <?php $balance = 0; $debit = $credit = 0;$ttdebit = $ttcredit = $ttbalance = 0; $bankAndTdr = 0; $count = 0;?>
                         
                       
                        @foreach($childAccounts as $cA)
                        
                      
                            <?php $balance = 0; $debit = $credit = 0;$tdebit = $tcredit = $tbalance = 0;?>
                         
                        
                        @foreach($subChild[$cA->id] as $key=>$sCA)
                        
                   
                            <?php $balance = $preBalance[$sCA->id]; $debit = $credit = 0;?>
                    

                        @foreach($transactions[$sCA->id] as $t)
                      
                           
                                <?php $debit += $t->amount > 0 ? abs($t->amount) : 0;?>
                            
                                <?php $credit += $t->amount < 0 ? abs($t->amount) : 0;?>
                            
                            
                            <?php $balance += $t->amount;?>
                            

                            
                        @endforeach
                        
                        
                        @if($loop->first )                
                        <tr>
                        
                        <td style=" border-right: none;border-bottom: 1px solid black !important;border-top: 1px solid black !important;border-left: 1px solid;"></td>
                        <td style=" border-bottom: 1px solid black !important;border-top: 1px solid black !important;border-left: 1px solid white;border-right: 1px solid white;"><b>{{$cA->name}} SUMMARY</b></td>
                        <td style=" border-left: none;border-bottom: 1px solid black !important;border-top: 1px solid black !important;border-left: 1px solid white;border-right: 1px solid;"></td>
                        </tr>
                        @endif  
                        
    
                        <tr >
                            <td style="text-align:left;  font-size: 12px;border-left: 1px solid;">{{$sCA->number}} </td>
                            <td   style="text-align:left;  font-size: 12px;border-left: 1px solid;"><b>{{$sCA->name}}</b> </td>
                           
                          
                           @if($balance < 0)
                            <td class="text-right" style="font-size:12px;border-left: 1px solid;border-right: 1px solid;">({{number_format(abs($balance))}})</td>
                            @elseif($balance > 0)
                            <td class="text-right" style="font-size:12px;border-left: 1px solid;border-right: 1px solid;">{{number_format($balance)}}</td>
                            @else
                            <td class="text-right" style="border-right: 1px solid;">-</td>
                            @endif

                        </tr>
                        
                  
                        
                        <?php $tdebit += $debit;$tcredit += $credit; $tbalance += $balance;?>
                        
                        @endforeach

                  
                    

                        <tr >

                            <td style="text-align:left;  font-size: 12px;border-bottom:none;border-left: 1px solid;"> </td>
                            
                            <td   style="text-align:left;font-size: 14px;border-bottom:none;border-left: 1px solid;"><b> Sub Total - {{$cA->name}} </b> </td>
                            
                            @if($tbalance < 0)
                            <td class="text-right" style="font-size:14px;border-bottom:none;border-left: 1px solid;border-right: 1px solid;"><b>({{number_format(abs($tbalance))}})</b></td>
                            @elseif($tbalance > 0)
                            <td class="text-right" style="font-size:14px;border-bottom:none;border-left: 1px solid;border-right: 1px solid;"><b>{{number_format($tbalance)}}</b></td>
                            @else
                            <td style="border-right: 1px solid;">-</td>
                            @endif

                        </tr>
                        
   
                        
                        <?php $ttdebit += $tdebit;$ttcredit += $tcredit; $ttbalance += $tbalance;  if($count > 0) { $bankAndTdr += $tbalance; } $count++; ?>
                        @endforeach
                        
                        
                        
                          <tr  >

                            <td   style="text-align:left;font-size: 14px;border-left:1px solid black;border-top:1px solid black;border-bottom:1px solid black;border-right:none !important;"><b> </b> </td>
                           

                             <td   style="text-align:left;font-size: 14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right: none;"><b> Sub Total - Bank Balances & TDR </b> </td>
                           
                          
                           @if($bankAndTdr < 0)
                            <td class="text-right" id="sum_of_tdr_bank_balance" style="font-size:14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right:1px solid black;"><b>({{number_format(abs($bankAndTdr))}})</b></td>
                            @elseif($bankAndTdr > 0)
                            <td class="text-right" id="sum_of_tdr_bank_balance" style="font-size:14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right:1px solid black;"><b>{{number_format($bankAndTdr)}}</b></td>
                            @else
                            <td style="border-right: 1px solid;" id="sum_of_tdr_bank_balance">-</td>
                            @endif

                        </tr>
                        
                        
                        <tr >

                            <td   style="text-align:left;font-size: 14px;border-left:1px solid black;border-top:1px solid black;border-bottom:1px solid black;border-right:none !important;"><b> </b> </td>
                           

                             <td   style="text-align:left;font-size: 14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right: none;"><b> GRAND TOTAL</b> </td>
                           
                          
                           @if($ttbalance < 0)
                            <td class="text-right" style="font-size:14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right:1px solid black;"><b>({{number_format(abs($ttbalance))}})</b></td>

                            @elseif($ttbalance > 0)
                            <td class="text-right" style="font-size:14px;border-left:none; border-top:1px solid black;border-bottom:1px solid black;border-right:1px solid black;"><b>{{number_format($ttbalance)}}</b></td>
                            @else
                            <td style="border-right: 1px solid;">-</td>
                            @endif

                        </tr>
                        

                    
                 </tbody>
            </table>
            
            
            
            <br><br><br>
<div class="col-md-12">

<div class="col-md-4 col-xs-4 text-center">
<span><b></b></span> 
<div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
<div style="border-top: 1px solid black;"> Prepared By</div>
</div>
</div>


<div class="col-md-4 col-xs-4 text-center">
<span><b></b></span> 
<div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
<div style="border-top: 1px solid black;">Checked By</div>
</div>
</div>


<div class="col-md-4 col-xs-4 text-center">
<span><b></b></span> 
<div style="text-align: center;border: 2px solid;padding-top: 5rem;font-weight: bold;">
<div style="border-top: 1px solid black;">Approved By</div>
</div>
</div>


</div>

<div class="text-right col-md-12" style="height:70px;">
<button  class="btn btn-default btn-outline no-print" id="summary_print" style="margin-top: 2rem;margin-right: 5rem;background-color: rgba(0, 0, 0, 0.1);border: 1px solid black;border: 1px solid rgba(0, 0, 0, 0.3);"  type="button"> <span> Print Summary</span> </button>
</div>


<br><br><br>

            

                        </div>
                        
            
        </div>



        @endif
        
    </div>
    </div>
   
</div>



@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


$( document ).ready(function() {
    $('#sum_of_tdr_html').html($('#sum_of_tdr_bank_balance').html())
});


$(function () {
    $("#summary_print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});


    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        info:false,
        buttons: [
             'excel'
        ]
    } );

    </script>


@stop