@extends('layouts.app')

@section('title')
    Dashboard
@stop

@section('css')
    <link href="{{ asset('plugins/components/chartist-js/dist/chartist.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@stop


@section('content')

    <div class=" container-fluid">

        @can('isSuperAdmin')
        @include('partial.multiproject_select')
       @endcan
        <br>


    <div id='updatecontent' style="margin-top: 50px;">
        <div class="row colorbox-group-widget">
            <div class="col-md-6 col-sm-6 info-color-box">

                <div class="white-box">
                    <div class="media bg-primary">
                        <div class="media-body">

                            <h3 class="info-count">{{ number_format($totalBankBalance) }} <span class="pull-right"><i
                                        class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                            <p class="info-text font-12">Bank Balances</p>
                            @foreach ($banks as $b)
                                @if ($bankBalance[$b->id] != 0)
                                    <p class="info-ot font-15">{{ $b->number }} - {{ $b->name }}<span
                                            class="label label-rounded">
                                            @if ($bankBalance[$b->id] < 0)
                                                <td class="text-right">({{ number_format(abs($bankBalance[$b->id])) }})</td>
                                            @else
                                                <td class="text-right">
                                                    {{ $bankBalance[$b->id] > 0 ? number_format($bankBalance[$b->id]) : '-' }}
                                                </td>
                                            @endif
                                        </span></p>
                                @endif
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 info-color-box">
                <div class="white-box">
                    <div class="media bg-success">
                        <div class="media-body">

                            <h3 class="info-count">{{ number_format(abs($accountReceivable)) }} <span class="pull-right"><i
                                        class="mdi mdi-comment-text-outline"></i></span></h3>
                            <p class="info-text font-12">Accounts Receivable</p>
                            <p class="info-ot font-15"></p>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 info-color-box">
                <div class="white-box">
                    <div class="media bg-danger">
                        <div class="media-body">

                            <h3 class="info-count">{{ number_format(abs($accountPayable)) }} <span class="pull-right"><i
                                        class="mdi mdi-coin"></i></span></h3>
                            <p class="info-text font-12">Accounts Payable</p>
                            <p class="info-ot font-15"></p>

                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-sm-12">
                <label style="font-weight: 900;">Closing Report : </label>
                <form target="_blank" method="post" action="{{ route('account-closing-report') }}">
                    {{ csrf_field() }}
                    <input type='hidden' name='multipro_id' id='multipro_id_input' value='all'>
                    <div class="col-sm-4">
                        <div class="input-group" style="width:100%">
                            <select class="form-control chosen-select" name="bank_id" id="bank_id">
                                @foreach ($banks as $b)
                                    <option value="{{ $b->id }}">{{ $b->number }} - {{ $b->name }}
                                    </option>
                                @endforeach
                            </select>



                        </div>

                    </div>

                    <div class="col-sm-4">
                        <div class="input-group" style="width:100%">

                            <input type="text" class="form-control "id="daterange-btn" value='{{ old('date_range') }}'
                                name='date_range'>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <div class="input-group" style="width:100%">

                            <span class="input-group-btn">
                                <button type="submit" id="check-minutes"
                                    class="btn waves-effect waves-light btn-success">Generate</button>
                            </span>
                        </div>
                    </div>


                </form>
            </div>


        </div>

        <br>


        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">
                    <div class="pull-right">

                    </div>
                    <h3 class="box-title">List of unPosted Entries</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Checked</th>
                                    <th>Posted</th>
                                    <th>Date</th>
                                    <!-- <th>Entry No.</th> -->
                                    <th>Cheque No.</th>
                                    <th>Account</th>
                                    <!-- <th>Memo</th> -->
                                    <!-- <th>Class</th> -->
                                    <th>Debit/Credit (+/-)</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($allEntries as $entry)
                                    <tr ondblclick="showEntry('{{ $entry->entry_no }}')">

                                        @if ($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td>CRV-{{ $entry->voucher_no }}</td>
                                        @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td>BRV-{{ $entry->voucher_no }}</td>
                                        @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td>CPV-{{ $entry->voucher_no }}</td>
                                        @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td>BPV-{{ $entry->voucher_no }}</td>
                                        @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td>JV-{{ $entry->voucher_no }}</td>
                                        @else
                                            <td></td>
                                        @endif

                                        <td>
                                            @if ($entry->is_check)
                                                <i class="fa fa-check" style="color:green"></i>
                                            @else
                                                <i class="fa fa-close" style="color: red;"></i>
                                            @endif

                                        <td>
                                            @if ($entry->is_post)
                                                <i class="fa fa-check" style="color:green"></i>
                                            @else
                                                <i class="fa fa-close" style="color: red;"></i>
                                            @endif
                                        </td>

                                        <td>{{ date('d/m/Y', strtotime($entry->date)) }}</td>
                                        <!--  <td>Cehk nyumber</td>  -->
                                        <td>
                                            {{ $entry->cheaque_no ? $entry->cheaque_no : '' }}
                                        </td>
                                        <td>{{ $entry->account ? $entry->account->name : '' }}</td>
                                        <!-- <td>{{ $entry->memo }}</td> -->
                                        <!-- <td>{{ $entry->class ? $entry->class->name : '' }}</td> -->
                                        <td class="text-right">{{ number_format($totalAmount[$entry->entry_no]) }}</td>
                                        <td>
                                            <!-- <span onclick="showEntry('{{ $entry->entry_no }}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

                                            <a href="{{ route('voucher-detail', ['id' => $entry->entry_no]) }}"
                                                class="btn btn-default">View</a>

                                            @if (!$entry->is_approved)
                                                <br><br>
                                                <span onclick="approveEntryModal('{{ $entry->entry_no }}')"
                                                    style="cursor: pointer;" class="btn btn-default btn-sm"> Approve</span>
                                            @endif

                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->




        <br>


        <!--.row-->


        <div class="row" id="update-table">

        </div>
        <!-- /.row -->




        <!-- /row -->



        <!-- /.container-fluid -->
    </div>
    </div>
@stop

@section('js')
    <script src="{{ asset('plugins/components/chartist-js/dist/chartist.min.js') }}"></script>
    <script src="{{ asset('plugins/components/chartist-plugin-tooltip-master/dist/chartist-plugin-tooltip.min.js') }}">
    </script>
    <script src="{{ asset('plugins/components/knob/jquery.knob.js') }}"></script>
    <script src="{{ asset('plugins/components/custom-chart/chart.js') }}"></script>
    <script src="{{ asset('js/db3.js') }}"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script>
        function callFunction(){
        const year = new Date().getFullYear();

        const this_fiscal_year_start_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} + '-01');

        const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');

        const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} +
            '-01');

        const last_fiscal_year_end_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');




        $('#daterange-btn').daterangepicker({

                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                        'month')],
                    'This Fiscal Year': [this_fiscal_year_start_date, this_fiscal_year_end_date],
                    'Last Fiscal Year': [last_fiscal_year_start_date, last_fiscal_year_end_date]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function(start, end) {
                $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }
        );
        }
        callFunction();
    </script>

    <script>
        $(function() {
            $('#myTable1').DataTable({
                'pageLength': 25,
                'paging': false,
                'info': false,
                'searching': false
            });
        });




        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
           
            $.get('{{ route('account-dashboard') }}', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();



                document.getElementById('updatecontent').innerHTML = data;

                $('#myTable1').DataTable({
                'pageLength': 25,
                'paging': false,
                'info': false,
                'searching': false
            });
            
            callFunction();
            $('#multipro_id_input').val(value);
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>
@stop
