@extends( 'layouts.app' )

@section('title')
Chart of Account Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
         @permission('view-chart-of-account')
        <li ><a href="{{route('chart-of-account.all')}}">Chart of Account</a></li>
        @endpermission
        <li class="active">Account Detail</li>
      </ol>
@stop

@section('css')

<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style type="text/css">
    
    @media print {
        .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        padding-top: 0px !important
    }
    .printableArea {
        color: black;
    }
    strong{
        color: black;
    }
        .white-box {
            border: none !important;
        }
        
        .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
    border-bottom: 1px solid #2e3233;
    line-height: 2.2;
    background: #eee;
    border-right: 1px solid;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .table>tbody>tr>td{
        padding: 5px 3px 0 4px;
        vertical-align: top;
    }
    .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    h3{
        font-size: 21px !important;
    }
    .panel .panel-body{
        padding:0;
    }
    .fix-header .page-wrapper {
    margin-top: 0px !important;
    }
    h3 strong{
        text-transform: uppercase;
    }
    h4 strong{
        text-transform: uppercase;
    }
    h3{
        margin-bottom: -10px;
    }
    h6{
        color: black;
    }
    }
</style>
@endsection

@section('content')
            <div class="container-fluid">

                <!--.row-->
                <div class="row no-print">
                <div class="col-md-12">
                <div class="panel panel-info">
                <div class="panel-heading">Customize Report</div>
                <div class="panel-wrapper collapse in" aria-expanded="true">
                <div class="panel-body">
                <form >
                <div class="form-body">
                <div class="row">

                <div class="col-md-6">


                <div class="form-group">
                <label class="col-sm-3 control-label">Date range</label>
                <div class="col-sm-9">
                <div class="input-group" id="date-div">
                <div class="input-group-addon">
                <i class="fa fa-calendar"></i>
                </div>
                <input type="text" class="form-control pull-right" id="daterange-btn"   name='date_range' >

                </div>
                @if($errors->has('date_range'))
                <span class="help-block" >
                <strong>{{ $errors->first('date_range') }}</strong>
                </span>
                @endif
                </div>
                <!-- /.input group -->
                </div>
                </div>
                <div class="form-actions">
                <button type="button" class="btn btn-success update-report"> <i class="fa fa-check" ></i> Update</button>

                </div>

                </div>

                </div>

                </form>
                </div>
                </div>
                </div>
                </div>
                </div>
                <!--./row-->
<div id="update-report">
                <div class="row text-center" >
                                       <h3><strong>{{env('APP_NAME')}}</strong></h3>
                                       <h4><strong>General Ledger</strong></h4>
                                       <h6>{{date('M d,Y',strtotime($from))}} - {{date('M d,Y',strtotime($to))}}</h6>
                                       <h4><strong><u> {{$account->number}} - {{$account->name}} ({{$account->type ? $account->type->name : '' }})</u></strong></h4> 
                                    </div>

                <!-- /row -->
                <div class="row">
                   
                    <div class="col-sm-12">
                        <div class="white-box">
                            <hr>
                                    <div class="table-responsive">
                                        @if($account->type->name == 'Bank' || $account->type->name == 'Fixed Asset' || $account->type->name == 'Other CurrentAsset' || $account->type->name == 'Other Asset' || $account->type->name == 'Non-Current Asset' || $account->type->name == 'Expense' || $account->type->name == 'Direct Cost' || $account->type->name == 'Income')
                                        <table  class="table bdr table-bordered tbl" >
                                            <thead>
                                                <tr>
                                                    <th  style="text-align: center;">Date</th>
                                                    <th  style="text-align: center;">Voucher No</th>
                                                    <th  style="text-align: center;">Cheque No</th>
                                                    <th   style="text-align: center;" >Party</th>
                                                    <th  style="width: 40%;" style="text-align: center;" >Narration</th>
                                                    <th  style="text-align: center;">Debit</th>
                                                    <th  style="text-align: center;">Credit</th>
                                                    <th  style="text-align: center;">Balance</th>
                                                </tr>
                                                
                                            </thead>
                                            <tbody>
                                                <?php $balance = $openingBalance;$debit = 0; $credit = 0;$monthlyDebit = 0;$monthlyCredit = 0;?>

                                                <tr>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td  ></td>
                                                    <td >&nbsp;&nbsp;Opening Balance</td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right">{{$balance != 0? number_format($balance) : '-'}}</td>
                                                    
                                                </tr>

                                                @foreach($entries as $entry)
                                                <tr>
                                                    <td >&nbsp;&nbsp; {{date('d/m/Y',strtotime($entry->date))}}</td>
                                                    <td data-id="{{$entry->entry_no}}" style="font-size:11px;cursor:pointer;color: #afaff7;text-align: center;" onclick="return openThisVoucher(this);">
                                                    
                                                    
                                                    @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    CRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    BRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    CPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    BPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    JV-{{$entry->voucher_no}}
                                                    @else
                                                    
                                                    @endif
                                                    
                                                    
                                                    </td>

                                                     <td>
                                                        {{$entry->cheaque_no }}
                                                    </td>

                                                    <td  >&nbsp;&nbsp; 
                                                        {{$entry->controlAccount ? $entry->controlAccount->name : ''}}
                                                    </td>
                                                    <td >&nbsp;{{$entry->memo}}</td>
                                                    <td class="text-right">{{$entry->amount > 0 ? number_format(abs($entry->amount)) : ''}}

                                                        <?php $debit += $entry->amount > 0 ? $entry->amount : 0;?>
                                                    </td>
                                                    <td class="text-right">{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}

                                                    <?php $credit += $entry->amount < 0 ? abs($entry->amount) : 0;?>
                                                        
                                                    </td>
                                                    <?php $balance +=$entry->amount;?>
                                                    @if($balance < 0)
                                                    <td class="text-right">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td class="text-right">{{$balance > 0? number_format($balance) : '-'}}</td>
                                                    @endif
                                                </tr>
                                                
                                                @endforeach
                                              

                                                <tr>
                                                 
                                                    <td style="border-right: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>

                                                    <td  class="text-right"><b>Grand Total</b></td>
                                                    <td class="text-right" ><b style="border-bottom:1px solid black;">{{$debit !=0 ? number_format($debit) : '-'}}</b></td>
                                                    <td class="text-right"><b style="border-bottom:1px solid black;">{{$credit !=0 ? number_format($credit) : '-'}}</b></td>
                                                    @if($balance < 0)
                                                    <td class="text-right"><b style="border-bottom:1px solid black;">({{number_format(abs($balance))}})</b></td>
                                                    @else
                                                    <td class="text-right"><b style="border-bottom:1px solid black;">{{$balance > 0? number_format($balance) : '-'}}</b></td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!-- <div style="font-size: 18px;float: right;padding-right: 80px;"> Ending Balance : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{number_format($balance)}}</div> -->
                                        @elseif($account->type->name == 'Accounts Receivable')
                                        <table  class="table bdr table-bordered tbl" >
                                            <thead>
                                                <tr>
                                                    <th  style="text-align: center;">DATE</th>
                                                    <th  style="text-align: center;">Voucher #</th>
                                                    <th  style="text-align: center;">Cheque No</th>
                                                    <th  style="width: 40%;" style="text-align: center;" >CUSTOMER</th>
                                                    <th  style="text-align: center;">Narration</th>
                                                    <th  style="text-align: center;">Debit</th>
                                                    <th  style="text-align: center;">Credit</th>
                                                    <th  style="text-align: center;"> Balance</th>
                                                </tr>
                                                
                                            </thead>
                                            <tbody>
                                            <?php $balance = $openingBalance;$debit = 0; $credit = 0;?>

                                                <tr>
                                                    <td ></td>
                                                    <td> 
                                                        
                                                    </td>
                                                    <td  >
                                                    </td><td  ></td>
                                                    <td >&nbsp;&nbsp;Opening Balance</td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right">{{$balance != 0 ? number_format($balance) : '-'}}</td>
                                                    
                                                </tr>
                                                @foreach($entries as $entry)
                                                <tr>
                                                    <td >{{date('d/m/Y',strtotime($entry->date))}}</td>
                                                    <td data-id="{{$entry->entry_no}}" style="font-size:11px;cursor:pointer;color: #afaff7;text-align: center;" onclick="return openThisVoucher(this);">
                                                    
                                                    
                                                    @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    CRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    BRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    CPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    BPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    JV-{{$entry->voucher_no}}
                                                    @else
                                                    
                                                    @endif
                                                    
                                                    
                                                    </td>
                                                    <td>
                                                        {{$entry->cheaque_no }}
                                                    </td>

                                                    <td  >
                                                        {{$entry->controlAccount ? $entry->controlAccount->name : ''}}
                                                    </td>
                                                    <td >{{$entry->memo}}</td>
                                                    <td class="text-right">{{$entry->amount > 0 ? number_format(abs($entry->amount)) : ''}}

                                                        <?php $debit += $entry->amount > 0 ? $entry->amount : 0;?>
                                                    </td>
                                                    <td class="text-right">{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}

                                                    <?php $credit += $entry->amount < 0 ? abs($entry->amount) : 0;?>
                                                        
                                                    </td>
                                                    <?php $balance += $entry->amount;?>
                                                    @if($balance < 0)
                                                    <td style="text-align: right;">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td style="text-align: right;">{{$balance > 0 ? number_format($balance) : '-'}}</td>
                                                    @endif
                                                </tr>
                                                
                                                @endforeach
                                              
                                                <tr>
                                                       
                                                    <td style="border-right: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td  class="text-right"><b>Grand Total</b></td>

                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$debit !=0 ? number_format($debit) : '-'}}</u></b></td>
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$credit !=0 ? number_format($credit) : '-'}}</u></b></td>
                                                    @if($balance < 0)
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>({{number_format(abs($balance))}})</u></b></td>
                                                    @else
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$balance > 0? number_format($balance) : '-'}}</u></b></td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>

                                        <!--<div style="font-size: 18px;float: right;padding-right: 80px;"> Ending Balance : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{number_format($balance)}}</div>-->
                                        
                                        @elseif($account->type->name == 'Accounts Payable')
                                        <table  class="table bdr table-bordered tbl" >
                                            <thead>
                                                <tr>
                                                    <th  style="text-align: center;">DATE</th>
                                                    <th  style="text-align: center;">VOUCHER #</th>
                                                    <th  style="text-align: center;">Cheque No</th>
                                                    <th  style="text-align: center;" >VENDOR</th>
                                                    <th  style="width: 40%;" style="text-align: center;" >Narration</th>
                                                    <th  style="text-align: center;">Debit</th>
                                                    <th  style="text-align: center;">Credit</th>
                                                    <th  style="text-align: center;">Balance</th>
                                                </tr>
                                                
                                            </thead>
                                            <tbody>
                                            <?php $balance = $openingBalance;$debit = 0; $credit = 0;?>

                                                <tr>
                                                    <td ></td>
                                                    <td> 
                                                        
                                                    </td>
                                                    <td  >
                                                    </td>
                                                    <td  ></td>
                                                    <td >&nbsp;&nbsp;Opening Balance</td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right">{{$balance != 0? number_format($balance) : '-'}}</td>
                                                    
                                                </tr>
                                                @foreach($entries as $entry)
                                                <tr>
                                                    <td >{{date('d/m/Y',strtotime($entry->date))}}</td>
                                                   <td data-id="{{$entry->entry_no}}" style="font-size:11px;cursor:pointer;color: #afaff7;text-align: center;" onclick="return openThisVoucher(this);">
                                                    
                                                    
                                                    @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    CRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    BRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    CPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    BPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    JV-{{$entry->voucher_no}}
                                                    @else
                                                    
                                                    @endif
                                                    
                                                    
                                                    </td>

                                                    <td>
                                                        {{$entry->cheaque_no }}
                                                    </td>


                                                    <td  >
                                                        {{$entry->controlAccount ? $entry->controlAccount->name : ''}}
                                                    </td>
                                                    <td style="font-size:11px">{{$entry->memo}}</td>
                                                    <td class="text-right">{{$entry->amount > 0 ? number_format(abs($entry->amount)) : ''}}

                                                        <?php $debit += $entry->amount > 0 ? $entry->amount : 0;?>
                                                    </td>
                                                    <td class="text-right">{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}

                                                    <?php $credit += $entry->amount < 0 ? abs($entry->amount) : 0;?>
                                                        
                                                    </td>
                                                    <?php $balance += $entry->amount ;?>
                                                    @if($balance < 0)
                                                    <td style="text-align: right;">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td style="text-align: right;color: red;font-size: 11px;">{{$balance > 0? number_format($balance) : '-'}}</td>
                                                    @endif
                                                </tr>
                                                
                                                @endforeach
                                                
                                                <tr>
                                                        
                                                     <td style="border-right: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td  class="text-right" style="border-left: none;"><b>Grand Total</b></td>
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$debit !=0 ? number_format($debit) : '-'}}</u></b></td>
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$credit !=0 ? number_format($credit) : '-'}}</u></b></td>
                                                    @if($balance < 0)
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>({{number_format(abs($balance))}})</u></b></td>
                                                    @else
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$balance > 0? number_format($balance) : '-'}}</u></b></td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                       <!--@if($balance < 0)-->
                                       <!-- <div style="font-size: 18px;float: right;padding-right: 80px;"> Ending Balance : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;({{number_format(abs($balance))}})</div>-->
                                       <!-- @else-->
                                       <!-- <div style="font-size: 18px;float: right;padding-right: 80px;"> Ending Balance : &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{number_format($balance)}}</div>-->
                                       
                                       <!-- @endif-->

                                        
                                        @elseif($account->type->name == 'Other Current Liability' || $account->type->name == 'Long Term Liability' || $account->type->name == 'Current Liability' || $account->type->name == 'Equity')
                                        <table  class="table bdr table-bordered tbl" >
                                            <thead>
                                                <tr>
                                                    <th  style="text-align: center;">Date</th>
                                                    <th  style="text-align: center;">Voucher #</th>
                                                    <th  style="text-align: center;">Cheque No</th>
                                                    <th   style="text-align: center;" >Payee</th>
                                                    <th  style="width: 40%;" style="text-align: center;" >Narration</th>
                                                    <th  style="text-align: center;">Debit</th>
                                                    <th  style="text-align: center;">Credit</th>
                                                    <th  style="text-align: center;">Balance</th>
                                                </tr>
                                                
                                            </thead>
                                            <tbody>
                                            <?php $balance = $openingBalance;$debit = 0; $credit = 0;?>

                                                <tr>
                                                    <td ></td>
                                                    <td> 
                                                        
                                                    </td>
                                                    <td  >
                                                    </td>
                                                    <td  ></td>
                                                    <td >&nbsp;&nbsp;Opening Balance</td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right">{{$balance != 0? number_format($balance) : '-'}}</td>
                                                    
                                                </tr>
                                                @foreach($entries as $entry)
                                                <tr>
                                                    <td >{{date('d/m/Y',strtotime($entry->date))}}</td>
                                                    <td data-id="{{$entry->entry_no}}" style="font-size:11px;cursor:pointer;color: #afaff7;text-align: center;" onclick="return openThisVoucher(this);">
                                                    
                                                    
                                                    @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    CRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    BRV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    CPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    BPV-{{$entry->voucher_no}}
                                                    @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    JV-{{$entry->voucher_no}}
                                                    @else
                                                    
                                                    @endif
                                                    
                                                    
                                                    </td>
                                                    <td>
                                                        {{$entry->cheaque_no }}
                                                    </td>

                                                    <td >
                                                        {{$entry->controlAccount ? $entry->controlAccount->name : ''}}
                                                    </td>
                                                    <td style="font-size:11px">{{$entry->memo}}</td>
                                                    <td class="text-right">{{$entry->amount > 0 ? number_format(abs($entry->amount)) : ''}}

                                                        <?php $debit += $entry->amount > 0 ? $entry->amount : 0;?>
                                                    </td>
                                                    <td class="text-right">{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}

                                                    <?php $credit += $entry->amount < 0 ? abs($entry->amount) : 0;?>
                                                        
                                                    </td>
                                                    
                                                    <?php $balance += $entry->amount;?>

                                                    
                                                    @if($balance < 0)
                                                    <td class="text-right">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td class="text-right">{{$balance > 0? number_format($balance) : '-'}}</td>
                                                    @endif
                                                </tr>
                                                
                                                @endforeach
                                               
                                                <tr>
                                                    
                                                     <td style="border-right: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td style="border-right: none;border-left: none;"></td>
                                                    <td  class="text-right"><b>Grand Total</b></td>

                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$debit !=0 ? number_format($debit) : '-'}}</u></b></td>
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$credit !=0 ? number_format($credit) : '-'}}</u></b></td>
                                                    @if($balance < 0)
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>({{number_format(abs($balance))}})</u></b></td>
                                                    @else
                                                    <td class="text-right"><b style="border-bottom:1px solid black;"><u>{{$balance > 0? number_format($balance) : '-'}}</u></b></td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>
                                        
                                        @else

                                        <table>7</table>
                                        @endif

                                    </div>

                        </div>
                    </div>
                

                </div>
                <!-- /.row -->

            </div>

 @permission('print-voucher')
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        @endpermission

              </div>
            <!-- /.container-fluid -->


<input type="hidden" name="account_id" id="account_id" value="{{$account->id}}">

@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
function openThisVoucher(self)
{
    var id = $(self).data("id");
    var url="{{url('general-journal-entries/voucher-detail')}}/"+id;
    window.open(url);

}
    $('.tbl').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    $('#daterange-btn').daterangepicker(
        {
          

            ranges: {
                'Today': [moment(), moment()],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
          },
        
        );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();
            account_id = $('#account_id').val();

            var data = {'date_range':date_range,'account_id':account_id};
            $.get('/update-account-detail',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('.tbl').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

                
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
     
    </script>


@stop