@extends('layouts.app' )

@section('title')
Edit Chart of Account
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-chart-of-account')
        <li ><a href="{{route('chart-of-account.all')}}">Chart of Account</a></li>
        @endpermission

        <li class="active">Edit Account</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box" style="height: 450px;">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Edit Account</h3>
                            <p class="text-muted m-b-30 font-13"> Update Information </p>
                            <form class="form-horizontal" action="{{route('chart-of-account.update')}}" method="post">
                               {{csrf_field()}}
                               <input type="hidden" name="id" value="{{$account->id}}">
                               

                               <div class="form-group" >
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Type <span style="color: red">*</span></label>
                                    <div class="col-sm-5">
                                        <div class="input-group" style="width:300px;display: inline-block;">

                                            <select class="form-control chosen-select" name="account_type_id" id="type" onclick="updateSummary(this.value)">
                                                
                                                @foreach($types as $t)
                                                @if($account->account_type_id == $t->id)
                                                <option selected="" value="{{$t->id}}">{{$t->name}}</option>
                                                @else
                                                <option value="{{$t->id}}">{{$t->name}}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        @if ($errors->has('type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                @endif
                                


                                        </div>

                                    </div>

                                    <div id="type-div" class="col-sm-5" style="border: 1px solid #015c4e; display: none;">

                                        <div style="display: inline;" id="type-result">
                                    
                                </div>

                                    </div>
                                </div>

                                
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{$account->name}}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> SubAccount of </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="sub_account_id" >
                                                <option>None</option>
                                                @foreach($accounts as $a)
                                                @if($account->sub_account_id == $a->id)
                                                <option selected="" value="{{$a->id}}">{{$a->number}} - {{$a->name}}</option>
                                                @else
                                                <option value="{{$a->id}}">{{$a->number}} - {{$a->name}}</option>

                                                @endif
                                                @endforeach
                                            </select>

                                            
                                        @if ($errors->has('sub_account_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sub_account_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>



                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Number <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="number" value="{{$account->number}}" id="exampleInputuname" placeholder="Number">
                                        @if ($errors->has('number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Description </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea rows="4" class="form-control" name="description" >{{$account->description}} </textarea>
                                        @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                

                                

                                

                                    <div class=" col-sm-4"></div>
                                <div class="form-group ">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 10%; margin-left: -110px;">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script>

    function updateSummary(id) {

        var data = {'id':id};
            $.get('/chart-of-account/get-account-description',data,function(data){

            
                document.getElementById('type-result').innerHTML = data;
                document.getElementById('type-div').style.display = 'block';
            });

    }

</script>
@stop
