@extends('layouts.app')

@section('title')
Chart of Accounts
@stop

@section('css')


<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->

<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
<style type="text/css">
    @media print {
        
     .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important;
        }
        
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px !important;
    font-size: 12px;
    border: 1px solid #ccc;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse !important;
    }

    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    table.dataTable thead td, table.dataTable thead th {
    border-bottom: none !important;
    }
  table.dataTable.no-footer {
    border-bottom: none !important;
    }
    a{
        color: black !important
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
     .bdr thead tr th  {
    border: 1px solid #2e3233 !important;
    background: #eee;
    }
    .container-fluid {
    padding: 3px 0px 5px;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    .page-wrapper {
    padding-top: 0px;
    }
    .white-box1{
        padding: 0;
    }
    .pagination{
        display: none;
    }
    .box-title{
        text-transform: uppercase;
        text-align: center;
        font-weight: 600;
    }
    }
</style>

@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Chart Of Accounts</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">

                 <!--.row-->
                <div class="row no-print">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Customize Report</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">

                                                <div class="col-md-5">         
                                               <div class="form-group">
                                                <label class="col-sm-3 control-label">By Name</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group" >
                                                        <div class="input-group-addon">
                                                        <i class="fa fa-search" aria-hidden="true"></i>
                                                        </div>
                                                        <select class="form-control chosen-select" name="acc_name" id="acc_name">
                                                            <option value="0">None</option>
                                                            @foreach($all_accounts as $ac)
                                                            <option value="{{$ac->id}}">{{$ac->number}} - {{$ac->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        

                                        <div class="col-md-5">



                                            <div class="form-group">
                                                <label class="col-sm-3 control-label">By Type</label>
                                                <div class="col-sm-9">
                                                    <div class="input-group" >
                                                        <div class="input-group-addon">
                                                        <i class="fa fa-search" aria-hidden="true"></i>
                                                        </div>
                                                        <select class="form-control chosen-select" id="acc_type" name="acc_type">
                                                            <option value="0">None</option>
                                                            @foreach($types as $t)
                                                            <option value="{{$t->id}}">{{$t->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-actions">
                                            <button type="button" class="btn btn-success update-record"> <i class="fa fa-check" ></i> Update</button>
                                        </div>
                                    </div>
                                            
                                        </div>

                                        
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
                <!-- /row -->
                <div class="row" >

                    <div class="col-sm-12">
                        <div class="white-box">
                            <br>
                            <div class="pull-right no-print">
                                 @permission('create-chart-of-account')
                                <a href="{{route('chart-of-account.addView')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add new Account
                                </a>
                                @endpermission
                            </div>
                            <div class="text-right">
                                <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button" style="margin-right: 6px;"> <span><i class="fa fa-print"></i> Print</span>
                                </button>
                            </div>
                            <h3 class="box-title">Chart of Accounts</h3>

                            <div class="table-responsive" id="update-report">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr. No</th>
                                            <th>Code</th>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Balance</th>
                                            <th class="no-print">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($accounts as $a)
                                        
                                        @if(!empty($a->type))
                                        
                                        <tr>
                                            <td>{{$count++}}</td>

                                            @if($leafAccount[$a->id])

                                            @if($a->sub_account_id)
                                            <td>{{$a->number}} </td>
                                            <!-- &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; -->
                                            <td>{{$a->name}}</td>
                                            @else
                                            <td>{{$a->number}}</td>
                                             <td>{{$a->name}}</td>
                                            @endif

                                            @else

                                            @if($a->sub_account_id)
                                            <td><b style="font-weight:700">{{$a->number}}</b></td>
                                            <td><b style="font-weight:700">{{$a->name}}</b></td>
                                            @else
                                            <td><b style="font-weight:700">{{$a->number}} </b></td>
                                            <td><b style="font-weight:700">{{$a->name}}</b></td>
                                            @endif


                                            @endif

                                            <td>{{$a->type? $a->type->name: ''}}</td>
                                            
                                           <td class="text-right">
                                                @if($leafAccount[$a->id])
                                                    <a href="{{route('chart-of-account.detail',['id'=>$a->id])}}">{{\App\GeneralJournalEntry::getAccountBalance($a->id) }}</a>
                                                @endif
                                            </td>
                                            

                                           
                                            <td class="text-nowrap no-print">
                                                @permission('view-chart-of-account')
                                                @if($leafAccount[$a->id])
                                                <a href="{{route('chart-of-account.detail',['id'=>$a->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endif
                                                @endpermission

                                                @permission('edit-chart-of-account')
                                                <a href="{{route('chart-of-account.editView',['id'=>$a->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('delete-chart-of-account')
                                                <a href="{{route('chart-of-account.delete',['id'=>$a->id])}}" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        
                                        @endif
                                        @endforeach

                                    </tbody>
                                </table>

                                {{$accounts->links()}}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>
    

    $('#myTable').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf'
        ]
    } );

    </script>

<script>
    $('.update-record').on('click',function(){

        $('.preloader').fadeIn();
            
            name = $('#acc_name').val();
            type = $('#acc_type').val();

            var data = {'name':name,'type':type};
            $.get('/chart-of-accounts/update-record',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('#myTable').DataTable({
                        'sorting':false,
                        'paging':false,
                        'ordering':false,
                        'searching':false,
                        'info':true,
                        'dom': 'Bfrtip',
                        'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                        ]
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });


    
    </script>
@stop