@extends('layouts.app' )

@section('title')
Activity Log 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Activity Log</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                <!-- <a href="{{route('customer.addView')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add new Customer
                                </a> -->
                            </div>
                            <h3 class="box-title">All Recent Activities</h3>
                            <form method="GET" action="{{route('user.log')}}">
                                <div class="row">

                                <div class="col-sm-3">
                                <label style="font-weight: 700;">By User<span style="color: red;">*</span></label>
                                <select class="form-control chosen-select" id="user" name="user" required>
                                 @foreach($users as $user )
                                <option value="{{$user->id}}">{{$user->name}}</option>
                                @endforeach
                                </select>
                                </div>


                                <div class="col-sm-5">
                                <div class="row">

                                <div class="col-sm-6">
                                <label style="font-weight: 700;">From<span style="color: red;">*</span></label>
                                <input type="date"  class="form-control" name="from" id="from" required>
                                </div>

                                <div class="col-sm-6">
                                <label style="font-weight: 700;">To<span style="color: red;">*</span></label>
                                <input type="date"  class="form-control" value="{{date('Y-m-d')}}" name="to" id="to" required>
                                </div>

                                </div>
                                </div>

                                <div class="col-sm-2" style="margin-top: 2.5rem;">
                                <button type="submit" class="btn btn-success">Filter</button>
                                </div>

                                </div>
                                </form>
                            <div class="table-responsive">
                                
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Action</th>
                                            <th>Description</th>
<!--                                            <th>S/O</th>-->
                                            <th>User</th>

                                            <th>Time</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($activity as $a)
                                        <tr>
                                            <td>{{$count++}}</td>
                                             <td>{{$a->log_name}}
                                             </td>
                                            <td>{{$a->description}}</td>
                                            @if($a->user)
                                            <td>{{$a->user->name}}</td>
                                            @else
                                            <td></td>
                                            @endif


                                            <td>{{$a->created_at}}</td>
                                           
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                                <div style="float: right;">
                                 {{--    {{$activity->links()}} --}}
                                 {{ $activity->appends(request()->input())->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':50,
            'paging':false,
            'info':false
        });

});
    </script>
@stop