@extends('layouts.app')
@section('title')
Agreement 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-left no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
    @permission('list-membership')
    <li ><a href="{{route('statement.all')}}">Statements</a></li>
    @endpermission
    <li class="active">Statement Detail</li>
</ol>
<div class="container-fluid" style="padding: 6px 30px 0 0;">
    <div class="pull-right">
        <div class="text-right" style="display: inline-block;">
        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>
</div>

@stop
@section('content')

<div class="container-fluid">
    <div class="row printableArea"  id="content">
        <div class="col-lg-12">
            <div class="white-box border-none mt-95">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row text-center">
                            <u><b>The AMAAR LODGES SALES AGREEMENT</b></u>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="row" >
                            <div class="col-xs-12 col-sm-12">
                                <br>
                                This agreement (hereinafter referred as the Agreement) has been carried out by <b>M.R.N
Constructions LLP.</b> at their site located <b>“AT MOZA Masiari ADDRESS, Masiari Link Road,
Murree”</b> on 16th day of September , 2021 between:
                                <div class="text-center"><b><br><br>
                                    <span >THE FIRST PARTY
( THE AMAAR LODGES )</span></b></div>
<hr>
<span><b>M.R.N Constructions LLP</b></span>
 </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <div class="row text-center">
                            <span >AND</span><br><br>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-xs-12 col-sm-12 text-center">
                                <p>
                                    THE Second PARTY<br>
(heirs, successors and assignees)
<hr>
<span>Nauman Adeel S/O Muhammad Adam</span><br>
<span>CNIC</span><br>
<span>3 7 2 0 1 -8 5 1 3 7 1 6 -5</span><br>
<span>House no 646, Street no 58, Sector I-8/2, Islamabad.</span>
                                </p>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12"><br>
                        <b style="margin-top: 4%;"><u>RECITALS</u></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <u>Whereas,</u>
                    </div>
                    <div class="col-sm-12 col-xs-12 mt-18">
                        <ol type="a">
                          <li>The First Party and the Second Party shall collectively be referred to as “Parties” and individually as a “Party”.  
                          </li>
                          <li>The First Party is in the business of construction, managing and operating The Amaar Lodges Murree, a project consisting of apartments situated at Masiari Link Road (hereinafter referred to as The Amaar Lodges).
                          </li>
                          <li>The Second Party wishes to purchase an apartment from The First Party at The Amaar Lodges.
                          </li>
                        </ol>
                    </div>
                    <div class="col-xs-12 col-sm-12">
                        <p>Now, THEREFORE in consideration of the foregoing understanding and the mutual covenants set forth herein, the parties hereby agree as follows:</p>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>1. </b><b><u>DEFINITIONS AND INTERPRETATION</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>1.1 The recitals form an integral and operative part of this Agreement.</li>
                               <li>1.2 Unless the context otherwise requires, the following terms shall have the meanings ascribed to them as under: </li>
                           </ul>                          
                           <ul class="style-none" style="list-style-type: none;">
                             <li><b>“M.R.N Constructions LLP”</b> shall bear the meaning ascribed thereto in the recitals.</li>
                               <li><b>“Applicable Laws”</b> shall mean all the federal, provincial and local laws of Pakistan, and all orders,
rules regulations, statutory regulatory orders, decrees, judicial decisions, notifications, or other similar
directives issued by any public authority pursuant thereto.</li>
                               <li><b>“By-Laws”</b> shall mean the rules and regulations introduced and implemented by the First Party to regulate the operations and management of The Ammar Lodges and the relationship between the First Party and its allottees (including the Second Party), its staff, tenants, visitors, occupants, management and maintenance staff;</li>
                               <li><b>“Common Area”</b> shall mean those parts of The The Ammar Lodges not physically forming part of the shop, or any other shop, and intended for the common use of all occupants of The The Ammar Lodges;</li>
                               <li><b>“Down Payment”</b> shall mean the percentage amount of the Total Consideration to be paid by the Second Party to the First Party in relation to the acquisition of the shop, on or before the execution of this Agreement; </li>
                               <li><b>“Force Majeure Event”</b> shall bear the meaning ascribed thereto in Company Clause</li>
                               <li><b>“Installments”</b> shall mean the periodic payments forming part of the Total Consideration by the Second Party to the First Party as per the Payment Schedule;</li>
                               <li><b>“Management Agreement”</b> shall mean the management agreement to be entered into with regard to, inter alia, the Second Party’s contribution towards the costs of the management, administration and maintenance of The The Ammar Lodges; </li>
                               <li><b>“Management Committee”</b> shall mean the committee constituted by the First Party to manage The The Ammar Lodges; </li>
                               <li><b>“Next of kin”</b> shall mean the legal successor of the Second Party;</li>
                               <li><b>“Notice of Possession”</b> shall mean the First Party’s notice to take possession of the shop; </li>
                               <li><b>“Payment Schedule”</b> shall mean the schedule of Installments of the Total Consideration as set out in Company Clause; </li>
                               <li><b>“Permitted Use”</b> means the use of the shop as approved by the Management Committee, and in compliance with the By-Laws and the terms of this Agreement; </li>
                               
                               <li><b>“Property”</b> shall mean a piece of area in The Amaar Lodges to be purchased by The Second Party on the terms and conditions of this Agreement, as further described in Clause Section 2.</li>
                               <li><b>“Apartment”</b> shall mean a set of finished room(s) for living in for residential use only.</li>
                               <li><b>“Service Charge Agreement”</b> shall mean the agreement to be executed between the Parties in relation to the services provided by The First Party.</li>
                               <li><b>“Untoward Incident”</b> shall mean any event that results in death or incapacitation of the Second Party;</li>
                           </ul>
                           <p>In this Agreement, words denoting the singular include the plural and vice versa and words denoting a gender include both genders and references to persons include bodies corporate or unincorporated; <br><br>
    The Parties understand that in case of any ambiguity, confusion or dispute regarding the interpretation of any clause of this Agreement, the interpretation thereof under the By-Laws shall be construed to be the correct and true interpretation.<br><br>
    In case of any conflict between the provisions of this Agreement and the By-Laws, the provisions of the By-Laws shall prevail.<br><br>
    The Second Party agrees and understands that the First Party may amend the By-Laws from time to time in accordance to any change in Government policy/Laws, and which will be applicable to the both parties.<br>
</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>2. </b><b><u>AGREEMENT FOR TRANSFER OF RIGHTS</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul class="style-none" style="list-style-type: none;">
                               <li>2.1 The First Party hereby agrees to sell and The Second Party hereby agree to purchase the property having details:</li>
                               
                               <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b>Address:</b></td>
                                            <td><b>Floor:</b></td>
                                            <td><b>Permitted Use:</b></td>
                                            <td><b>Approximate Size:</b></td>
                                        </tr>
                                        <tr>
                                            <td>LG504A</td>
                                            <td>LG5</td>
                                            <td>Appartment</td>
                                            <td>536sq.ft</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <span>On the term and conditions of this Agreement and the By-laws.</span>
                            <li>2.2 The Second Party has agreed to pay the Total Unit Price:<br>
                            <span class="text-center">PKR 6,432,000/ - ( Rupees Sixty Four Lakh Thirty Two Thousand Only )</span><br>
                            as the purchase price of the property, in the Installments per the Payment Schedule set out in Company Clause.
                        </li>
                        <li>2.3 For the avoidance of doubt, the Total Consideration shall not include any installation charges pertaining to electricity connection, generator back-up, fiber optics, and gas (subject to availability). Any other utilities request by The Second Party may be installed at the cost of The Second Party on mutually agreed terms.
                        </li>
                        <li>2.4 The actual total area of the Property will be measured before final possession is handed over to The Second Party and any difference between the approximated area and the actual area may be adjusted. In case the actual area of the Property is more than the approximated size, The Second Party shall pay the applicable rate for the excess area. However, in case of actual area of the Property is less than the approximated size, The Second Party may be entitled to a refund based on the applicable rate. 
                        </li>

                            </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>3. </b><b><u>DOWN PAYMENT</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>3.1 The Parties acknowledges that The Second Party has paid, and the First has received:</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>4. </b><b><u>PAYMENT OF INSTALLMENTS</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                             
                             <div class="table-responsive">
                                <table class="table table-bordered">
                                    
                                    <tbody>
                                        <tr>
                                            <td>Received Amount:</td>
                                            <td>1,500,000 / - ( Rupees Fifteen Lakh Only )</td>
                                        </tr>
                                        <tr>
                                            <td>Remaining Amount: </td>
                                            <td>PKR : 4,932,000 / - ( Rupees Forty Nine Lakh Thirty Two Thousand Only )</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <ul class="style-none" style="list-style-type: none;">
                               <li>4.1  The Second Party shall ensure timely payment of the Installments through cash, pay order, demand draft or electronic funds Transfer to the First Party/ The Ammar Lodges’s in accordance with the following Payment Schedule:</li> 
                            
                             <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th class="font-13">Payment Head</th>
                                            <th class="font-13">Due Date</th>
                                            <th class="font-13">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Down Payment</td>
                                            <td>06-09-2021</td>
                                            <td>100,000</td>

                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <li>4.2 Any and all payments made by The Second Party under this Agreement shall be without set-off or
counterclaim from any third party and free and clear of any taxes, deductions and withholdings.</li>
                            <li>4.3 The Second Party agrees that The First Party may take legal action directly against The Second
Party to enforce collection of unpaid amounts.</li>
                            <li>4.4 The Second Party will ensure timely payment of each Installment As per the Payment Schedule
set out above to ensure uninterrupted construction and timely completion of The Amaar Lodges
building.</li>
                            <li>4.5 If receipt of any Installment is delayed by more than ninety (90) days, The First Party will issue a
final payment notice to The Second Party, demanding payment of the outstanding amount within (7)
Seven days. If The First Party does not receive the relevant, Installment payment within the said Seven 
(7) days period, the allotment of the Property shall stand automatically canceled without issuance of
any future notices.</li>
                            <li>4.6 Subject to the completion of the construction of The Amaar Lodges building, in case of any delay
by The Second Party in taking possession of the Property, The First Party will be entitled to receipt of
charges from The Second Party under the service charge Agreement. Further, if The Second Party
delays taking possession of the Property beyond forty-five (45) days from issuance of notice of
possession, The First Party shall be entitled to terminate this agreement and any allotment of the
Property. In case The First Party exercises its right to termination pursuant to this clause, The First
Party shall refund the amount received from The Second Party (after making the necessary
adjustments) as per company clause.</li>
                             </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>5. </b><b><u>COMPLETION PERIOD AND POSSESSION</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>5.1 The First Party shall complete the construction of <b>The Ammar Lodges</b> structure within a period of fourteen months (14) months.</li>
                               <li>5.2 On or before the actual construction completion of The Ammar Lodges the First Party shall issue the Notice of Possession, which shall, inter alia, require the Second Party to; </li>
                                <ol type="i">
                                    <li>Pay all outstanding charges, including any pending Installments and amounts under the Management Agreement or the Service Charge Agreement, if any;</li>
                                    <li>Execute the Management Agreement and the Service Charge Agreement, each in a form approved by the First Party;</li>
                                    <li>Take possession of the shop on the date specified in the Notice of Possession. </li>
                                </ol>
                                <li>5.3 In the event the Second Party does not comply with Company Clause and the Payment Schedule above, the Second Party shall be liable to pay late payment charges, as specified by the First Party at the time of imposition. The imposition of the late payment charges shall not affect any other remedy available to the First Party under the Applicable Laws or the terms of this Agreement, the By-Laws, the Management Agreement or the Service Charge Agreement.</li>
                                <li>5.4 In case the Second Party fails to comply with any provision of this Agreement, the First Party shall have the right to withhold the transfer of possession and title of the shop to the Second Party and terminate this Agreement in accordance with its terms.</li>
                                <li>5.5 The Second Party agrees and acknowledges that the First Party reserves the right to extend the construction completion period by way of intimation to the Second Party in case of any event beyond the control of the First Party. For the avoidance of doubt, the First Party shall continue paying the agreed lease rental amount in relation to the shop as discount which is 0.5 percent of the total value of the shop per month.</li>
                                <li>5.6 In case of early construction of The Ammar Lodges, the Second Party grants the First Party the right to lease the shop for the purposes of receiving and paying the agreed lease rental amounts. </li>
                                <li>5.7 That in case the second party clears all of its outstanding dues before or as per installment schedule clause then they will be receiving the rent from the very next month.</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>6. </b><b><u>PAYMENT OF TAXES & DUTIES</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>6.1 The Second Party shall be responsible for payment of all federal or provincial taxes, rates, charges, impositions and duties (howsoever designated, including stamp duties) in respect of the shop.</li>
                               <li>6.2 The Second Party agrees to indemnify and hold harmless the First Party against any and all claims, impositions and penalties imposed by any authority in relation to any tax regarding the shop. </li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>7. </b><b><u>TRANSFER AND ASSIGNMENT</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>7.1  The Second Party may not transfer or assign any rights in relation to the shop without prior written consent of the First Party and in a form other than the form approved and provided for by the First Party. Further, the Second Party may only transfer or assign any right to a third-party after clearing all outstanding dues owed to the First Party.</li>
                               <li>7.2  In case of any Untoward Incident, the allotment will automatically stand transferred to the name of the Next of kin as set out in the application form in accordance with the By-Laws.</li>
                               <li>7.3  The Second Party agrees not to claim any good will/premium/pagri upon the shop being allotted, and in case any such payment is made by/to the Second Party being the transferee/transferor, the First Party will be under no liability to make good the loss of any such amount.</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>8. </b><b><u>REFUND/RESALE</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>8.1 In case any refund is due from the First Party under the terms of this Agreement, the First Party shall refund the said amount from the date of receipt of an undisputed refund notice.</li>
                               <li>8.2 That the second party after completion of (8 months) where in case Second Party have spent specific time and rates gets changed in such case Second Party will give a time period for resale of 45 days and rates will be according to the market rates as per company resale policies.</li>
                               <li>8.3 During the term of this Agreement, the Second Party may, with the approval of the First Party, request a refund of amounts paid for the purchase of the shop. In this case, the Second Party will first handover possession of the shop (if Notice of Possession has been handed over to the Second Party) and certify in writing that no claims or adverse proceedings (of whatsoever nature) are pending against the shop or the Second Party’s rights therein. The First Party shall, at its discretion, immediate refund the said amounts after deducting any adjustable amounts.</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>9. </b><b><u>FORCE MAJEURE</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>9.1 Neither Party shall be liable or responsible for delays or failures in performance under this Agreement, if and to the extent such delay or failure in performance is caused by any occurrence beyond the reasonable control of the affected Party, including any such delay or failure resulting from (a) any Acts of God such as lightning, fire, earthquake, tsunami, flood, storm, cyclone, typhoon or tornado, or (b) any act of war, invasion, armed conflict or act of foreign enemy, or a massive and sustained campaign of terrorism or political sabotage, or (c) the requirements of any legislation, or judicial, quasi-judicial, executive or regulatory order (any such event or occurrence, a “Force majeure Event”). The Party affected by a Force Majeure Event shall as soon as practically possibly notify the other Party in writing of the existence of such Force Majeure Event that makes it impossible for the affected Party to carry out in whole or in part its obligations under this Agreement. The Party affected by a force Majeure Event shall take all reasonable steps to mitigate the effect of such Force Majeure Event. </li>
                               <li>9.2 Should a Force Majeure Event occur, which might delay the completion, the First Party will notify the Second Party of such Force Majeure Event and will give the Second Party a new completion date or an estimate of the duration of the delay caused by the Force Majeure Event, followed by an amended completion date, as the case may be.</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>10. </b><b><u>GOVERNING LAW AND DISPUTE RESOLUTION</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>10.1 This Agreement shall be governed by and construed in accordance with the laws of Pakistan.</li>
                               <li>10.2 Any dispute, controversy or claim arising out of or relating in any way to the Agreement/the relationship, including without limitation, any dispute concerning the construction, validity, interpretation, enforceability or breach of this Agreement, shall be exclusively resolved by binding arbitration upon a Party’s submission of the dispute to arbitration. In the event of a dispute, controversy or claim arising out of or relating in any way to the Agreement, the complaining Party shall first notify the other Party in writing thereof. Within thirty (30) days of such notice, authorized representatives of both Parties shall meet at an agreed location to attempt to resolve the dispute in good faith. Should the dispute not be resolved within thirty (30) days after such notice, the complaining Party shall seek remedies exclusively through arbitration. The demand for arbitration shall be made within a reasonable time after the claim, dispute or other matter in question has arisen, and in no event shall it be made after two (2) years from when the aggrieved party knew or should have known of the controversy, claim, dispute or breach</li>
                               <li>10.3 This agreement to arbitrate shall be specifically enforceable. A Party may apply to any court with jurisdiction for interim or conservatory relief, including without limitation a proceeding to compel arbitration.</li>
                               <li>10.4 The arbitration shall be conducted by (3) arbitrator(s). 
For three arbitrators, each party shall select an arbitrator within (10) days of commencement of the arbitration, who shall serve as a neutral arbitrator, and the two designated arbitrators shall select a third neutral arbitrator within (20) days of their selection of the parties. 
If the Parties are not able to agree upon the selection of an arbitrator, within (20) days of commencement of arbitration proceedings by service of a demand for arbitration, the arbitrator shall be selected by the Court of competent jurisdiction in accordance with the terms of this agreement.
If the two arbitrators cannot agree on selection of a third arbitrator within (20) days of their appointment, the Court of competent jurisdiction shall select such arbitrator in accordance with the terms of this agreement. 
</li>
                            <li>10.5 The arbitration shall be conducted in accordance with the Arbitration Act, 1940.</li>
                            <li>10.6 The arbitration shall be conducted in Islamabad. </li>
                            <li>10.7 The laws of the Pakistan shall be applied in any arbitration proceedings, without regard to principles of conflict of laws. </li>
                            <li>10.8 The arbitration shall be conducted in the English language.</li>
                            <li>10.9 It is the intent of the Parties that, barring extraordinary circumstances, arbitration proceedings will be concluded within (120) days from the date the arbitrator(s) are appointed. The arbitrator[s] may extend this time limit in the interests of justice. Failure to adhere to this time limit shall not constitute a basis for challenging the award.</li>
                            <li>10.10 Except as may not be required by law, a Party, nor its representatives, may disclose the existence, content, or results of any arbitration hereunder without the prior written consent of the other Party.</li>
                            <li>10.11 The decision of the arbitrators shall be final and binding on the Parties.</li>
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>11. </b><b><u>USAGE OF THE PROPERTY</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>11.1 The arbitration shall be conducted in Rawalpindi.</li>
                               <li>11.2 The Second Party shall not use or cause to be used the Property for any unlawful activity, or for
any activity deemed to be disreputable, immortal, unethical or hazardous.</li>
                               <li>11.3 The Second Party fully understands that the Property or any portion thereof cannot be used for
lodging/sleeping purposes.</li>
                               <li>11.4 No standees, flex banners, advertisement will be allowed to outside the Property, except for the
space/place provided (if any) for the same by the management committee of The Amaar Lodges is
accordance with the By-Laws.</li>
                               <li>11.5 The Second Party will not carry out any activities that may be considered dangerous or may
create any hazard (including storage of paper that may create a fire hazard.</li>
                              
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>12. </b><b><u>MARKETING & SELLING
</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>12.1 The First Party has nominated <b>“Right Marketing Pvt Ltd.”</b> for marketing and selling of The
Amaar Lodges on exclusive basis.</li>
                               <li>12.2 All the information passed on to The Second Party by Right Marketing (Pvt) Ltd. to the best of
their knowledge provided by The First Party.
</li>
                               <li>12.3 Right Marketing (Pvt) Ltd. is an official representative on behalf of both Parties, providing
consultancy services only.</li>
                              
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>13. </b><b><u>LIMITATION OF LIABILITIES
</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>The cumulative aggregate liability of The First Party, under this Agreement, shall be limited to the
actual amount received from The Second Party in relation to the purchase of the PROPERTY.</li>                            
                           </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>14. </b><b><u> ENTIRE AGREEMENT
</u></b></b>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                                <ul style="list-style-type: none;">
                               <li>14.1 All terms and conditions set out herein are an essential part of the Agreement and the
understanding on which The First Party has agreed to sell and allot the Property.</li>
                            <li>14.2 The terms and conditions, set in this Agreement (including the schedules attached hereto, if any),
constitute the full, final, and entire terms and conditions of the Agreement between parties in
connection with the subject matter here of, and anything not specifically incorporated in this Agreement
(including the schedule attached hereto) shall not be implied or construed in any manner whatsoever
as a part of or attributable to this Agreement.
</li>                          
                           </ul>
                           <span>IN WITNESS WHEREOF the parties have signed this Agreement in the Presence of Witnesses at the
place and on the date first written above.</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <br>
                        <b style="margin-top: 6%;"><b>PARTYWITNESS:</b>
                    </div><br><br><br><br>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row" >
                            <div class="col-sm-12 col-xs-12">
                           <div class="row">
                               <div class="col-sm-6 col-xs-6">
                                   <span>1.<b>_____________________________</b></span><br>
                                   <span><b>Right Marketing (Pvt) Ltd</b></span><br>
                                   <p style="font-weight: 400">Umer Shahzad C.E.O</p><br>
                               </div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>2.<b>____________________________</b></span><br>
                                   <span><b>Buyer's Name</b></span><br>
                                   <span style="font-weight: 400">(Buyer)</span><br>
                                   <span>&nbsp;&nbsp;&nbsp; <b>CNIC#:</b>52865-695856-8</span><br>
                               </div>
                               <div style="height: 150px"></div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>3.<b>_____________________</b></span><br>
                                   <span><b>&nbsp;&nbsp;&nbsp;Witness-1</b></span><br>
                               </div>
                               <div class="col-sm-6 col-xs-6">
                                   <span>4.<b>_____________________</b></span><br>
                                   <span><b>&nbsp;&nbsp;&nbsp;Witness-2</b></span><br>
                               </div>                               
                           </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12 text-center">
                        <br><br><br>
                        <b style="margin-top: 6%;"><b>THE FIRST PARTY THE AMAAR LODGES SIGNATURES</b>
                        <br><br><br>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <span><b>Raja Nabeel</b></span>
                        <hr>
                        <span><b>38101-9677461-7</b></span><br>
                        <span><b>(Chairman & CEO)</b></span><br>
                        <span><b>M.R.N Constructions LLP</b></span>
                    </div>
                </div>
            </div>
        </div>
        

        

    </div>
    <!-- <div style="display: inline-block;    margin-bottom: 70px;">
        <div class="text-right" style="display: inline-block;">
        <button id="print" class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div> -->
</div>
<!-- /.container-fluid -->



@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(document).ready(function(){
    $("#print").on("click", function () {
         var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = { mode : mode, popClose : close};
        $("div.printableArea").printArea( options );
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop