<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" sizes="16x16" href="{{asset('plugins/images/favicon.ico')}}">
    <title>Login | {{env('APP_NAME')}}</title>
    <!-- ===== Bootstrap CSS ===== -->
    <link href="{{asset('bootstrap/dist/css/bootstrap.min.css')}}" rel="stylesheet">
    <!-- ===== Plugin CSS ===== -->
    <!-- ===== Animation CSS ===== -->
    <link href="{{asset('css/animate.css')}}" rel="stylesheet">
    <!-- ===== Custom CSS ===== -->
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <!-- ===== Color CSS ===== -->
    <link href="{{asset('css/colors/default.css')}}" id="theme" rel="stylesheet">
</head>

<body class="mini-sidebar">
    <!-- Preloader -->
    <div class="preloader">
        <div class="cssload-speeding-wheel"></div>
    </div>
    <section id="wrapper" class="login-register">
    <br><br><br>

        <div class="login-box">
            <div class="text-center">
                
                <img src="{{asset('images/logoo1.png')}}" class="logo-img" style="margin-top: 11px">
            </div>
                <h1 class="text-center" style="padding: 9px 0 0 0;">ERP Portal</h1>
            <div class="white-box">
               <form class="form-horizontal form-material" id="loginform" action="{{ route('login') }}" method="POST" autocomplete="off">
            <!--  fake fields are a workaround for chrome/opera autofill getting the wrong fields -->
                    <input id="username" style="display:none" type="text" name="fakeusernameremembered">
                    <input id="password1" style="display:none" type="password" name="fakepasswordremembered">
                    {{ csrf_field() }}
                    <h3 class="box-title m-b-20">Sign In</h3>
                    <div class="form-group ">
                        <div class="col-xs-12">
                            <input class="form-control" id="email" type="text" name="email" value="{{ old('email') }}" required="" placeholder="Email" autocomplete="off">
                            @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-12">
                            <span class="btn-show-pass">
                                <i id="eye" class="fa fa-eye"></i>
                            </span>
                            <input class="form-control" id="password" type="password" name="password" required="" placeholder="Password" autocomplete="off">
                            @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <!-- <div class="checkbox checkbox-primary pull-left p-t-0">
                                <input id="checkbox-signup" type="checkbox">
                                <label for="checkbox-signup"> Remember me </label>
                            </div> -->
                            <a href="javascript:void(0)" onclick="return showForgetPasswordForm(this)" class="text-dark pull-right"><i class="fa fa-lock m-r-5"></i> Forgot password?</a> </div>
                    </div>
                    <div class="form-group text-center m-t-20">
                        <div class="col-xs-12">
                            <button class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light" type="submit">Log In</button>
                        </div>
                    </div>
<!--                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 m-t-10 text-center">
                            <div class="social">
                                <a href="javascript:void(0)" class="btn  btn-facebook" data-toggle="tooltip" title="Login with Facebook"> <i aria-hidden="true" class="fa fa-facebook"></i> </a>
                                <a href="javascript:void(0)" class="btn btn-googleplus" data-toggle="tooltip" title="Login with Google"> <i aria-hidden="true" class="fa fa-google-plus"></i> </a>
                            </div>
                        </div>
                    </div>-->
                    <div class="form-group m-b-0">
                        <!-- <div class="col-sm-12 text-center">
                            <p>Don't have an account? <a href="{{route('register')}}" class="text-primary m-l-5"><b>Sign Up</b></a></p>
                        </div> -->
                    </div>
                </form>
            </div>
        </div>
    </section>



<!-- Modal -->
<div class="modal fade" id="forget_password_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Forget password?</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="alert alert-danger" style="display:none;" role="alert" id="error_alert">
        Email Does Not Match With Our Record.
        </div>

        <div class="alert alert-success" style="display:none;" role="alert" id="success_alert">
        Password has Been Sent To Your  Given Email Account!
        </div>
        <label>Please Give Your Valid Email</label>
        <form method="GET" onsubmit="return validateUserEmail(this);">
           <input type="email" class="form-control" required id="user_email"> 
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary" id="saveBtn">Save </button>
      </div>
  </form>

    </div>
  </div>
</div>



    <!-- jQuery -->
    <script src="{{asset('plugins/components/jquery/dist/jquery.min.js')}}"></script>
    <!-- Bootstrap Core JavaScript -->
    <script src="{{asset('bootstrap/dist/js/bootstrap.min.js')}}"></script>
    <!-- Menu Plugin JavaScript -->
    <script src="{{asset('js/sidebarmenu.js')}}"></script>
    <!--slimscroll JavaScript -->
    <script src="{{asset('js/jquery.slimscroll.js')}}"></script>
    <!--Wave Effects -->
    <script src="{{asset('js/waves.js')}}"></script>
    <!-- Custom Theme JavaScript -->
    <script src="{{asset('js/custom.js')}}"></script>
    <!--Style Switcher -->
    <script src="{{asset('plugins/components/styleswitcher/jQuery.style.switcher.js')}}"></script>


    <script type="text/javascript">

        function validateUserEmail(self) 
        {
          $('#saveBtn').prop('disabled' , true)
        $.ajax({
        url:"{{ route('forget.password') }}",
        method:'GET',
        data: {email:$(self).find('#user_email').val()},
        success:function(data)
        {
          
          if (data == '0') 
          {
            $('#error_alert').show('Slow');
            setTimeout(function(){ $('#error_alert').hide('Slow'); }, 5000);
          }

          if (data == '1') 
          {
            $('#success_alert').show('Slow');
            setTimeout(function(){ 
            $(self).find('#user_email').val('')
            $('#forget_password_modal').modal('hide')
            $('#success_alert').hide('Slow');
            }, 3000);
          }

          $('#saveBtn').prop('disabled' , false)

        }
        })

          return false;    
        }

        function showForgetPasswordForm(self) 
        {
            

            $('#forget_password_modal').modal({
            backdrop: 'static',
            })

            return false;
        }

        window.setTimeout('emptyfield()',1000);

        function emptyfield() {
            $('#password').val('');
            $('#email').val('');
        }

        $(function () {
            $("#eye").click(function () {
                $(this).toggleClass("fa-eye fa-eye-slash");
               var type = $(this).hasClass("fa-eye-slash") ? "text" : "password";
                $("#password").attr("type", type);
            });
        });

</script>
</body>

</html>
