<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('plugins/images/favicon.png')}}">
    <title>Login | Hamdard City</title>
    <!-- ===== Bootstrap CSS ===== -->
    <link href="{{asset('bootstrap/dist/css/bootstrap.min.css')}}" rel="stylesheet">
    <!-- ===== Plugin CSS ===== -->
    <!-- ===== Animation CSS ===== -->
    <link href="{{asset('css/animate.css')}}" rel="stylesheet">
    <!-- ===== Custom CSS ===== -->
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
    <!-- ===== Color CSS ===== -->
    <link href="{{asset('css/colors/default.css')}}" id="theme" rel="stylesheet">

    <link href="{{asset('css/toast.css')}}" rel="stylesheet">

</head>

<body class="mini-sidebar">
    <!-- Preloader -->
    <div class="preloader">
        <div class="cssload-speeding-wheel"></div>
    </div>
    <section id="wrapper" class="login-register">
<br><br><br>

        <div class="login-box">
            <div class="text-center">
                <div class="box-circle"></div>
                <img src="{{asset('plugins/images/logoColor.png')}}" class="logo-img"></div>
                <h1 class="text-center" style="padding: 9px 0 0 0;">Sales Portal</h1>
            <div class="white-box">
               
            <!--  fake fields are a workaround for chrome/opera autofill getting the wrong fields -->
                    <h3 class="box-title m-b-20">Sign In</h3>
                    <div class="form-group ">
                        <div class="col-xs-12">
                            <input class="form-control" id="phone_number" type="text" name="phone)number" value="{{ old('phone_number') }}" required="" placeholder="Enter Register Phone Number" autocomplete="off">
                            @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif
                        </div>
                    </div>
                    <br>
                    <div class="form-group" style="display: none;" id="otp-div">
                        <div class="col-xs-12">
                            <input class="form-control" id="otp" type="text" name="otp" value="{{ old('otp') }}" placeholder="Enter OTP"  autocomplete="off">
                            @if ($errors->has('otp'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('otp') }}</strong>
                                    </span>
                                @endif
                        </div>

                        <div class="col-md-12">
                            
                            <a href="javascript:void(0)" onclick="requestOTP()" id="to-recover" class="text-dark pull-right"><i class="fa fa-lock m-r-5"></i> Resend Otp?</a> </div>
                            <br>
                    </div>
                    
                    <div class="form-group text-center m-t-20">
                        <div class="col-xs-12">
                            <button id="request-login-btn" class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light" type="button" onclick = "requestOTP()" >Log In</button>

                            <button style="display: none;" id="login-btn" class="btn btn-info btn-lg btn-block text-uppercase waves-effect waves-light" type="button" onclick = "login()" >Log In</button>
                        </div>
                    </div>

                    <div class="form-group m-b-0">
                        
                    </div>
                </form>
            </div>
        </div>
    </section>
    <!-- jQuery -->
    <script src="{{asset('plugins/components/jquery/dist/jquery.min.js')}}"></script>
    <!-- Bootstrap Core JavaScript -->
    <script src="{{asset('bootstrap/dist/js/bootstrap.min.js')}}"></script>
    <!-- Menu Plugin JavaScript -->
    <script src="{{asset('js/sidebarmenu.js')}}"></script>
    <!--slimscroll JavaScript -->
    <script src="{{asset('js/jquery.slimscroll.js')}}"></script>
    <!--Wave Effects -->
    <script src="{{asset('js/waves.js')}}"></script>
    <!-- Custom Theme JavaScript -->
    <script src="{{asset('js/custom.js')}}"></script>
    <!--Style Switcher -->
    <script src="{{asset('plugins/components/styleswitcher/jQuery.style.switcher.js')}}"></script>

<script src="{{asset('js/app-toast.js')}}"></script>
    <script type="text/javascript">


    function requestOTP() {
        
        $('.preloader').fadeIn();

        var data = {'phone_number':$('#phone_number').val()};
        $.get('/auth/requestOTP', data, function (data) {

            if(data.success == true) {
                toastr.info(data.message);
                //show the otp field
                document.getElementById('otp-div').style.display = 'block';
                //change the click events
                document.getElementById('request-login-btn').style.display = 'none';
                document.getElementById('login-btn').style.display = 'block';

            }
            else {
                toastr.error(data.message);
            }

            
            
        });

        $('.preloader').fadeOut();
    }

    function login() {
        
        $('.preloader').fadeIn();

        var data = {'phone_number':$('#phone_number').val(),'otp':$('#otp').val()};
        $.get('/auth/login', data, function (data) {

            if(data.success == true) {
                toastr.info(data.message);
                window.location = "/";
            }
            else {
                toastr.error(data.message);
            }

            
            
        });

        $('.preloader').fadeOut();
    }



        
</script>
</body>

</html>
