@extends('layouts.app')

@section('title')
All Backups
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Backups</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">

               


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								 <a href="{{route('backup.create')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Create New Backup
								</a> 
							</div>
                            <h3 class="box-title">Administer Database Backup</h3>

                            <div class="table-responsive" >
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>File</th>
                                            <th>Size</th>
                                            <!--  <th>Created Date</th>  -->
                                            <th>Action</th> 
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($backups as $b)
                                        <tr>
                                            <td>{{$count++}}</td>
                                             <td>
                                                 {{$b['file_name']}}
                                             </td>
                                            <td>
                                                {{round($b['file_size'] / 1024 / 1024)}} MB
                                            </td>
                                            <!--  <td><?php echo (new DateTime())
    ->setTimestamp($b['last_modified'] / 1000)
    ->format('D, d M Y H:i:s T');
                                             ?></td> -->

                                            <td class="text-nowrap">
                                                
                                                <a href="{{route('backup.download',['file_name'=>$b['file_name']])}}" class="btn btn-primary">Download </a>&nbsp;&nbsp;

                                                <a href="{{route('backup.delete',['file_name'=>$b['file_name']])}}" class="btn btn-danger">Delete </a>
                                               
                                            </td> 
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                               
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true
        });
    });

       
    </script>
@stop