@extends('layouts.app')

@section('title')
    Approve Balloting
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-inventory')
            <li><a href="{{ route('balloting.map.inventory', $balloting_detail->map->id) }}">All Map File Inventory</a></li>
        @endpermission
        <li class="active">Approve Balloting</li>
    </ol>
@stop
@section('content')


    @php
        $size = '';
        
        if ($projectType->id == \App\ProjectType::society) {
            $size = \App\ProjectType::society_size;
        } else {
            $size = \App\ProjectType::high_rise_size;
        }
        
    @endphp

    @php
        $map = ' ';
        
        if ($projectType->id == \App\ProjectType::society) {
            $map = \App\ProjectType::society_map;
        } else {
            $map = \App\ProjectType::high_rise_map;
        }
        
    @endphp
    <div class="container-fluid">

        <!-- /row -->
        <div class="row">
            @if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">Inventory Information</h3>
                    <hr>
                    <div class="table-responsive">
                        <table class="table ">
                            <tbody>
                                <tr>
                                    <td width="360"><b>Unit/Plot Number</b></td>
                                    <td> <span style="font-size:18px;"> {{ $inventory->unit_number }} </span>



                                        @foreach ($inventory->oldNames as $o)
                                            @if ($loop->first)
                                                <br>
                                                <b style="font-size:12px;">Old Numbers : </b>
                                                <ul>
                                            @endif
                                            <li>

                                                {{ $o->name }} </li>
                                        @endforeach
                                        </ul>

                                    </td>
                                </tr>

                                <tr>
                                    <td><b>{{ $map }}</b></td>
                                    <td>
                                        {{ $inventory->floor ? $inventory->floor->name : '' }}
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Block</b></td>
                                    <td>{{ $inventory->floor ? $inventory->floor->unitBlock->name : '' }}</td>
                                </tr>


                                <tr>
                                    <td><b>Type</b></td>
                                    <td>{{ $inventory->type ? $inventory->type->name : '' }}</td>
                                </tr>
                                <tr>
                                    <td><b>Size</b></td>

                                    <td>{{ $inventory->size ? $inventory->size->name : '' }} {{ $size }}

                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Area</b></td>
                                    <td>
                                        {{ $inventory->area }} </td>
                                </tr>
                                <tr>
                                    <td><b>Total amount</b></td>
                                    <td> {{ number_format($inventory->total_price - $inventory->extra_amount) }}</td>
                                </tr>
                                <tr>
                                    <td><b>Category</b></td>
                                    <?php $sum = 0; ?>
                                    <td>
                                        @foreach ($inventory->categories as $c)
                                            <?php $sum += $c->category->percent; ?>
                                            @if ($loop->last)
                                                {{ $c->category->name }}
                                                @if ($c->category->is_percent)
                                                    ({{ $c->category->percent }} %)
                                                @else
                                                    ({{ $c->category->percent }} )
                                                @endif
                                            @else
                                                {{ $c->category->name }} @if ($c->category->is_percent)
                                                    ({{ $c->category->percent }} %)
                                                @else
                                                    ({{ $c->category->percent }} )
                                                @endif,
                                            @endif
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td><b>Extra Charges</b></td>
                                    <td>{{ number_format($inventory->extra_amount) }} </td>
                                </tr>
                                <tr>
                                    <td><b>Net Amount</b></td>
                                    <td> {{ number_format($inventory->total_price) }}</td>
                                </tr>


                                <tr>
                                    <td><b>Description</b></td>
                                    <td> {{ $inventory->description }}</td>
                                </tr>
                                <tr>
                                    @role('admin')
                                        <td><b>Status</b></td>
                                        @if ($inventory->status == \App\Inventory::open)
                                            <td> Open</td>
                                        @elseif($inventory->status == \App\Inventory::sold)
                                            <td>Sold</td>
                                        @elseif($inventory->status == \App\Inventory::hold_company)
                                            <td>Company Hold</td>
                                        @elseif($inventory->status == \App\Inventory::hold_client)
                                            <td>Client Hold</td>
                                        @elseif($inventory->status == \App\Inventory::token_hold)
                                            <td>Token Hold</td>
                                        @elseif($inventory->status == \App\Inventory::temp_hold)
                                            <td>Temporary Hold</td>
                                        @elseif($inventory->status == \App\Inventory::package_open_file)
                                            <td>Open/Dealer Package File</td>
                                        @endif
                                    @else
                                        <td><b>Status</b></td>
                                        @if ($inventory->status == \App\Inventory::open)
                                            <td> Open</td>
                                        @else
                                            <td>Sold</td>
                                        @endif


                                    @endrole
                                </tr>

                                @if ($inventory->dealer_id)
                                    <tr>
                                        <td><b>Dealer</b></td>
                                        <td>
                                            @if ($inventory->dealer_id)
                                                {{ $inventory->dealer->name }}
                                            @endif
                                        </td>
                                    </tr>
                                @endif

                                @if ($inventory->token_amount)
                                    <tr>
                                        <td><b>Token Amount</b></td>
                                        <td>{{ $inventory->token_amount }}</td>
                                    </tr>
                                @endif

                                @if ($inventory->name)
                                    <tr>
                                        <td><b>Name</b></td>
                                        <td>{{ $inventory->name }}</td>
                                    </tr>
                                @endif
                                @if ($inventory->cnic)
                                    <tr>
                                        <td><b>Cnic</b></td>
                                        <td>{{ $inventory->cnic }}</td>
                                    </tr>
                                @endif
                                @if ($inventory->email)
                                    <tr>
                                        <td><b>Email</b></td>
                                        <td>{{ $inventory->email }}</td>
                                    </tr>
                                @endif
                                @if ($inventory->phone_number)
                                    <tr>
                                        <td><b>Phone Number</b></td>
                                        <td>{{ $inventory->phone_number }}</td>

                                    </tr>
                                @endif


                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            <div class="col-lg-12 col-sm-12 col-xs-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Approve Inventory For Map Position
                    </h3>


                    <hr />
                    <div class="clearfix"></div>

                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane fade active in">
                            <form method='post' action="{{route('balloting.approve.submit')}}" enctype="multipart/form-data"
                                onsubmit="return validateData(this)">
                                @csrf
                                <input type='hidden' name='add_charges' id='add_charges' value=0> 
                                <input type='hidden' name='balloting_id' id='balloting_id' value="{{$balloting_detail->id}}"> 
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Category Charges(PKR):</label>
                                        <div class="col-md-6">

                                            <input type='text' name='category_charges' id='category_charges'
                                                value="{{ $sum }}">


                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">

                                        <div class="col-md-8">

                                            <button class="btn  btn-primary" id='add_category_id' onclick="enableCustom()"
                                                type='button'>
                                                <i class="fa fa-plus"></i>&nbsp;Add Charges Into Net Amount
                                            </button>
                                            <button class="btn  btn-primary" id='remove_category_id' style="display: none;"
                                                onclick="remove()" type='button'>
                                                <i class="fa fa-plus"></i>&nbsp;Remove Charges
                                            </button>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-sm-12 col-xs-12" id="custom_payment_schedule"
                                    style="display: none;">
                                    <div class="white-box">
                                        <h3 class="box-title">Payment Scheduler</h3>
                                        <hr>



                                        {{-- 3rd row --}}

                                        <div class="col-md-1"></div>


                                        <div class="clearfix"></div>

                                        <div id="auto" style="margin-top: 2%;">
                                            <div class="clearfix"></div>
                                            <div class="clearfix"></div>
                                        </div>

                                        <!---Custom-->
                                        <div id="custom">

                                            <div class="col-md-10">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">Balloting Amount <span
                                                            style="color: red">*</span></label>
                                                    <div class="col-md-9">

                                                        <input style="display: inline-block;width: 43%;" type="date"
                                                            id='installment' class="form-control" name="custom_date[]"
                                                            placeholder="Date">

                                                        <input style="display: inline-block;width: 49%;" type="integer"
                                                            class="form-control" name="custom_amount[]"
                                                            onkeyup="customPayment()" placeholder="Amount">
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="clearfix"></div>
                                            <div class="input_fields_wrap2 col-md-10">

                                                <div class="clearfix"></div>
                                            </div>
                                            <div class="clearfix"></div>
                                            <button type="button" class="btn btn-primary add_field_button2">Add
                                                More</button>&nbsp;&nbsp;&nbsp;

                                            <div class="clearfix"></div>
                                        </div>

                                        <!-- Custom End -->

                                    </div>
                                </div>

                                <div class="clearfix"></div>

                                <div class="input_fields_wrap3">
                                    <div class="clearfix"></div>
                                    <div></div>
                                </div>
                                <button class="btn  btn-primary" id='postbutton' type='submit' style='float: right;'>
                                    <i class="fa fa-plus"></i>&nbsp;Approve
                                </button>
                            </form>
                        </div>


                    </div>
                </div>

            </div>
        </div>

        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script>
        var originalAmount = $('#category_charges').val();
        $('#category_charges').on('input', function() {
            originalAmount = $(this).val();
            customPayment();
        });

        function customPayment() {



            var cus_amount = 0;

            $("input[name='custom_amount[]']").each(function() {
                if (!this.value) {
                    cus_amount += 0;
                } else {
                    cus_amount += parseInt($(this).val());
                }

            });



            remaining_amount = originalAmount - cus_amount;


            $('#category_charges').val(Math.round(remaining_amount));

        }


        function enableCustom() {

            $('#custom_payment_schedule').show();
            $('#remove_category_id').show();
            $('#add_category_id').hide();

            $('#add_charges').val(1);
        }

        function remove() {
            $('#custom_payment_schedule').hide();
            $('#remove_category_id').hide();
            $('#add_category_id').show();
            $('#add_charges').val(0);
        }

        //custom
        $(document).ready(function() {
            var max_fields = 100; //maximum input boxes allowed
            var wrapper = $(".input_fields_wrap2"); //Fields wrapper
            var wrapper1 = $(".input_fields_wrap2"); //Fields wrapper
            var add_button = $(".add_field_button2"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e) { //on add input button click
                e.preventDefault();
                if (x < max_fields) { //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                        '<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Balloting Amount-' +
                        x +
                        '<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 43%;margin-right: 4px;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'
                    ); //add input box
                    $(".bdpk").datepicker({
                        dateFormat: "dd-mm-yy"
                    });
                }
            });

            $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
            $(wrapper1).on("click", ".remove_field", function(e) { //user click on remove text
                e.preventDefault();
                $(this).parent('div').remove();
                x--;
            })
        });


        //end custom

        function validateData(self) {

            
           value= $('#add_charges').val();
           if(value == 1){

            var valid = true;

            if($('#category_charges').val() < 0){
                valid = false;
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Category charges should not be negative!',
                       
                    })
                    return valid;
            }
            
            $('input[name="custom_amount[]"]').each(function() {
                if ($(this).val() == '') {
                    valid = false;
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Amount field is required!',
                       
                    })
                    return valid;
                }
            });
            $('input[name="custom_date[]"]').each(function() {
                if ($(this).val() == '') {
                    valid = false;
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Date field is required!',
                      
                    })
                    return valid;
                }
            });

            return valid;
        }
        return true;

        }
    </script>
@stop
