@extends('layouts.app')

@section('title')
Add New Map File 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('balloting.direct.index')}}">All Direct Balloting Map Files </a></li>
        <li class="active">Start</li>
      </ol>
@stop
@section('content')
<style>
     
 
    .flex-center {
        align-items: center;
        display: flex;
        justify-content: center;
    }

    .position-ref {
        position: relative;
    }

    .top-right {
        position: absolute;
        right: 10px;
        top: 18px;
    }

    .content {
        text-align: center;
    }

    .title {
        font-size: 84px;
    }

    .links > a {
        color: #636b6f;
        padding: 0 25px;
        font-size: 13px;
        font-weight: 600;
        letter-spacing: .1rem;
        text-decoration: none;
        text-transform: uppercase;
    }

    .m-b-md {
        margin-bottom: 30px;
    }
</style>
<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Start Direct Balloting </h3>
                             
                                
    
                             
<hr> 
<div  >
   
    
    <form  id="start_balloting">
        @csrf
       
        <input type="hidden" name='map_id'  value='{{$balloting_file->id}}'>
        <button class='btn btn-info' type="submit">Start</button>
    </form>

    
</div>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
           
            <!-- /.container-fluid -->

@stop
@section('js')
<script>
   
   $('#start_balloting').submit(function(e) {
            e.preventDefault();
             

            var form_data = $(this).serialize();
            


            

            function updateProgressBar() {

                $.ajax({
                    url: '{{ route('balloting.progress') }}',
                    success: function(data) {
                        // Update progress bar
                        $('.progress-bar').css('width', data.progress + '%').text(data.progress + '%');
                        $('#progress_val').empty();
                        $('#progress_val').text(data.progress);

                        // Check if process is complete
                        if (data.progress == 100) {

                            clearInterval(progressInterval);
                        }
                    }
                });
            }
            var progressInterval = setInterval(updateProgressBar, 2000); // Send a request every 5 seconds





            Swal.fire({
                title: 'Balloting Start',
                html: `  Importing...   <span id='progress_val'></span>%<div class="progress">
                             <div class="progress-bar" role="progressbar" style="width: {{ session('progress') }}%" aria-valuenow="{{ session('progress') }}" aria-valuemin="0" aria-valuemax="100">{{ session('progress') }}%</div>
                             </div>`,
                showConfirmButton: false,
                allowOutsideClick: false,
                allowEscapeKey: false,


            });
            //    return false;
            $('.preloader').fadeIn();







            $.ajax({
                url: "{{ route('balloting.direct.start.store.data') }}",
                type: 'POST',
                data: form_data,
                success: function(response) {

                    $('.preloader').fadeOut();

                    if (response.success) {

                        Swal.fire({
                            icon: 'success',
                            title: 'Balloting Completed Successfully',

                            confirmButtonText: 'Ok',

                        }).then((result) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                                {!! session()->forget('progress') !!}
                                window.location.href =
                                    `{{ route('balloting.direct.map.inventory', ':id') }}`.replace(
                                        ':id', response.id);
                            }
                        })
                    }
                },
                error: function(xhr, status, error) {
                    $('.preloader').fadeOut();
                    clearInterval(progressInterval);
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',

                    })
                }
            });

        });
  </script>
@stop