@extends('layouts.app')

@section('title')
Edit Map Inventory
@stop

    @section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('balloting.map.inventory',$ball_detail->balloting_map_file_id) }}">All Map File Inventory</a></li>
        
        
        <li class="active">Edit Map Inventory</li>
    </ol>
    @stop

        @section('css')

        <style type="text/css">

        </style>

        @stop

            @section('content')

            <div class="container-fluid">
                <form method="post" action="{{ route('balloting.map.inventory.update') }}" class="form-horizontal"
                    id="receipt_form">
                    {{ csrf_field() }}

                    <input  type='hidden' id='multipro_id' name='multipro_id' value="{{$multipro_id}}">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-xs-12">
                            @if($errors->any())
                                <div class="white-box">
                                    <h2>Errors</h2>
                                    <ul>
                                        {!! implode('', $errors->all('<li><span
                                                class="help-block"><strong>:message</strong></span></li>')) !!}
                                    </ul>
                                </div>
                            @endif
                            <div class="white-box1">
                                <h3 class="box-title">Edit Map Inventory</h3>
                                <hr>

<input type='hidden' name='id' value='{{$ball_detail->id}}' >
                                
                                <div class="col-md-6">
                                     <div class="form-group">
                                         <label for="exampleInputuname" class="control-label col-md-4">Plot No
                                             <span style="color: red">*</span>
                                         </label>
                                         <div class="col-md-8">
                                             <div class="input-group">
                                                 <input type="text" class="form-control" 
                                                     value="{{$ball_detail->plot_no}}"
                                                     >
                                                 
                                             </div>
                                         </div>
                                     </div>
                                     
                                    <div class="form-group">


                                        <label class="control-label col-md-4">Select Customer Property<span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select class='js-example-basic-single' name="customer_property" id='customer_property'
                                                class="form-control "
                                                 >
                                                 <option value='' select=''> None</option>
                                                 @if(!empty($ball_detail->customer_property_id))

                                                 <option value="{{$ball_detail->customer_property_id}}" selected>{{$ball_detail->customerProperty->customer->name}} --- {{$ball_detail->customerProperty->inventory->unit_number}}</option>
                                             
                                                     @endif
                                                     
                                               
                                            </select>

                                            @if($errors->has('customer_property'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('customer_property') }}</strong>
                                                </span>
                                            @endif

                                        </div>

                                        <br><br><br><br>
                                       
                                    </div>

                                   
                                </div>
                                <div class="clearfix"></div>

                                <div class="col-md-12" id='property'> </div>

                                <div class="clearfix"></div>
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                    <button type="submit" class="btn btn-info waves-effect waves-light m-t-10"
                                        style="width: 100%">Save</button>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            </form>
            </div>

            @stop

                @section('js')
                <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
                <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
                <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js">
                </script>

                <script>
                      var multi_value= $('#multipro_id').val();
                        $('.js-example-basic-single').select2({
                            width: '250px',
                            placeholder: 'Search Unit Number...',
                            ajax: {
 url: '{{route("balloting.get.inventory")}}',
   
    dataType: 'json',
    delay: 250,
    data: function (params) {
      return {
        q: params.term, // search term
        multipro_id: multi_value
        
      };
    },
    processResults: function (data) {
    return {
        results: $.map(data, function (item) {
            return {
                id: item.id,
                text: item.text
            }
        })
    };
},
cache: true

  }
                        });

                    $(":input").inputmask();

                    function updateUnit(id) {


                        $('.preloader').fadeIn();

                        var unit_number_id = id;


                        var data = {
                            'unit_number_id': unit_number_id
                        };

                        $.get('/noc/getunitinfo', data, function (data) {

                            


                            $('#unit_floor_id').val((data.floor)?data.floor.name:'N/A');
                            $('#phase').val((data.floor)?data.floor.unit_block.name:'N/A');
                            console.log(data.property,data.property.membership_no);
                            $('#membership_no').val((data.property.membership_no)?data.property.membership_no:0);

                            $('.preloader').fadeOut();
                        });
                    }

                    function updateProperty(id) {


                        $('.preloader').fadeIn();

                        var customer_id = id;


                        var data = {
                            'customer_id': customer_id
                        };

                        $.get('/noc/getcustomerinfo', data, function (data) {


                            $('#contact_no').val(data.mobile_number);
                            $('#father_name_parent').val(data.father_name);
                            $('#cnic').val(data.cnic);


                            var model = $('#unit_number_id');
                            model.empty();

                            model.append("<option value='' disabled selected>" +
                                '' +
                                "</option>");


                            $.each(data.properties, function (index, element) {



                                model.append("<option value='" + element.inventory.id + "'>" +
                                    element.inventory.unit_number + "</option>");

                                   
                            });
                            
                          
                            // document.getElementById('property').innerHTML = data;

                            // $('#myTable').DataTable({
                            //     "paging": false,
                            //     "ordering": false,
                            //     "info": false
                            // });
                        });

                        // $('#wait').hide();
                        $('.preloader').fadeOut();

                    }
                </script>


                @stop
                    @if($errors->any())

                        <script>
                            window.onload = function () {

                                updateProperty('{{ old("customer_id") }}');

                                var payment_method = $('#payment_method').val();
                                changeFunc(payment_method)
                            }
                        </script>
                    @endif