@extends('layouts.app')

@section('title')
    Add New Map File
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="{{ route('balloting.setting.files') }}">All Balloting Map Files </a></li>
        <li class="active">Add Map file</li>
    </ol>
@stop
@section('content')

    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">
                <div class="white-box">
                    <h3 class="box-title m-b-0">Add New Map File</h3>

                    <a href="{{ route('balloting.setting.file.format') }}" class="btn  btn-primary">
                        <i class="fa fa-download"></i>&nbsp; Download Map File Format
                    </a>


                    <hr>
                    <form class="form-horizontal" action="{{ route('balloting.setting.file.store') }}" method="post"
                        enctype="multipart/form-data">
                        {{ csrf_field() }}
                        @can('isSuperAdmin')
                        <div class="form-group"><div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Select Project<span
                                        style="color:red">*</span></label>
                                <div class="col-md-7">
                        
                                    <select id="multipro" class="form-control " name="multipro_id"
                                    onchange="updateStatus(this.value)">
                                    
                                    
                                    @foreach ($multi_projects as $pro)
                                    @php
                                 $id=   Crypt::encrypt( $pro->id );
                                    @endphp
                                        @if (old('multipro_id') ==  $id)
                                            <option selected="" value="{{  $id}}">{{ $pro->name }}
                                            </option>
                                        @else
                                            <option value="{{  $id }}">{{ $pro->name }} </option>
                                        @endif
                                    @endforeach
                        
                                </select>
                                @if ($errors->has('multipro_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('multipro_id') }}</strong>
                                    </span>
                                @endif
                                </div>
                        
                        
                        
                            </div>
                        
                        </div>   
                        </div>  
                        @endcan
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group" style="width:340px">

                                    <input type="text" class="form-control" name="name" value="{{ old('name') }}"
                                        id="exampleInputuname" placeholder="Name" required>
                                    @if ($errors->has('name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="excelmapfile" class="col-sm-2 control-label">Excel Map File<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-10">
                                <div class="input-group" style="width:340px">

                                    <input type="file" class="form-control" name="mapfile" required>
                                    @if ($errors->has('mapfile'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mapfile') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label"> Description </label>
                            <div class="col-sm-10">
                                <div class="input-group" style="width:340px">

                                    <textarea type="text" class="form-control" name="description" value="{{ old('description') }}" id="exampleInputuname"
                                        placeholder="Description"></textarea>
                                    @if ($errors->has('description'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('description') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="form-group m-b-0">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100px;">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!--./row-->
    </div>
    <!-- /.container-fluid -->

@stop
