@extends('layouts.app')

@section('title')
All Balloting Map Files 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Balloting Map Files</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('create-balloting')
								<a href="{{route('balloting.setting.file.add')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add Map File
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">All Balloting Map Files</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project</th>
                                            <th>Name</th>
                                             <th>Description </th>
                                            <th>Status</th>
                                           

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($balloting_files as $file)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$file->multiProject?$file->multiProject->name:'None'}}</td>
                                            <td><a href='{{route('balloting.setting.file.format.map',['id' => $file->id])}}'>{{$file->name}}</a></td>
                                            <td>{{$file->description}}</td>
                                            @if($file->status == 1)
                                            <td><span class="label label-success">Active</span></td>
                                            @else
                                            <td><span class="label label-danger">InActive</span></td>
                                            @endif
                                            <td class="text-nowrap">
                                                @if($file->publish == 0)
                                                @permission('create-balloting')
                                                <a href="{{route('balloting.publish.map',$file->id)}}" class="btn  btn-primary">
                                                    <i class="fa fa-plus-square"></i>&nbsp; Publish
                                                </a>
                                                @endpermission
                                                @else

                                                @permission('view-balloting')
                                                <a href="{{route('balloting.setting.file.view',['id' => $file->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                
                                                @endpermission
@endif
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop