@extends('layouts.app')


@section('title')
Add New Buy Back 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('buy-back-requisition')
        <li ><a href="{{route('buy.back.list.requisition')}}">All Buy Back </a></li>
        @endpermission
        <li class="active">Add Buy Back </li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        @if($errors->any())
                        <div class="white-box1"><h2>Errors</h2><ul>
                        {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul></div>
                        @endif
                        
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Buy Back Payment Form :</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" action="{{route('buy.back.payment')}}" method="post" autocomplete="off">
                            {{csrf_field()}}
                    
                               <div class="form-group">
                                <label for="address" class="col-sm-2 control-label">Buy Back Requisition <span style="color: red">*</span> </label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-world"></i></div>
                                <select class="form-control chosen-select" id="bb_requ_form" name="bb_requ_form" onchange="return getBBRequisiData(this)">
                                <option value="" selected="">None</option>
                                @foreach($buyback_payments as $bb)
                                <option value="{{$bb->id}}">{{$bb->ref_no}}</option>
                                @endforeach
                                </select>
                                @if ($errors->has('bb_requ_form'))
                                <span class="help-block">
                                <strong>{{ $errors->first('bb_requ_form') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Ref No <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" name="ref_no" id="ref_no" value="@if(old('ref_no')) {{old('ref_no')}}@else {{'REF-'.rand(100,999)}}@endif" id="exampleInputuname" placeholder="Enter mrf  no">
                                @if ($errors->has('ref_no'))
                                <span class="help-block">
                                <strong>{{ $errors->first('ref_no') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label">Date</label>
                                <div class="col-sm-4">
                                <div class="input-group" style="margin-left: 5px;">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" readonly class="form-control" name="date"  id="date" value="{{old('date')}}" >
                                @if ($errors->has('date'))
                                <span class="help-block">
                                <strong>{{ $errors->first('date') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                <div class="form-group">
                                <label for="cnic" class="col-sm-2 control-label">Party Code <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group" style="margin-left: -3px;">
                                <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                <input type="text"  class="form-control" value="@if(old('party_code')) {{old('party_code')}}@else {{rand(1000,9999)}}@endif" name="party_code" id="party_code"   placeholder="Requested By" style="width: 98%;" >
                                
                                @if ($errors->has('party_code'))
                                <span class="help-block">
                                <strong>{{ $errors->first('party_code') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                </div>
                                </div>
                             
                                

                               
                             
                                
                    

                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" readonly   id="cus_name" value="{{old('cus_name')}}" placeholder="Enter  customer name">
                                @if ($errors->has('cus_name'))
                                <span class="help-block">
                                <strong>{{ $errors->first('cus_name') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                 
                                <div class="form-group">
                                <label for="exampleInputuname" class="col-sm-2 control-label"> Unit Number <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-user"></i></div>
                                <input  type="text" class="form-control" readonly   id="inventory_id" value="{{old('inventory_id')}}" placeholder="Enter  customer name">
                                @if ($errors->has('inventory_id'))
                                <span class="help-block">
                                <strong>{{ $errors->first('inventory_id') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                            
                                </div>
                                
                                
                               
                                

                                
                                
                        
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Floor <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="ti-email"></i></div>
                                <input type="text"  class="form-control" readonly  value="{{old('floor')}}" id="floor" placeholder="Enter floor">
                                @if ($errors->has('floor'))
                                <span class="help-block">
                                <strong>{{ $errors->first('floor') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Area </label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control" readonly type='text'  value="{{old('area')}}" id="area"  placeholder="Enter area">
                                @if ($errors->has('area'))
                                <span class="help-block">
                                <strong>{{ $errors->first('area') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                                </div>
                                
                               
                                
                               
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount invested <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="total_amount_invested" name="total_amount_invested" value="{{old('total_amount_invested')}}"  placeholder="Enter total amount invested">
                                @if ($errors->has('total_amount_invested'))
                                <span class="help-block">
                                <strong>{{ $errors->first('total_amount_invested') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount Received <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="total_amount_received" name="total_amount_received" value="{{old('total_amount_received')}}"  placeholder="Enter total amount received">
                                @if ($errors->has('total_amount_received'))
                                <span class="help-block">
                                <strong>{{ $errors->first('total_amount_received') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">If merging then value of merging <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="if_merging_then_value_of_merging" name="if_merging_then_value_of_merging" value="{{old('if_merging_then_value_of_merging')}}"  placeholder="Enter if merging then value of merging">
                                @if ($errors->has('if_merging_then_value_of_merging'))
                                <span class="help-block">
                                <strong>{{ $errors->first('if_merging_then_value_of_merging') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Buy Back Option <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="buy_back_option" name="buy_back_option" value="{{old('buy_back_option')}}"  placeholder="Enter buy back option">
                                @if ($errors->has('buy_back_option'))
                                <span class="help-block">
                                <strong>{{ $errors->first('buy_back_option') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                                
                                
                             
                                
                                
                                
                                 <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Payment Method <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text'  readonly value="{{old('payment_mode')}}" id="payment_mode"  placeholder="Enter buy back option">
                                @if ($errors->has('payment_mode'))
                                <span class="help-block">
                                <strong>{{ $errors->first('payment_mode') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">buy back value requested by client <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="buy_back_value_requested_by_client" name="buy_back_value_requested_by_client" value="{{old('buy_back_value_requested_by_client')}}"  placeholder="Enter buy back value requested by client">
                                @if ($errors->has('buy_back_value_requested_by_client'))
                                <span class="help-block">
                                <strong>{{ $errors->first('buy_back_value_requested_by_client') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                                
                                
                                <div class="form-group"  id='bank' style="display: none;">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Depositor Bank Name <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text'  readonly value="" id="bank_name"  >
                                @if ($errors->has('bank_name'))
                                <span class="help-block">
                                <strong>{{ $errors->first('bank_name') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                
                               
                                
                                
                              <div class="form-group" id='company-bank' style="display: none;">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Company Account <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text'  readonly value="" id="company_account"  >
                                @if ($errors->has('company_account'))
                                <span class="help-block">
                                <strong>{{ $errors->first('company_account') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>

                   
                        
                                <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                                <div class="form-group">
                                <label class="control-label col-md-4"> Drawn Date <span style="color:red;">*</span></label>
                                <div class="col-md-8">
                                <input type="text" class="form-control" readonly id="drawn_date" placeholder="Enter Receipt Date" > 
                                @if ($errors->has('drawn_date')) 
                                <span class="help-block">
                                <strong>{{ $errors->first('drawn_date') }}</strong>
                                </span> 
                                @endif 
                                </div>
                                </div>
                                </div>

                                <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                                <div class="form-group">
                                <label class="control-label col-md-4"> Instrument No <span style="color:red;">*</span></label>
                                <div class="col-md-8">
                                <input type="text"  readonly class="form-control" id="cheque_number" placeholder="Enter Instrument Number"> 
                                @if ($errors->has('cheque_number')) 
                                <span class="help-block">
                                <strong>{{ $errors->first('cheque_number') }}</strong>
                                </span> 
                                @endif
                                </div>
                                </div>
                                </div>
                    
                    
                                
                               
                                
                                
                                
                            
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Sales Agents <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="sales_agents" name="sales_agents" value="{{old('sales_agents')}}"  placeholder="Enter sales agents">
                                @if ($errors->has('sales_agents'))
                                <span class="help-block">
                                <strong>{{ $errors->first('sales_agents') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Total Amount  <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="total_amount" name="total_amount" value="{{old('total_amount')}}"  placeholder="Enter total amount">
                                @if ($errors->has('total_amount'))
                                <span class="help-block">
                                <strong>{{ $errors->first('total_amount') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                                
                                
                               
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Payee Name <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="payee_name" name="payee_name" value="{{old('payee_name')}}"  placeholder="Enter payee name">
                                @if ($errors->has('payee_name'))
                                <span class="help-block">
                                <strong>{{ $errors->first('payee_name') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Payee Cnic <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="payee_cnic" name="payee_cnic" value="{{old('payee_cnic')}}"  placeholder="Enter payee cnic">
                                @if ($errors->has('payee_cnic'))
                                <span class="help-block">
                                <strong>{{ $errors->first('payee_cnic') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                </div>
                                </div>
                                
                            
                                
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Payee Address <span style="color:red;">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-phone"></i></div>
                                <input type="text" class="form-control"  type='text' id="payee_address" name="payee_address" value="{{old('payee_address')}}"  placeholder="Enter payee address">
                                @if ($errors->has('payee_address'))
                                <span class="help-block">
                                <strong>{{ $errors->first('payee_address') }}</strong>
                                </span>
                                @endif</div>
                                </div>
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label"> Terms & Conditions  </label>
                                <div class="col-sm-4">
                              
                                <textarea class="form-control" name="term_and_conditions" id="term_and_conditions" rows="4" style="width: 408px; height: 36px;">{{old('term_and_conditions')}} </textarea>
                             
                                </div>
                                </div>
                                </div>
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">ROI Terms  </label>
                                <div class="col-sm-4">
                              
                                <textarea class="form-control" name="roi_terms" id="roi_terms" rows="4">{{old('roi_terms')}} </textarea>
                             
                                </div>
                                </div>
       
                                
                                <div class="form-group">
                                <label for="exampleInputEmail1" class="col-sm-2 control-label">Merging sold:   <span style="color:red;">*</span></label>
                                <div class="col-sm-5">
                                
                                <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;"> Yes : </span><input type="radio" class="form-control"   name="merging_sold" id="merging_sold_yes" value="yes" style="width: 20px; margin-left: 50%;" >
                                
                                </div>
                                
                                <div class="col-sm-5">
                                
                                <span  style="position: relative;top: 3rem;left: 10rem;font-size: 16px;font-weight: 800;">  No:  </span><input type="radio" class="form-control"   name="merging_sold" id="merging_sold_no" value="no"  style="width: 20px; margin-left: 50%;" >
                            
                                </div>
                                
                                @if ($errors->has('merging_sold'))
                                <span class="help-block">
                                <strong>{{ $errors->first('merging_sold') }}</strong>
                                </span>
                                @endif
                                
                                </div>


                            
                                <div class=" col-sm-4">&nbsp;</div>
                                <div class=" col-sm-4">
                                <div class="form-group">
                                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                </div>
                                </div>
                                
                                
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
    function getBBRequisiData(self)
    {
        var bb_id = $(self).val();
        
        $.ajax({
        url:"{{ route('getBBRequisiData') }}",
        method:'GET',
        dataType:'json',
        data: {bb_id:bb_id},
        success:function(data)
        {
            if(data.output != '')
            {
                $('#ref_no').val(data.output.ref_no); 
                $('#date').val(data.output.date);  
                $('#party_code').val(data.output.party_code); 
                $('#cus_name').val(data.output.inventory.property.customer.name); 
                $('#inventory_id').val(data.output.inventory.unit_number);  
                $('#floor').val(data.output.inventory.floor.name); 
                $('#area').val(data.output.inventory.area);
                $('#total_amount_invested').val(data.output.total_amount_invested); 
                $('#total_amount_received').val(data.output.total_amount_received);  
                $('#if_merging_then_value_of_merging').val(data.output.if_merging_then_value_of_merging); 
                $('#roi_terms').val(data.output.roi_terms);
                
                if(data.output.payment_mode == {{\App\Receipt::cash}})
                {
                    $('#payment_mode').val('Cash');
                }
                else if(data.output.payment_mode == {{\App\Receipt::bank}})
                {
                     $('#payment_mode').val('Bank');
                }
                else if(data.output.payment_mode == {{\App\Receipt::cheque}})
                {
                     $('#payment_mode').val('Cheque');
                }
                
                $('#buy_back_value_requested_by_client').val(data.output.buy_back_value_requested_by_client);         
                $('#buy_back_option').val(data.output.buy_back_option);       
                $('#sales_agents').val(data.output.sales_agents); 
                
                if(data.output.payment_mode == {{\App\Receipt::cheque}} || data.output.payment_mode == {{\App\Receipt::bank}})
                {
                    
                    $('#drawn_date').val(data.output.drawn_date)
                    $('#cheque_number').val(data.output.cheque_number)
                    
                    $('#cheque-dd-po-instrument-no').show()
                    $('#bank').show()
                    $('#company-bank').show()
                    $('#cheque-dd-po-drawn-date').show()
                    
                    $('#bank_name').val(data.depositer_bank)
                    $('#company_account').val(data.company_bank)
                   
                }
                
                 if(data.output.merging_sold == 'yes' )
                {
                   $("#merging_sold_yes").prop("checked", true);
                }
                else
                {
                     $('#merging_sold_no').prop("checked", true);
                }
                
            }
            else
            {
                $('#ref_no').val(''); 
                $('#date').val('');  
                $('#party_code').val(''); 
                $('#cus_name').val(''); 
                $('#inventory_id').val('');  
                $('#floor').val(''); 
                $('#area').val('');
            }
        }
        })
        
        return false;
    }
      function changeFunc(a)
      {
            if(a == {{\App\Receipt::cash}})
            {
              $('#bank').css('display', 'none');
              $('#company-bank').css('display', 'none');
              $('#cheque').css('display', 'none');
              $('#cheque-dd-po-drawn-date').css('display', 'none');
              $('#cheque-dd-po-instrument-no').css('display', 'none');
            }
            else if(a == {{\App\Receipt::bank}})
            {
              $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
            }
            else if(a == {{\App\Receipt::cheque}})
            {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
            }
  }
  
    
  

         function validateCnic(self) 
        {
           var cnic = $(self).val().replaceAll('-', '');

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();
$('#country_id').change(function() {
    $('.preloader').fadeIn();
        var data = { 'country_id': $(this).val() };

        $.get('/getCitiesByCountry', data, function (data) {
           var model = $('#city_id');
                    model.empty();

                     model.append("<option value='' disabled selected>" + '' + "</option>");


                    $.each(data, function(index, element) {
                        model.append("<option value='"+ element.id +"'>" + element.name + "</option>");
                    });
        });
         $('.preloader').fadeOut();
    });

function percentCheckbox() {

        if($('#rebate_in_percent').prop("checked") == false) {
            document.getElementById('rebate_input').innerHTML = 'PKR';
        }
        else {
            document.getElementById('rebate_input').innerHTML = '%';
        }
    }
   </script>
@stop