@extends('layouts.app')

@section('title')
Customer Requests 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Customer Requests</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                            
                            </div>
                            <h3 class="box-title">All Customer Requests</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr #</th>
                                            <th>Customer </th>
                                            <th>Size</th>
                                            <th>Floor</th>
                                            <th>Approx. Bugdet</th>
                                            <th>Description</th>
                                            <th>Created Date</th>
                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($requests as $r)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td><a target="_black" href="{{route('customer.detail',['id'=>$r->customer_id])}}">{{$r->customer->name}}</a></td>
                                            <td>{{$r->size}}</td>
                                            <td>{{$r->floor}}</td>
                                            <td>{{$r->approx_bugdet}}</td>
                                            <td>{{$r->description}}</td>
                                            <td>{{date('d-m-Y', strtotime($r->created_at)) }}</td>
                                           <td>

                                                <a href="#" onclick="openSmsModal({{$r->customer_id}})" ><i class="fa fa-comment"></i></a>
                                           </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

            </div>

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            "paging":true,
            'info':true,
            'pageLength':100
        });
    });

    function openSmsModal(customer_id) {

        var data={'customer_id':customer_id};
        $.get('/update_sms_modal/customer', data, function (data) {
            document.getElementById('exampleModal').innerHTML = data;
            $('#exampleModal').modal();
        });
    }
       
    
    </script>
@stop