@extends('layouts.app')

@section('title')
    Add New Customer
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-customer')
            <li><a href="{{ route('customer.all') }}">Customers</a></li>
        @endpermission
        <li class="active">Add Customer</li>
    </ol>
@stop

@section('content')

    <div class="container-fluid">
        <!--.row-->
        <div class="row">

            <div class="col-md-12">

                @if ($errors->any())
                    <div class="white-box">
                        <h2>Errors</h2>
                        <ul>
                            {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                        </ul>
                    </div>
                @endif

                <div class="white-box">
                    <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>Add Customer</h3>
                    <p class="text-muted m-b-30 font-13">Add Customer Information </p>
                    <form class="form-horizontal" action="{{ route('customer.insert') }}" enctype="multipart/form-data"
                        method="post">
                        {{ csrf_field() }}

                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Type<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">

                                        <label style="font-weight: bold;"> Individual </label>
                                        <input type="radio" <?= old('type') != 1 ? 'checked' : '' ?>
                                            onchange="return hideFields('individual')" style="margin-left: 1rem;"
                                            name="type" value="0">

                                    </div>

                                    <div class="col-sm-6">

                                        <label style="font-weight: bold;"> Company </label>
                                        <input type="radio" <?= old('type') == 1 ? 'checked' : '' ?>
                                            onchange="return hideFields('company')" style="margin-left: 1rem;"
                                            name="type" value="1">

                                    </div>

                                </div>


                                @if ($errors->has('type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                @endif

                            </div>

                        </div>


                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Name of Applicant <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="name" value="{{ old('name') }}"
                                        placeholder="Enter Name">
                                    @if ($errors->has('name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="form-group" style="display: <?= old('type') == 1 ? 'none' : '' ?>"
                            id="father_name_parent">

                            <label for="exampleInputuname" class="col-sm-3 control-label">S/O, D/O, W/O.<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="father_name" id="father_name"
                                        value="{{ old('father_name') }}" placeholder="">
                                    @if (old('father_type') == 1)
                                        <input checked="" type="radio" name="father_type" value="1">S/O
                                        <input type="radio" name="father_type" value="2">D/O
                                        <input type="radio" name="father_type" value="3"> W/O
                                    @elseif(old('father_type') == 2)
                                        <input type="radio" name="father_type" value="1">S/O
                                        <input checked="" type="radio" name="father_type" value="2">D/O
                                        <input type="radio" name="father_type" value="3"> W/O
                                    @elseif(old('father_type') == 3)
                                        <input type="radio" name="father_type" value="1">S/O
                                        <input type="radio" name="father_type" value="2">D/O
                                        <input checked="" type="radio" name="father_type" value="3"> W/O
                                    @else
                                        <input type="radio" name="father_type" value="1">S/O
                                        <input type="radio" name="father_type" value="2">D/O
                                        <input type="radio" name="father_type" value="3"> W/O
                                    @endif
                                    @if ($errors->has('father_name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('father_name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="cnic" id="cnic_no"
                                class="col-sm-3 control-label"><?= old('type') == 1 ? 'Incorporation no' : 'CNIC' ?> <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">

                                    <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                    <input type="text" class="form-control" value="{{ old('cnic') }}"
                                        name="cnic" id="cnic" data-inputmask="'mask': '9999999999999'"
                                        onfocusout="return validateCnic(this)" placeholder="XXXXXXXXXXXXX">
                                    @if (old('cnic_flag') == \App\Customer::locally)
                                        <input type="radio" checked="" name="cnic_flag" value="1"> Locally
                                        <input type="radio" name="cnic_flag" value="2"> Internationally
                                    @elseif(old('cnic_flag') == \App\Customer::internationally)
                                        <input type="radio" name="cnic_flag" value="1"> Locally
                                        <input type="radio" checked="" name="cnic_flag" value="2">
                                        Internationally
                                    @else
                                        <input type="radio" name="cnic_flag" value="1"> Locally
                                        <input type="radio" name="cnic_flag" value="2"> Internationally
                                    @endif

                                    <div style="color: red;display: none;" id="cnic_error1">This Member cnic is found in
                                        list of DNFBP. You can't add this customer record. </div>

                                    @if ($errors->has('cnic'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('cnic') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="passport_no" style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                            <label for="cnic" class="col-sm-3 control-label">Passport No.</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-book-open"></i></div>
                                    <input type="text" class="form-control" value="{{ old('passport_no') }}"
                                        name="passport_no" id="passport_no" placeholder="XXXXXXXXX">

                                    @if ($errors->has('passport_no'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('passport_no') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="cnic" class="col-sm-3 control-label" id="date_of_birth">
                                <?= old('type') == 1 ? 'Date of Incorporation' : 'Date of Birth' ?> </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-calender"></i></div>
                                    <input type="date" class="form-control" value="{{ old('dob') }}"
                                        max="{{ date('Y-m-d') }}" name="dob" id="dob">

                                    @if ($errors->has('dob'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('dob') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="cnic" class="col-sm-3 control-label" id="occupations">
                                <?= old('type') == 1 ? 'Type Of Company' : 'Occupation' ?></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-briefcase"></i></div>
                                    <input type="text" class="form-control" value="{{ old('occupation') }}"
                                        name="occupation" id="occupation">

                                    @if ($errors->has('occupation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('occupation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="mail_address">
                            <label for="address" class="col-sm-3 control-label" id="mailing_label">
                                <?= old('type') == 1 ? 'Company Registered Address' : 'Mailing Address' ?><span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <textarea class="form-control" id="mailing_address" name="mailing_address">{{ old('mailing_address') }}</textarea>
                                    @if ($errors->has('mailing_address'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mailing_address') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group" id="permanent_add"
                            style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                            <label for="address" class="col-sm-3 control-label">Permanent Address <span
                                    style="color: red">*</span></label> &nbsp; &nbsp;&nbsp;same as above <input
                                type="checkbox" id="copy_to_permanent_address" name="copy_to_permanent_address">
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <textarea class="form-control" id="permanent_address" name="permanent_address">{{ old('permanent_address') }}</textarea>
                                    @if ($errors->has('permanent_address'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('permanent_address') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Email </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-email"></i></div>
                                    <input type="email" class="form-control" name="email"
                                        value="{{ old('email') }}" placeholder="Enter email">
                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Password </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class=" icon-key"></i></div>
                                    <input type="text" class="form-control" name="password" value=""
                                        placeholder="Enter password">
                                    @if ($errors->has('password'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" id="mobile_number"
                                class="col-sm-3 control-label"><?= old('type') == 1 ? 'Mobile Number' : 'Phone Number' ?>
                                <span style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input class="form-control"
                                        oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);"
                                        type="number" maxlength="11" name="mobile_number"
                                        value="{{ old('mobile_number') }}" placeholder="Enter Mobile Number">

                                    @if ($errors->has('mobile_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mobile_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="phone_number" style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Phone Number </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input class="form-control" type='number' name="phone_number"
                                        value="{{ old('phone_number') }}" placeholder="Enter Phone Number">

                                    @if ($errors->has('phone_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('phone_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="res_number" style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Residential Number</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input class="form-control" type='number' name="res_number"
                                        value="{{ old('res_number') }}" placeholder="Enter Res. Number">

                                    @if ($errors->has('re_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('res_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputEmail1" id="imgs_label" class="col-sm-3 control-label">
                                <?= old('type') == 1 ? 'Certificate' : 'Passport size photo' ?></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input type="file" class="form-control" name="file"
                                        placeholder="Enter Phone Number">
                                    @if ($errors->has('file'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('file') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="photo_s" style="display: <?= old('type') == 1 ? 'none' : '' ?>">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Documents (CNIC, Passport etc)
                            </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-picture"></i></div>
                                    <input multiple="" type="file" class="form-control" name="photos[]">
                                    @if ($errors->has('document'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('document') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Is Filer </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <select class="form-control chosen-select" name="is_filer">
                                        <option value="1">YES</option>
                                        <option value="0">NO</option>
                                    </select>


                                    @if ($errors->has('is_filer'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('is_filer') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">NTN Number</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="ntn_number"
                                        value="{{ old('ntn_number') }}" placeholder="Enter NTN">
                                    @if ($errors->has('ntn_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('ntn_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                         <!-- <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">
                                Rental Desbursement </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <select class="form-control chosen-select" name="payment_method">
                                        <option <?= old('payment_method') == \App\Customer::CASH ? '' : '' ?>
                                            value="0">Cash</option>
                                        <option <?= old('payment_method') == \App\Customer::BANK ? 'selected' : '' ?>
                                            value="1">Bank</option>
                                        <option <?= old('payment_method') == \App\Customer::CHEAQUE ? 'selected' : '' ?>
                                            value="2">Cheque</option>
                                        <option
                                            <?= old('payment_method') == \App\Customer::OPEN_CHEAQUE ? 'selected' : '' ?>
                                            value="3">Open Cheque</option>
                                    </select>

                                    @if ($errors->has('payment_method'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_method') }}</strong>
                                        </span>
                                    @endif
                                </div>



                            </div>



                        </div>  -->

                        <!-- <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">
                                Fingerprint Verification </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    
                                    <div class="row" style="padding-left: 12px">
                                        <table style="width: 50; border: 0 align: center; cellpadding: 0; cellspacing: 0">
                                            <tr style="align: center">
                                                <td class="auto-style2" style="align: right; valign: top">
                                                    &nbsp;
                                                </td>
                                                <td class="style3">
                                                    <span class="download_href">

                                                        <input id="FPImage2" type="image" name="image" style="height: 96px; width: 96px" src="{{ asset('images/fingerplace.jpg') }}" onchange="fileArr.push(fileData)"> <br><br>
                                                       
                                                        <img id="FPImage1" alt="Fingerpint Image" style="height: 96px; width: 96px" name="fingerplace" src="{{ asset('images/fingerplace.jpg') }}">

                                                        
                                                        <input type="button" value="Click to Scan" onclick="captureFP()"><br>
    <div><br><button class="Btn">Convert</button>
        <div class="result"></div>
    </div>
                                                        @if ($errors->has('fingerplace'))
    <span class="help-block">
                                                                <strong>{{ $errors->first('fingerplace') }}</strong>
                                                            </span>
    @endif
                                                        <br>
                                                        <p id="result">
                                                    </span>
                                                </td>
                                            </tr>
                                            <p style="display: none">Template: <input type="text" id="temp" name="temp"></p>
                                            <p style="display: none">Encode: <input type="text" id="encode" name="encode"></p>
                                        </table>
                                    </div>
                                   
                                </div>
                            </div>
                        </div> -->



                        <!-- <hr>
                        <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Bank Details</h3>
                        <br>


                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Account title</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="account_title"
                                        value="{{ old('account_title') }}" placeholder="Enter Account Title">

                                    @if ($errors->has('account_title'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('account_title') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Depositer Bank </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <select class="form-control chosen-select" name="depositer_bank">
                                        <option value="">None</option>
                                        @foreach ($depositer_banks as $list)
                                            <option value="{{ $list->id }}">{{ $list->name }}</option>
                                        @endforeach

                                    </select>

                                    @if ($errors->has('depositer_bank'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('depositer_bank') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">IBAN Number</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="iban_number"
                                        value="{{ old('iban_number') }}" placeholder="Enter Account IBAN Number">


                                    @if ($errors->has('iban_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('iban_number') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div> -->



                        <hr>
                        <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Joint Owner's</h3>
                        <br>


                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Name 1</label>

                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="first_owner"
                                        value="{{ old('first_owner') }}" placeholder="Enter First Owner">

                                </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 2</label>

                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="second_owner"
                                        value="{{ old('second_owner') }}" placeholder="Enter Second Owner">

                                </div>
                            </div>

                        </div>



                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">First Owner Father</label>

                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="first_owner_father"
                                        value="{{ old('first_owner_father') }}" placeholder="Enter First Owner">

                                </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner Father</label>

                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="second_owner_father"
                                        value="{{ old('second_owner_father') }}" placeholder="Enter Second Owner Father">

                                </div>
                            </div>

                        </div>



                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">First Owner Cnic</label>

                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="first_owner_cnic"
                                        value="{{ old('first_owner_cnic') }}" placeholder="Enter First Owner Cnic">

                                </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner Cnic</label>

                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="second_owner_cnic"
                                        value="{{ old('second_owner_cnic') }}" placeholder="Enter Second Owner Cnic">

                                </div>
                            </div>

                        </div>


                        <hr>
                        <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Nominee Information</h3>
                        <br>
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Name of Nominee<span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="nominee_name"
                                        value="{{ old('nominee_name') }}" placeholder="Enter Name">
                                    @if ($errors->has('nominee_name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">S/O, D/O, W/O. <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-user"></i></div>
                                    <input type="text" class="form-control" name="nominee_so_do_wo"
                                        value="{{ old('nominee_so_do_wo') }}" placeholder="Enter S/O - D/O - W/O ">
                                    @if (old('nominee_father_type') == 1)
                                        <input checked="" type="radio" name="nominee_father_type"
                                            value="1">S/O
                                        <input type="radio" name="nominee_father_type" value="2">D/O
                                        <input type="radio" name="nominee_father_type" value="3"> W/O
                                    @elseif(old('nominee_father_type') == 2)
                                        <input type="radio" name="nominee_father_type" value="1">S/O
                                        <input checked="" type="radio" name="nominee_father_type"
                                            value="2">D/O
                                        <input type="radio" name="nominee_father_type" value="3"> W/O
                                    @elseif(old('nominee_father_type') == 3)
                                        <input type="radio" name="nominee_father_type" value="1">S/O
                                        <input type="radio" name="nominee_father_type" value="2">D/O
                                        <input checked="" type="radio" name="nominee_father_type" value="3">
                                        W/O
                                    @else
                                        <input type="radio" name="nominee_father_type" value="1">S/O
                                        <input type="radio" name="nominee_father_type" value="2">D/O
                                        <input type="radio" name="nominee_father_type" value="3"> W/O
                                    @endif
                                    @if ($errors->has('nominee_so_do_wo'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_so_do_wo') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="cnic" class="col-sm-3 control-label">CNIC <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">

                                    <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                    <input type="text" class="form-control" value="{{ old('nominee_cnic') }}"
                                        name="nominee_cnic" id="nominee_cnic"
                                        onfocusout="return validateCnic(this)"data-inputmask="'mask': '9999999999999'"
                                        placeholder="XXXXXXXXXXXXX">
                                    @if (old('nominee_cnic_flag') == \App\Customer::locally)
                                        <input type="radio" checked="" name="nominee_cnic_flag" value="1">
                                        Locally
                                        <input type="radio" name="nominee_cnic_flag" value="2"> Internationally
                                    @elseif(old('nominee_cnic_flag') == \App\Customer::internationally)
                                        <input type="radio" name="nominee_cnic_flag" value="1"> Locally
                                        <input type="radio" checked="" name="nominee_cnic_flag" value="2">
                                        Internationally
                                    @else
                                        <input type="radio" name="nominee_cnic_flag" value="1"> Locally
                                        <input type="radio" name="nominee_cnic_flag" value="2"> Internationally
                                    @endif

                                    <div style="color: red;display: none;" id="cnic_error1">This Member cnic is found in
                                        list of DNFBP. You can't add this Nominee record. </div>

                                    @if ($errors->has('nominee_cnic'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_cnic') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div class="form-group" id="nominee_address">
                            <label for="address" class="col-sm-3 control-label" id="nominee_address">Nominee Address
                                <span style="color: red">*</span></label> &nbsp; &nbsp;&nbsp;Same as Customer's address <input
                                type="checkbox" id="copy_to_nominee_address" name="copy_to_nominee_address"></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                    <textarea class="form-control" id="nominee_address" name="nominee_address">{{ old('nominee_address') }}</textarea>
                                    @if ($errors->has('nominee_address'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_address') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="cnic" class="col-sm-3 control-label">Passport No.</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-book-open"></i></div>
                                    <input type="text" class="form-control" value="{{ old('nominee_passport_no') }}"
                                        name="nominee_passport_no" id="nominee_passport_no" placeholder="XXXXXXXXX">

                                    @if ($errors->has('nominee_passport_no'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_passport_no') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Email </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="ti-email"></i></div>
                                    <input type="text" class="form-control" name="nominee_email"
                                        value="{{ old('nominee_email') }}" placeholder="Enter Email">
                                    @if ($errors->has('nominee_email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Mobile Number </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input type="text" class="form-control" name="nominee_mobile_number"
                                        value="{{ old('nominee_mobile_number') }}" placeholder="Enter Mobile Number">
                                    @if ($errors->has('nominee_mobile_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_mobile_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Phone Number </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input type="text" class="form-control" type='number'
                                        name="nominee_phone_number" value="{{ old('nominee_phone_number') }}"
                                        placeholder="Enter Phone Number">
                                    @if ($errors->has('nominee_phone_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_phone_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Residential Number </label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-phone"></i></div>
                                    <input class="form-control" type='number' name="nominee_res_number"
                                        value="{{ old('nominee_res_number') }}" placeholder="Enter Res Number">
                                    @if ($errors->has('nominee_res_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_res_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Relation with Applicant <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-link"></i></div>
                                    <select class="form-control chosen-select" name="nominee_relation">
                                        <option selected>Brother</option>
                                        <option selected>Father</option>
                                        <option selected>Sister</option>
                                        <option selected>Mother</option>
                                        <option selected>Friend</option>
                                        <option selected>Wife</option>
                                        <option selected>Husband</option>
                                        <option selected>Son</option>
                                        <option selected>Daughter</option>
                                        <option selected>Cousin</option>

                                    </select>
                                    @if ($errors->has('nominee_relation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_relation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <!-- <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Relation with Applicant <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-link"></i></div>
                                    <input type="text" class="form-control" name="nominee_relation"
                                        value="{{ old('nominee_relation') }}"
                                        placeholder="Enter Relation">
                                    @if($errors->has('nominee_relation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_relation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div> -->
                        </div>



                        <!-- <div>
        <input type="file" name="imagee" id="imagee" onblur="getVal()">
    </div> -->

                        <div class="form-group m-b-0">
                            <div class="col-sm-offset-11 col-sm-9">
                                <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                            </div>
                        </div>
                    </form>

                </div>

            </div>

        </div>

        <!--./row-->

    </div>

    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <!-- <script>
        let BtnEle = document.querySelector(".Btn");
        let resEle = document.querySelector(".result");
        BtnEle.addEventListener("click", () => {
            fetch("images/fingerplace.jpg")
                .then(function(response) {
                    return response.blob();
                })
                .then(function(blob) {
                    resEle.innerHTML = "blob.size = " + blob.size + "<br>";
                    resEle.innerHTML += "blob.type = " + blob.type + "<br>";
                });
        });
    </script> -->


    <!-- <script>
        // ***Here is the code for converting "image source" (url) to "Base64".***

        let url = 'images/fingerplace.jpg'
        const toDataURL = url => fetch(url)
            .then(response => response.blob())
            .then(blob => new Promise((resolve, reject) => {
                const reader = new FileReader()
                reader.onloadend = () => resolve(reader.result)
                reader.onerror = reject
                reader.readAsDataURL(blob)
            }))

        // ***Here is code for converting "Base64" to javascript "File Object".***

        function dataURLtoFile(dataurl, filename) {
            var arr = dataurl.split(','),
                mime = arr[0].match(/:(.*?);/)[1],
                bstr = atob(arr[1]),
                n = bstr.length,
                u8arr = new Uint8Array(n);
            while (n--) {
                u8arr[n] = bstr.charCodeAt(n);
            }
            return new File([u8arr], filename, {
                type: mime
            });
        }


        // *** Calling both function ***

        toDataURL(url)
            .then(dataUrl => {
                console.log('Here is Base64 Url', dataUrl)
                var fileData = dataURLtoFile(dataUrl, "imageName.jpg");
                console.log("Here is JavaScript File Object", fileData)
                fileArr.push(fileData)
            })
    </script> -->



    <script>
        function hideFields(self) {

            if (self === 'company') {
                $('#father_name').val('null');
                $('#father_name_parent').hide();
                $('#passport_no').hide()
                $('#date_of_birth').html('Date of Incorporation ')
                $('#cnic_no').html('Incorporation no <span style="color: red">*</span>')
                $('#mobile_number').html('Phone Number <span style="color: red">*</span>')
                $('#res_number').hide()
                $('#phone_number').hide()
                $('#photo_s').hide()
                $('#mailing_label').html('Company Registered Address <span style="color: red">*</span>')
                $('#permanent_address').val($('#mailing_address').val())
                $('#permanent_add').hide()
                $('#occupations').html('Type Of Company <span style="color: red">*</span>')
                $('#imgs_label').html('Certificate  ')
            }

            if (self === 'individual') {
                $('#father_name').val('');
                $('#father_name_parent').show();
                $('#passport_no').show()
                $('#date_of_birth').html('Date of Birth <span style="color: red">*</span>')
                $('#cnic_no').html('Cnic <span style="color: red">*</span>')
                $('#mobile_number').html('Mobile Number <span style="color: red">*</span>')
                $('#res_number').show()
                $('#photo_s').show()
                $('#phone_number').show()
                $('#mailing_label').html('Mailing Address <span style="color: red">*</span>')
                $('#permanent_add').show()
                $('#occupations').html('Occupation <span style="color: red">*</span>')
                $('#imgs_label').html('Passport size photo  <span style="color: red">*</span>')
            }


            return false;
        }

        function validateCnic(self) {
            var cnic = $(self).val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('validate.dnfbp.cnic') }}",
                method: 'POST',
                dataType: 'json',
                data: {
                    cnic: cnic
                },
                success: function(data) {
                    if (data.response == 'invalid') {
                        $(self).closest('.input-group').find('#cnic_error1').show();
                    }

                }
            })



            return false;
        }


        $(":input").inputmask();

        // $('input[type="checkbox"]').click(function() {
        //     if ($(this).prop("checked") == true) {
        //         $('textarea#permanent_address').val($('textarea#mailing_address').val());
        //     } else if ($(this).prop("checked") == false) {
        //         $('textarea#permanent_address').val('');
        //     }
        // });

        // $('input[type="checkbox"]').click(function() {
        //     if ($(this).prop("checked") == true) {
        //         $('textarea#permanent_address').val($('textarea#mailing_address').val());
        //         $('textarea#nominee_address').val($('textarea#mailing_address').val());
        //     } else if ($(this).prop("checked") == false) {
        //         $('textarea#permanent_address').val('');
        //         $('textarea#nominee_address').val('');
        //     }
        // });

        // Function for copying mailing address to permanent address
        $('input#copy_to_permanent_address').click(function() {
            if ($(this).prop("checked") == true) {
                $('textarea#permanent_address').val($('textarea#mailing_address').val());
            } else if ($(this).prop("checked") == false) {
                $('textarea#permanent_address').val('');
            }
        });

        // Function for copying mailing address to nominee address
        $('input#copy_to_nominee_address').click(function() {
            if ($(this).prop("checked") == true) {
                $('textarea#nominee_address').val($('textarea#mailing_address').val());
            } else if ($(this).prop("checked") == false) {
                $('textarea#nominee_address').val('');
            }
        });

    </script>

    <script>
        //    function captureFP() {
        //    CallSGIFPGetData(SuccessFunc, ErrorFunc);
        //    }

        //    This functions is called if the service sucessfully returns some data in JSON object

        //    function SuccessFunc(result) {
        //    if (result.ErrorCode == 0) {

        //    if (result != null && result.BMPBase64.length > 0) {
        //    document.getElementById("FPImage1").src = "data:image/bmp;base64," + result.BMPBase64;
        //    document.getElementById("FPImage2").src = "data:image/bmp;base64," + result.BMPBase64;
        //    console.log("data:image/bmp;base64," + result.BMPBase64); }
        //    console.log('something',result.TemplateBase64, result.WSQImage);
        //    console.log(result);


        // document.getElementById("temp").value=result.TemplateBase64;
        // document.getElementById("encode").value=result.WSQImage;



        //    var x = document.getElementById("result.TemplateBase64").value;
        //    document.getElementById("demo").value;


        //    } else {
        //    console.log(result);
        // alert("Fingerprint Capture Error Code:  " + result.ErrorCode + ".\nDescription:  " + ErrorCodeToString(result.ErrorCode) + ".");
        //    }

        //    document.getElementById("result").style.display = "none";


        //    }



        // function getVal() {
        // const val = document.querySelector('input').value;
        // console.log(val);
        // }

        //        function ErrorFunc(status) {

        //            /* 	
        //                If you reach here, user is probabaly not running the 
        //                service. Redirect the user to a page where he can download the
        //                executable and install it. 
        //            */
        //            alert("Check if SGIBIOSRV is running; Status = " + status + ":");

        //        }


        //        function CallSGIFPGetData(successCall, failCall) {
        //            // 8.16.2017 - At this time, only SSL client will be supported.
        //            var uri = "https://localhost:8443/SGIFPCapture";

        //            var xmlhttp = new XMLHttpRequest();
        //            xmlhttp.onreadystatechange = function () {
        //                if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
        //                    fpobject = JSON.parse(xmlhttp.responseText);
        //                    successCall(fpobject);
        //                } else if (xmlhttp.status == 404) {
        //                    failCall(xmlhttp.status)
        //                }
        //            }
        //            var params = "Timeout=" + "10000";
        //            params += "&Quality=" + "50";
        //            // params += "&licstr=" + encodeURIComponent(secugen_lic);
        //            params += "&licstr=" + encodeURIComponent('');
        //            params += "&templateFormat=" + "ISO";
        //            params += "&imageWSQRate=" + "0.75";
        //            console.log
        //            xmlhttp.open("POST", uri, true);
        //            xmlhttp.send(params);

        //            xmlhttp.onerror = function () {
        //                failCall(xmlhttp.statusText);
        //            }
        //        }
        //    
    </script>

@stop
