@extends('layouts.app')

@section('title')
    Customer Detail
@stop
@section('css')
    <style>
        hr {
            margin-top: 5px;
            margin-bottom: 5px;
        }
    </style>
@stop
@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-customer')
            <li><a href="{{ route('customer.all') }}">Customers</a></li>
        @endpermission
        <li class="active">Customer Detail</li>
    </ol>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row colorbox-group-widget">
            <div class="col-md-3 col-xs-12 p-0">
                <div class="col-md-12 col-xs-12">
                    <div class="white-box1">
                        <div class="user-bg">
                            <div class="overlay-box">
                                <div class="user-content">
                                    @if ($customer->img_url)
                                        <img src="{{ asset('uploads/' . $customer->img_url) }}" alt="user-img"
                                            class="thumb-lg img-circle">
                                    @else
                                        <img src="{{ asset('plugins/images/users/jeffery.png') }}" width="auto"
                                            alt="user-img" class="thumb-lg img-circle">
                                    @endif
                                    <h4 class="text-white">
                                        @php
                                            
                                            $ownerArray[] = $customer->name;
                                            
                                            if (!empty($customer->first_owner)) {
                                                $ownerArray[] = $customer->first_owner;
                                            }
                                            
                                            if (!empty($customer->second_owner)) {
                                                $ownerArray[] = $customer->second_owner;
                                            }
                                            
                                        @endphp

                                        @if (count($ownerArray) > 1)
                                            {{ 'Joint Owners' }}
                                        @else
                                            {{ $customer->name }}
                                        @endif

                                    </h4>
                                    <h5 class="text-white">{{ $customer->mobile_number }}</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-9 col-xs-12 p-0">
                <!-- <div class="col-md-3 col-sm-6 info-color-box">
                            <div class="white-box1">
                                <div class="profile-widget">
                                    <div class="profile-img">
                                        @if ($customer->img_url)
    <img src="{{ asset('uploads/' . $customer->img_url) }}" height="100px" width="auto" alt="user-img" class="img-circle">
@else
    <img src="{{ asset('plugins/images/users/jeffery.png') }}" height="100px" width="auto" alt="user-img" class="img-circle">
    @endif
                                        <p class="m-t-10 m-b-5"><h3>{{ $customer->name }}</h3> </p>
                                        
                                    </div>
                                </div>
                            </div>
                        </div> -->

                <!-- <div class="col-md-3 col-sm-6 info-color-box">
                             <div class="white-box1">
                                <div class="media bg-success">
                                    <div class="media-body"><ul>
                                        @foreach ($customer->properties as $p)
    <li><h5 class="info-count" style="font-size: 14px;">{{ $p->membership_no }}<span class="pull-right"></span></h5></li>
    @endforeach
                                    </ul>
                                        <p class="info-ot font-20"> Client ids</p>
                                    </div>

                                </div>
                            </div>
                        </div>-->

                <div class="col-md-4 col-sm-12 info-color-box">
                    <div class="white-box">
                        <div class="media bg-primary">
                            <div class="media-body">
                                <h3 class="info-count">{{ number_format($received) }}<span class="pull-right"><i
                                            class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                <p class="info-text font-12">PKR </p>
                                <p class="info-ot font-20"> Paid Amount</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12 info-color-box">
                    <div class="white-box">
                        <div class="media bg-warning">
                            <div class="media-body">
                                <h3 class="info-count">{{ number_format($dueAmount) }}<span class="pull-right"><i
                                            class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                <p class="info-text font-12">PKR </p>
                                <p class="info-ot font-20"> Due Amount</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12 info-color-box">
                    <div class="white-box">
                        <div class="media bg-info">
                            <div class="media-body">
                                <h3 class="info-count">{{ number_format($outstandingAmt) }}<span class="pull-right"><i
                                            class="mdi mdi-checkbox-marked-circle-outline"></i></span></h3>
                                <p class="info-text font-12">PKR </p>
                                <p class="info-ot font-20"> Outstanding Amt</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="col-md-6">
                            <div class="white-box ecom-stat-widget" style="padding: 2px 15px 2px 15px;">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <p class="font-12"><b>Reference #</b></p>
                                        <ol>
                                                @foreach ($customer->properties as $p)
    @if ($p->membership_no)
    <li>{{ $p->membership_no }}</li>
@else
    <li style="color: #e8e8e8"> Not Approved</li>
    @endif
    @endforeach
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div> -->
                <!-- <div class="col-md-6">
                            <div class="white-box ecom-stat-widget" style="padding: 2px 15px 2px 15px;">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <p class="font-12"><b>Invoices</b></p>
                                        <ol>
                                            @foreach ($customer->properties as $p)
    <li>{{ $p->invoice_number }}</li>
    @endforeach
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div> -->
            </div>
        </div>
    </div>
    <!-- /row -->
    <div class="row container-fluid">
        <div class="col-sm-12">
            <div class="white-box1">
                <h3 class="box-title" style="display: inline-block;">Basic Information</h3>
                @permission('edit-customer')
                    <a class="btn btn-outline btn-default waves-effect waves-light pull-right"
                        href="{{ route('customer.editView', ['id' => $customer->id]) }}"style="margin-top: 9px"> <i
                            class="fa fa-pencil m-r-5"></i> <span>Edit</span></a>
                @endpermission

                <hr>
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>



                                <td>Code </td>
                                <td>

                                    <?php $words = explode(' ', $customer->name);
                                    $acronym = '';
                                    foreach ($words as $w) {
                                        $acronym .= $w;
                                    }
                                    ?>

                                    {{ $acronym }}00{{ $customer->id }}

                                </td>
                            </tr>


                            @if (count($ownerArray) > 1)
                                <tr>
                                    <td>Names </td>
                                    <td>
                                        {{ $customer->name }}, {{ $customer->first_owner }},
                                        {{ $customer->second_owner }}
                                    </td>
                                </tr>
                            @endif


                            <tr style="display: <?= $customer->type == 1 ? 'none' : '' ?>">

                                @if ($customer->father_type == 1)
                                    <td><b>S/O,<strike> D/O, W/O.</strike></b></td>
                                @elseif($customer->father_type == 2)
                                    <td><b><strike>S/O,</strike> D/O,<strike> W/O.</strike></b></td>
                                @elseif($customer->father_type == 3)
                                    <td><b><strike>S/O, D/O,</strike> W/O.</b></td>
                                @else
                                    <td><b>S/O, D/O, W/O.</b></td>
                                @endif
                                <td>

                                    @if (count($ownerArray) > 1)
                                        {{ $customer->father_name }}, {{ $customer->first_owner_father }},
                                        {{ $customer->second_owner_father }}
                                    @else
                                        {{ $customer->father_name }}
                                    @endif

                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <b>
                                        <?= $customer->type == 1 ? 'Incorporation no' : 'CNIC' ?>

                                    </b>

                                </td>
                                <td>

                                    @if (count($ownerArray) > 1)
                                        {{ str_replace('_', '', $customer->cnic) }}, {{ $customer->first_owner_cnic }},
                                        {{ $customer->second_owner_cnic }}
                                    @else
                                        {{ str_replace('_', '', $customer->cnic) }}
                                    @endif



                                </td>
                            </tr>
                            <tr style="display: <?= $customer->type == 1 ? 'none' : '' ?>">
                                <td><b>Passport No.</b></td>
                                <td> {{ $customer->passport_no }} </td>
                            </tr>
                            <tr>
                                <td>
                                    <b>
                                        <?= $customer->type == 1 ? 'Date of Incorporation ' : 'Date of Birth' ?>

                                    </b>
                                </td>
                                <td>{{ date('d-m-Y', strtotime($customer->dob)) }} </td>
                            </tr>
                            <tr>
                                <td>
                                    <b>
                                        <?= $customer->type == 1 ? 'Type Of Company ' : 'Occupation' ?>

                                    </b>
                                </td>
                                <td> {{ $customer->occupation }} </td>
                            </tr>

                            <!-- <tr>
                                                        <td>Fingerprint</td>
                                                        <td>
                                                           @if (isset($customer->fingerplace))
    {
                                                               {{ $customer->fingerplace }}
                                                            }
@else
    <span>Not Verified</span>
    @endif
                                                        </td>
                                                    </tr> -->

                            <tr>
                                <td>
                                    <b>
                                        <?= $customer->type == 1 ? 'Company Registered Address' : 'Mailing Address' ?>

                                    </b>
                                </td>
                                <td> {{ $customer->mailing_address }} </td>
                            </tr>
                            <tr style="display: <?= $customer->type == 1 ? 'none' : '' ?>">
                                <td><b>Permanent Address</b></td>
                                <td> {{ $customer->permanent_address }} </td>
                            </tr>
                            <tr>
                                <td><b>Email</b></td>
                                <td> {{ $customer->email }} </td>
                            </tr>
                            <tr style="display: <?= $customer->type == 1 ? 'none' : '' ?>">
                                <td><b>Phone Number</b></td>
                                <td> {{ $customer->phone_number }} </td>
                            </tr>
                            <tr style="display: <?= $customer->type == 1 ? 'none' : '' ?>">
                                <td><b>Residential Number</b></td>
                                <td> {{ $customer->res_number }} </td>
                            </tr>
                            <tr>
                                <td><b>Mobile Number</b></td>
                                <td> {{ $customer->mobile_number }} </td>
                            </tr>

                            <tr>
                                <td><b>Is Filer</b></td>
                                <td> {{ $customer->is_filer ? 'YES' : 'NO' }} </td>
                            </tr>
                            <tr>
                                <td><b>NTN Number</b></td>
                                <td> {{ $customer->ntn_number }} </td>
                            </tr>

                            <tr>
                                <td><b>Updated at</b></td>
                                <td> {{ $customer->updated_at }}</td>
                            </tr>
                            <tr>
                                <td><b>Created at</b></td>
                                <td> {{ $customer->created_at }}</td>
                            </tr>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>



    <!--  <div class="row container-fluid">
                        <div class="col-sm-12">
                            <div class="white-box1">
                                <h3 class="box-title">Bank Detail</h3><hr>
                                        <div class="table-responsive col-md-12">
                                            <table class="table">
                                                <tbody>

                                                 
                                                    <tr>
                                                        <td><b>Account title</b></td>
                                                        <td> {{ $customer->account_title }} </td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>Bank</b></td>
                                                        <td> {{ $customer->depositerBank ? $customer->depositerBank->name : '' }} </td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>IBAN Number</b></td>
                                                        <td> {{ $customer->iban_number }} </td>
                                                    </tr>

                                                  

                                                </tbody>
                                            </table>
                                        </div>
                            </div>
                        </div>
                    </div> -->
    <!-- /.row -->




    <div class="row container-fluid">
        <div class="col-sm-12">
            <div class="white-box1">
                <h3 class="box-title">Joint Owner's</h3>
                <hr>
                <div class="table-responsive col-md-12">
                    <table class="table">
                        <tbody>


                            <tr>
                                <td><b>Owner 1</b></td>
                                <td> {{ $customer->first_owner }} </td>

                                <td><b>Owner Father</b></td>
                                <td> {{ $customer->first_owner_father }} </td>

                                <td><b>Owner Cnic</b></td>
                                <td> {{ $customer->first_owner_cnic }} </td>

                            </tr>


                            <tr>
                                <td><b>Owner 2</b></td>
                                <td> {{ $customer->second_owner }} </td>

                                <td><b>Owner Father</b></td>
                                <td> {{ $customer->second_owner_father }} </td>

                                <td><b>Owner Cnic</b></td>
                                <td> {{ $customer->second_owner_cnic }} </td>

                            </tr>



                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- /.row -->



    <div class="row container-fluid">
        <div class="col-sm-12">
            <div class="white-box1">
                <h3 class="box-title">Nominee Information</h3>
                <hr>
                <div class="table-responsive col-md-6">
                    <table class="table">
                        <tbody>

                            <tr>
                                <td><b>Name Of Nominee</b></td>
                                <td> {{ $customer->nominee_name }} </td>
                            </tr>
                            <tr>
                                @if ($customer->nominee_father_type == 1)
                                    <td><b>S/O,<strike> D/O, W/O.</strike></b></td>
                                @elseif($customer->nominee_father_type == 2)
                                    <td><b><strike>S/O,</strike> D/O,<strike> W/O.</strike></b></td>
                                @elseif($customer->nominee_father_type == 3)
                                    <td><b><strike>S/O, D/O,</strike> W/O.</b></td>
                                @else
                                    <td><b>S/O, D/O, W/O.</b></td>
                                @endif
                                <td> {{ $customer->nominee_so_do_wo }} </td>
                            </tr>
                            <tr>
                                <td><b>CNIC</b></td>
                                <td> {{ $customer->nominee_cnic }} </td>
                            </tr>
                            <tr>
                                <td><b>Address</b></td>
                                <td> {{ $customer->nominee_address }} </td>
                            </tr>
                            <tr>
                                <td><b>Passport No.</b></td>
                                <td> {{ $customer->nominee_passport_no }} </td>
                            </tr>

                            <tr>
                                <td><b>Email</b></td>
                                <td> {{ $customer->nominee_email }} </td>
                            </tr>

                            <tr>
                                <td><b>Phone Number</b></td>
                                <td> {{ $customer->nominee_phone_number }} </td>
                            </tr>
                            <tr>
                                <td><b>Residential Number</b></td>
                                <td> {{ $customer->nominee_res_number }} </td>
                            </tr>
                            <tr>
                                <td><b>Mobile Number</b></td>
                                <td> {{ $customer->nominee_mobile_number }} </td>
                            </tr>

                            <tr>
                                <td><b>Relation With Applicant</b></td>
                                <td> {{ $customer->nominee_relation }} </td>
                            </tr>

                        </tbody>
                    </table>
                </div>

                @if ($customer->nominee)
                    @foreach ($customer->nominee as $n)
                        <div class="table-responsive col-md-6">
                            <table class="table">
                                <tbody>


                                    <tr>
                                        <td><b>Name Of Nominee</b></td>
                                        <td> {{ $n->nominee_name }} </td>
                                    </tr>
                                    <tr>
                                        <td><b>S/O, D/O, W/O.</b></td>
                                        <td> {{ $n->nominee_so_do_wo }} </td>
                                    </tr>
                                    <tr>
                                        <td><b>CNIC</b></td>
                                        <td> {{ $n->nominee_cnic }} </td>
                                    </tr>
                                    <tr>
                                        <td><b>Passport No.</b></td>
                                        <td> {{ $n->nominee_passport_no }} </td>
                                    </tr>

                                    <tr>
                                        <td><b>Email</b></td>
                                        <td> {{ $n->nominee_email }} </td>
                                    </tr>

                                    <tr>
                                        <td><b>Phone Number</b></td>
                                        <td> {{ $n->nominee_phone_number }} </td>
                                    </tr>
                                    <tr>
                                        <td><b>Residential Number</b></td>
                                        <td> {{ $n->nominee_res_number }} </td>
                                    </tr>
                                    <tr>
                                        <td><b>Mobile Number</b></td>
                                        <td> {{ $n->nominee_mobile_number }} </td>
                                    </tr>

                                    <tr>
                                        <td><b>Relation With Applicant</b></td>
                                        <td> {{ $n->nominee_relation }} </td>
                                    </tr>





                                </tbody>
                            </table>
                        </div>
                    @endforeach
                @endif

            </div>
        </div>
    </div>
    <!-- /.row -->

    <div class="row container-fluid">
        <div class="col-sm-12">
            <div class="white-box1">
                <h3 class="box-title" style="display: inline-block;">File Bank</h3>
                <a class="btn btn-primary" onclick="$('#exampleModal').modal();"
                    style="font-size: 16px; text-decoration-line: underline; display: inline-block;float: right;"><i
                        class="fa fa-file" style="text-transform: none;">&nbsp;</i>Add New</a>
                <hr>
                <div class="table-responsive col-md-12">

                    <?php $c = 1; ?>
                    @foreach ($customer->documents as $d)
                        <div class="col-md-3">
                            <label><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ $c++ }}.</b>
                                &nbsp;&nbsp;<a onclick="openFileModal('{{ $d->id }}')"
                                    style="font-size: 12px;cursor: pointer;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i><u>Rename</u></a></label><br>

                            <a target="_blank" href="{{ asset('uploads/' . $d->url) }}">

                                @if (strpos($d->url, 'docx') !== false)
                                    <img src="{{ asset('uploads/word.png') }}" width="175" height="100" />
                                @elseif(strpos($d->url, 'pdf') !== false)
                                    </script>

                                    <iframe src="{{ asset('uploads/' . $d->url) }}" width="175" height="100" />
                                    </iframe>
                                @else
                                    <embed src="{{ asset('uploads/' . $d->url) }}" width="175" height="100" />
                                @endif






                                <br>
                                <label style="font-size: 12px; cursor: pointer;"><b>&nbsp;{{ $d->name }}</b></label>
                            </a>
                            <br>
                            @if (strpos($d->url, 'docx') !== false)
                                <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px"
                                    href="{{ asset('uploads/' . $d->url) }}"><i class="fa fa-download"
                                        style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            @else
                                <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px"
                                    href="{{ asset('uploads/' . $d->url) }}"><i class="fa fa-eye"
                                        style="text-transform: none;">&nbsp;</i>Preview</a>&nbsp;&nbsp;

                                <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px"
                                    href="{{ asset('uploads/' . $d->url) }}" download=""> <i class="fa fa-download"
                                        style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;
                            @endif
                            <a style="color:red;text-decoration: underline;font-size: 11px"
                                href="{{ route('customer.delete.document', ['id' => $d->id]) }}"data-toggle="confirmation"
                                data-title="Are you sure to delete?"><i class="fa fa-trash"
                                    style="text-transform: none;">&nbsp;</i>Delete</a>
                        </div>
                    @endforeach


                </div>

            </div>
        </div>
    </div>
    <!-- /.row -->

    <div class="row container-fluid">
        <div class="col-md-12">
            <div class="white-box1 user-table">
                <div class="row">
                    <div class="col-sm-12">
                        <h4 class="box-title">Follow up history</h4>
                        <!-- <a href="{{ route('statement.addViewCustomer', ['id' => $customer->id]) }}">Add New</a> -->
                        <hr>
                    </div>

                </div>
                <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Created at</th>
                                <th>Unit #</th>
                                <th>Remarks</th>
                                <th>Next Follow up Date</th>


                            </tr><?php $count = 1; ?>
                            @foreach ($followUps as $f)
                                <tr>
                                    <td>{{ date('d-m-Y h:i', strtotime($f->created_at)) }}</td>
                                    <td>{{ $f->property->inventory->unit_number }}</td>
                                    <td>{{ $f->remarks }}</td>

                                    <td>{{ date('d-m-Y', strtotime($f->next_follow_up)) }}</td>
                                </tr>
                            @endforeach
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row container-fluid">
        <div class="col-md-12">
            <div class="white-box1 user-table">
                <div class="row">
                    <div class="col-sm-12">
                        <h4 class="box-title"><?= $customer->type == 1 ? 'Company' : 'Customer' ?> Properties</h4>
                        <!-- <a href="{{ route('statement.addViewCustomer', ['id' => $customer->id]) }}">Add New</a> -->
                        <hr>
                    </div>

                </div>
                <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Unit #</th>
                                <th>Unit Size</th>
                                <th>Total Cost</th>
                                <th>Received Amount</th>
                                <th>Remaining Amount</th>
                                <th>Booking Date</th>
                                <th>Status</th>
                                <th>View</th>
                            </tr><?php $count = 1; ?>
                            @foreach ($customer->properties as $property)
                                <tr>
                                    <td>{{ $property->inventory->unit_number }}</td>
                                    <td>{{ $property->inventory->size ? $property->inventory->size->name : '' }}
                                        {{ env('SIZE') }}</td>

                                    <td>{{ number_format($property->net_pay) }}</td>

                                    <td>
                                        {{ number_format($property->statement->sum('received')) }}
                                    </td>

                                    <td>
                                        {{ number_format($property->net_pay - $property->statement->sum('received')) }}
                                    </td>

                                    <td> {{ date('d-m-Y', strtotime($property->booking_date)) }}</td>


                                    @if ($property->status == \App\CustomerProperty::pending)
                                        <td><span class="label label-primary"
                                                style="background-color:#cd703d;">Pending</span></td>
                                    @elseif($property->status == \App\CustomerProperty::approved)
                                        <td><span class="label label-success">Approved</span></td>
                                    @elseif($property->status == \App\CustomerProperty::cancel)
                                        <td><span class="label label-danger">Canceled</span></td>
                                    @elseif($property->status == \App\CustomerProperty::block)
                                        <td><span class="label label-danger"
                                                style="background-color:#f40909;">Blocked</span></td>
                                    @else
                                        <td></td>
                                    @endif
                                    <td>
                                        @permission('view-membership')
                                            <a target="_blank" href="{{ route('statement.detail', ['id' => $property->id]) }}"
                                                data-toggle="tooltip" data-original-title="View"> <i
                                                    class="fa fa-eye text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
                                        @endpermission

                                        @permission('download-statement')
                                            <a target="_blank" href="{{ route('customer.download', ['id' => $property->id]) }}"
                                                data-toggle="tooltip" data-original-title="Download"> <i
                                                    class="fa fa-download text-inverse m-r-10"></i> </a>
                                        @endpermission
                                    </td>
                                </tr>
                            @endforeach
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>






    <div class="row container-fluid">
        <div class="col-md-12">
            <div class="white-box1">
                <div class="row">
                    <div class="col-sm-12">
                        <h4 class="box-title" style="display: inline-block;">Transfer Properties Detail</h4>

                        <hr>
                    </div>

                </div>
                <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Unit #</th>
                                <th>Unit Size</th>
                                <th>Total Amount Paid</th>
                                <th>Transfer To</th>
                                <th>Status</th>
                                <th>Transfer Date</th>
                                <th>Detail</th>

                            </tr>


                        </thead>
                        <tbody>

                            @foreach ($transferproperty as $tr)
                                <tr>

                                    <td>
                                        {{ $tr->property ? $tr->property->inventory->unit_number : '' }}
                                    </td>
                                    <td>
                                        {{ $tr->property ? $tr->property->inventory->size->name : '' }}
                                        {{ env('SIZE') }}
                                    </td>
                                    <td>
                                        {{ $tr->amount_paid }}
                                    </td>
                                    <td>
                                        <a href='{{ route('customer.detail', $tr->transfer->id) }}'>
                                            {{ $tr->transfer->name }}
                                        </a>


                                    </td>
                                    <td>
                                        <span class="label label-success">
                                            Transfered
                                        </span>
                                    </td>
                                    <td>
                                        {{ date('d-m-Y', strtotime($tr->transfer_date)) }}
                                    </td>

                                    <td>
                                        @permission('view-membership')
                                            <a target="_blank"
                                                href="{{ route('customer.transfer.property.history', ['id' => $tr->id]) }}"
                                                data-toggle="tooltip" data-original-title="View"> <i
                                                    class="fa fa-eye text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
                                        @endpermission
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>




    <div class="row container-fluid">
        <div class="col-md-12">
            <div class="white-box1">
                <div class="row">
                    <div class="col-sm-12">
                        <h4 class="box-title" style="display: inline-block;">Transaction Records</h4>
                        @permission('create-receipt')
                            <a class="btn btn-outline btn-default waves-effect waves-light pull-right"
                                href="{{ route('receipt.addView') }}" style="margin-top: 6px;"> <i
                                    class="fa fa-plus m-r-5"></i> <span>Add new</span></a>
                        @endpermission
                        <hr>
                    </div>

                </div>
                <div class="table-responsive" style=" overflow-y: auto; max-height: 400px">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Unit # </th>
                                <th>Payment Head </th>
                                <th>Payment Mode </th>

                                <th> Amount</th>
                                <th> Status</th>
                                <th>Date</th>
                            </tr>
                            <?php $count = 1;
                            
                            $customerReceipts = json_decode(json_encode($customer->receipts), true);
                            
                            usort($customerReceipts, function ($a, $b) {
                                return preg_replace('/[^0-9.]/', '', $a['property']['inventory']['unit_number']) <=> preg_replace('/[^0-9.]/', '', $b['property']['inventory']['unit_number']);
                            });
                            
                            $customerReceipts = json_decode(json_encode($customerReceipts));
                            ?>
                            @foreach ($customerReceipts as $receipt)
                                <tr>


                                    <td>{{ $receipt->property ? $receipt->property->inventory->unit_number : 0 }}</td>

                                    @if ($receipt->payment_head == \App\Receipt::possession_fee)
                                        <td>Possession Fee</td>
                                    @elseif($receipt->payment_head == \App\Receipt::down_payment)
                                        <td>Down Payment</td>
                                    @elseif($receipt->payment_head == \App\Receipt::installment)
                                        <td>Installment</td>
                                    @elseif($receipt->payment_head == \App\Receipt::other)
                                        <td>Other</td>
                                    @elseif($receipt->payment_head == \App\Receipt::transfer_fee)
                                        <td>Transfer Fee</td>
                                    @else
                                        <td></td>
                                    @endif

                                    @if ($receipt->payment_mode == \App\Receipt::cash)
                                        <td>Cash</td>
                                    @elseif($receipt->payment_mode == \App\Receipt::bank)
                                        <td>Bank transfer</td>
                                    @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                        <td>Cheque</td>
                                        @else
                                        <td></td>
                                    @endif


                                    <td>{{ number_format($receipt->amount) }} PKR</td>


                                    @if ($receipt->property->status == \App\CustomerProperty::cancel)
                                        <td>
                                            <span class="label label-danger">Canceled</span>
                                        </td>
                                    @else
                                        @if ($receipt->is_approved == \App\Receipt::approve)
                                            <td>
                                                <span class="label label-success">
                                                    Approved
                                                </span>
                                            </td>
                                        @else
                                            @if ($receipt->cheaque_status == \App\Receipt::cancel)
                                                <td>
                                                    <span class="label label-danger">
                                                        Cheaque Cancel
                                                    </span>
                                                </td>
                                            @else
                                                <td>
                                                    <span class="label label-warning">
                                                        Pending
                                                    </span>
                                                </td>
                                            @endif
                                        @endif
                                    @endif

                                    <td> {{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                </tr>
                            @endforeach
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>











    </div>
    <!-- /.container-fluid -->

    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="text-align: center;">
                    <h5 class="modal-title" id="exampleModalLabel">New File</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="{{ route('customer.document.upload') }}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body" style="height: 250px;">
                        <input type="hidden" name="customer_id" value="{{ $customer->id }}">

                        <div class="form-group form-group-sm">
                            <div class="col-xs-4">
                                <label>File Name</label>
                            </div>
                            <div class="col-xs-8">
                                <input type="text" name="name" placeholder="Enter Name" class="form-control">
                            </div>
                        </div>
                        <div class="form-group form-group-sm">
                            <div class="col-xs-4">
                                <label>File</label>
                            </div>
                            <div class="col-xs-8">
                                <input type="file" name="file" class="form-control">
                            </div>
                        </div>
                        <br>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Upload</button>
                    </div>
                </form>
            </div>
        </div>

    </div>

    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">

    </div>

@stop

@section('js')

    <script type="text/javascript">
        function openFileModal(file_id) {

            var data = {
                'document_id': file_id
            };
            $.get('/update_document_name', data, function(data) {
                document.getElementById('exampleModal1').innerHTML = data;
                $('#exampleModal1').modal();
            });
        }
    </script>



@stop
