@extends( 'layouts.app')

@section('title')
Edit Customer 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-customer')
        <li ><a href="{{route('customer.all')}}">Customers</a></li>
        @endpermission
        <li class="active">Edit Customer</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">

                         @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif

                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>Edit Customer</h3>
                            <p class="text-muted m-b-30 font-13"> Update Customer Information </p>
                            <form class="form-horizontal" action="{{route('customer.update')}}" enctype="multipart/form-data" method="post">
                               {{csrf_field()}}
                               
                               <input type="hidden" name="id" value="{{$customer->id}}">
                               <input type="hidden" name="type" value="{{$customer->type}}">
                               
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Name of Applicant <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="name" value="{{$customer->name}}" placeholder="Enter Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">S/O, D/O, W/O.<span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="father_name" value="{{$customer->father_name}}" placeholder="">
                                            @if($customer->father_type == 1)
                                            <input checked="" type="radio" name="father_type" value="1">S/O
                                            <input  type="radio" name="father_type" value="2">D/O
                                            <input type="radio" name="father_type" value="3"> W/O
                                            @elseif($customer->father_type == 2)
                                            <input type="radio" name="father_type" value="1">S/O
                                            <input checked="" type="radio" name="father_type" value="2">D/O
                                            <input type="radio" name="father_type" value="3"> W/O

                                            @elseif($customer->father_type == 3)
                                            <input type="radio" name="father_type" value="1">S/O
                                            <input type="radio" name="father_type" value="2">D/O
                                            <input checked="" type="radio" name="father_type" value="3"> W/O
                                            @else
                                            <input type="radio" name="father_type" value="1">S/O
                                            <input type="radio" name="father_type" value="2">D/O
                                            <input type="radio" name="father_type" value="3"> W/O
                                            @endif
                                        @if ($errors->has('father_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('father_name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                </div>
                            
                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label"><?= ( $customer->type == 1) ? 'Incorporation no' : 'CNIC' ?> <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" value="{{$customer->cnic}}" name="cnic" id="cnic" data-inputmask="'mask': '9999999999999'" onfocusout="return validateCnic(this)"  placeholder="XXXXXXXXXXXXX"  >
                                            @if($customer->cnic_flag == \App\Customer::locally)
                                            <input type="radio" checked="" name="cnic_flag" value="1"> Locally
                                            <input type="radio" name="cnic_flag" value="2"> Internationally
                                            @elseif($customer->cnic_flag == \App\Customer::internationally)
                                            <input type="radio" name="cnic_flag" value="1"> Locally
                                            <input type="radio" checked="" name="cnic_flag" value="2"> Internationally
                                            @else
                                            <input type="radio" name="cnic_flag" value="1"> Locally
                                            <input type="radio"  name="cnic_flag" value="2"> Internationally

                                            @endif

                                            <div style="color: red;display: none;" id="cnic_error1">This Member cnic is found in list of DNFBP. You can't add this customer record. </div>

                                        @if ($errors->has('cnic'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('cnic') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="cnic" class="col-sm-2 control-label">Passport No.</label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-book-open"></i></div>
                                            <input type="text"  class="form-control" value="{{$customer->passport_no}}" name="passport_no" id="passport_no" placeholder="XXXXXXXXX"  >

                                        @if ($errors->has('passport_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('passport_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>
                              

                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label"><?= ( $customer->type == 1) ? 'Date of Incorporation' : 'Date of Birth' ?>  </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-calender"></i></div>
                                            <input type="date"  class="form-control" value="{{$customer->dob}}" max="{{date('Y-m-d')}}" name="dob" id="dob" >

                                        @if ($errors->has('dob'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('dob') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label"><?= ( $customer->type == 1) ? 'Type Of Company' : 'Occupation' ?></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-briefcase"></i></div>
                                            <input type="text"  class="form-control" value="{{$customer->occupation}}" name="occupation" id="occupation">

                                        @if ($errors->has('occupation'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('occupation') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>

                              

                                <div class="form-group">
                                    <label for="address" class="col-sm-2 control-label"><?= ( $customer->type == 1) ? 'Company Registered Address' : 'Mailing Address' ?> <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <textarea class="form-control" id="mailing_address" name="mailing_address" >{{$customer->mailing_address}}</textarea>
                                        @if ($errors->has('mailing_address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mailing_address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="address" class="col-sm-2 control-label">Permanent Address <span style="color: red">*</span></label> &nbsp; &nbsp;&nbsp;same as above <input type="checkbox" id="same_address" name="same_address">
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                            <textarea class="form-control" id="permanent_address" name="permanent_address">{{$customer->permanent_address}}</textarea>
                                        @if ($errors->has('permanent_address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('permanent_address') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>
                                
                                 <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Email </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="email"  class="form-control" name="email" value="{{$customer->email}}" placeholder="Enter email">
                                        @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-2 control-label">Password </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-key"></i></div>
                                            <input type="text"  class="form-control" name="password" value="" placeholder="Enter password">
                                        @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                </div>

                             
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">
                                        <?= ($customer->type == 1) ? 'Mobile Number' : 'Phone Number' ?> <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" type = "number"  maxlength = "11" class="form-control" name="mobile_number" value="{{$customer->mobile_number}}"  placeholder="Enter Mobile Number">

                                            @if ($errors->has('mobile_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mobile_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input class="form-control" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" type = "number"  maxlength = "11" name="phone_number" value="{{$customer->phone_number}}"  placeholder="Enter Phone Number">

                                            @if ($errors->has('phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                                </div>

                               

                                <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Residential Number</label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input class="form-control" type='number' name="res_number" value="{{$customer->res_number}}"  placeholder="Enter Res. Number">

                                            @if ($errors->has('re_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('res_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label"> <?= ( $customer->type == 1) ? 'Certificate' : 'Passport size photo' ?> </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-picture"></i></div>
                                            <input type="file" class="form-control" name="file" placeholder="Enter Phone Number">
                                        @if ($errors->has('file'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('file') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                                </div>



                             

                                <div class="form-group" style="display: <?= ( $customer->type == 1) ? 'none' : '' ?>">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Documents (CNIC, Passport etc) <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-picture"></i></div>
                                            <input multiple="" type="file" class="form-control" name="photos[]" >
                                        @if ($errors->has('document'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('document') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Is Filer </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <select class="form-control select2" name="is_filer">
                                                @if($customer->is_filer)
                                                <option selected="" value="1">YES</option>
                                                <option value="0">NO</option>
                                                @else
                                                 <option value="1">YES</option>
                                                <option selected="" value="0">NO</option>

                                                @endif
                                            </select>
                                            

                                            @if ($errors->has('is_filer'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('is_filer') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>

                                </div>

                               
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">NTN Number</label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="ntn_number" value="{{$customer->ntn_number}}" placeholder="Enter NTN">
                                        @if ($errors->has('ntn_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ntn_number') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>



                        <!-- <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">
                                Rental Desbursement <span style="color: red">*</span> </label>
                            <div class="col-sm-9">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                            <select class="form-control chosen-select" name="payment_method">
                            <option <?=($customer->payment_method == \App\Customer::CASH) ? 'selected' : '' ?> value="0">Cash</option>
                            <option <?=($customer->payment_method == \App\Customer::BANK) ? 'selected' : '' ?> value="1">Bank</option>
                            <option <?=($customer->payment_method == \App\Customer::CHEAQUE) ? 'selected' : '' ?> value="2">Cheque</option>
                            <option <?=($customer->payment_method  == \App\Customer::OPEN_CHEAQUE) ? 'selected' : '' ?> value="3">Open Cheque</option>
                            </select>

                            @if ($errors->has('payment_method'))
                            <span class="help-block">
                            <strong>{{ $errors->first('payment_method') }}</strong>
                            </span>
                            @endif
                            </div>
                            </div>
                        </div> -->




                                  <!-- <hr>
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>  Bank Details</h3>
                            <br> -->


                        <!-- <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">Account title</label>
                            <div class="col-sm-9">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="account_title" value="{{$customer->account_title}}" placeholder="Enter Account Title">

                            </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-3 control-label">Depositer Bank </label>
                            <div class="col-sm-9">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                            <select class="form-control chosen-select" name="depositer_bank">
                            <option value="">None</option>
                            @foreach($depositer_banks as $list)
                            <option <?=($customer->bank_id == $list->id) ? 'selected' : '' ?> value="{{$list->id}}">{{$list->name}}</option>
                            @endforeach

                            </select>

                            </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-3 control-label">IBAN Number</label>
                            <div class="col-sm-9">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="iban_number" value="{{$customer->iban_number}}" placeholder="Enter Account IBAN Number">

                            </div>
                            </div>
                        </div> -->



                            <hr>
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i>  Joint Owner's</h3>
                            <br>


                            <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 2</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="first_owner" value="{{$customer->first_owner}}" placeholder="Enter First Owner">

                            </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Name 3</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="second_owner" value="{{$customer->second_owner}}" placeholder="Enter Second Owner">

                            </div>
                            </div>

                            </div>



                            <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">First Owner Father</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="first_owner_father" value="{{$customer->first_owner_father}}" placeholder="Enter First Owner">

                            </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner Father</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="second_owner_father" value="{{$customer->second_owner_father}}" placeholder="Enter Second Owner Father">

                            </div>
                            </div>

                            </div>



                            <div class="form-group">
                            <label for="exampleInputuname" class="col-sm-2 control-label">First Owner Cnic</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="first_owner_cnic" value="{{$customer->first_owner_cnic}}" placeholder="Enter First Owner Cnic">

                            </div>
                            </div>

                            <label for="exampleInputuname" class="col-sm-2 control-label">Second Owner Cnic</label>
                            
                            <div class="col-sm-4">
                            <div class="input-group">
                            <div class="input-group-addon"><i class="ti-user"></i></div>
                            <input  type="text" class="form-control" name="second_owner_cnic" value="{{$customer->second_owner_cnic}}" placeholder="Enter Second Owner Cnic">

                            </div>
                            </div>

                            </div>



                               <hr>
                                <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Nominee Information</h3>
                                <br>
                                 <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Name of Nominee<span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="nominee_name" value="{{$customer->nominee_name}}" placeholder="Enter Name">
                                        @if ($errors->has('nominee_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">S/O, D/O, W/O. <span style="color: red">*</span></label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-user"></i></div>
                                            <input  type="text" class="form-control" name="nominee_so_do_wo" value="{{$customer->nominee_so_do_wo}}" placeholder="Enter S/O - D/O - W/O ">
                                            @if($customer->nominee_father_type == 1)
                                            <input checked="" type="radio" name="nominee_father_type" value="1">S/O
                                            <input  type="radio" name="nominee_father_type" value="2">D/O
                                            <input type="radio" name="nominee_father_type" value="3"> W/O
                                            @elseif($customer->nominee_father_type == 2)
                                            <input type="radio" name="nominee_father_type" value="1">S/O
                                            <input checked="" type="radio" name="nominee_father_type" value="2">D/O
                                            <input type="radio" name="nominee_father_type" value="3"> W/O

                                            @elseif($customer->nominee_father_type == 3)
                                            <input type="radio" name="nominee_father_type" value="1">S/O
                                            <input type="radio" name="nominee_father_type" value="2">D/O
                                            <input checked="" type="radio" name="nominee_father_type" value="3"> W/O
                                            @else
                                            <input type="radio" name="nominee_father_type" value="1">S/O
                                            <input type="radio" name="nominee_father_type" value="2">D/O
                                            <input type="radio" name="nominee_father_type" value="3"> W/O
                                            @endif
                                        @if ($errors->has('nominee_so_do_wo'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_so_do_wo') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                </div>
                             

                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">CNIC </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" value="{{$customer->nominee_cnic}}" name="nominee_cnic" id="nominee_cnic" onfocusout="return validateCnic(this)" data-inputmask="'mask': '9999999999999'"  placeholder="XXXXXXXXXXXXX"  >
                                            @if($customer->nominee_cnic_flag == \App\Customer::locally)
                                            <input type="radio" checked="" name="nominee_cnic_flag" value="1"> Locally
                                            <input type="radio" name="nominee_cnic_flag" value="2"> Internationally
                                            @elseif($customer->nominee_cnic_flag == \App\Customer::internationally)
                                            <input type="radio" name="nominee_cnic_flag" value="1"> Locally
                                            <input type="radio" checked="" name="nominee_cnic_flag" value="2"> Internationally
                                            @else
                                            <input type="radio" name="nominee_cnic_flag" value="1"> Locally
                                            <input type="radio"  name="nominee_cnic_flag" value="2"> Internationally

                                            @endif

                                            <div style="color: red;display: none;" id="cnic_error1">This Member cnic is found in list of DNFBP. You can't add this Nominee record. </div>

                                        @if ($errors->has('nominee_cnic'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_cnic') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group" id="nominee_address">
                                <label for="address" class="col-sm-2 control-label" id="nominee_address">Nominee Address <span style="color: red">*</span></label>
                                <div class="col-sm-4">
                                <div class="input-group">
                                <div class="input-group-addon"><i class="icon-location-pin"></i></div>
                                <textarea class="form-control" id="nominee_address" name="nominee_address" >{{$customer->nominee_address}}</textarea>
                                @if ($errors->has('nominee_address'))
                                <span class="help-block">
                                <strong>{{ $errors->first('nominee_address') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>
                                </div>
                                </div>


                              

                                <div class="form-group">
                                    <label for="cnic" class="col-sm-2 control-label">Passport No.</label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-credit-card"></i></div>
                                            <input type="text"  class="form-control" value="{{$customer->nominee_passport_no}}" name="nominee_passport_no" id="nominee_passport_no" placeholder="XXXXXXXXX" >

                                        @if ($errors->has('nominee_passport_no'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_passport_no') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Email </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="ti-email"></i></div>
                                            <input type="text" class="form-control" name="nominee_email" value="{{$customer->nominee_email}}"  placeholder="Enter Email">
                                         @if ($errors->has('nominee_email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_email') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>
                                </div>

                            

                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Mobile Number </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input type="text" class="form-control" name="nominee_mobile_number" value="{{$customer->nominee_mobile_number}}"  placeholder="Enter Mobile Number">
                                          @if ($errors->has('nominee_mobile_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_mobile_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Phone Number </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input type="text" class="form-control"  type='number' name="nominee_phone_number" value="{{$customer->nominee_phone_number}}"  placeholder="Enter Phone Number">
                                          @if ($errors->has('nominee_phone_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_phone_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                </div>

                                </div>

                               
                                <div class="form-group">
                                    <label for="exampleInputEmail1" class="col-sm-2 control-label">Residential Number </label>
                                    <div class="col-sm-4">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-phone"></i></div>
                                            <input class="form-control"  type='number' name="nominee_res_number" value="{{$customer->nominee_res_number}}"  placeholder="Enter Res Number">
                                          @if ($errors->has('nominee_res_number'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_res_number') }}</strong>
                                    </span>
                                @endif</div>
                                    </div>
                                    <div class="form-group">
                            <label for="exampleInputEmail1" class="col-sm-2 control-label">Relation with Applicant <span
                                    style="color: red">*</span></label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="icon-link"></i></div>
                                    <select class="form-control chosen-select" name="nominee_relation">
                                        <option selected value="{{ $customer->nominee_relation }}">
                                            {{ $customer->nominee_relation }}</option>
                                        <option >Brother</option>
                                        <option  >Father</option>
                                        <option  >Sister</option>
                                        <option  >Mother</option>
                                        <option  >Friend</option>
                                        <option  >Wife</option>
                                        <option  >Husband</option>
                                        <option  >Son</option>
                                        <option  >Daughter</option>
                                        <option  >Cousin</option>

                                    </select>
                                    @if ($errors->has('nominee_relation'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('nominee_relation') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                                </div>




                                 <!-- <div class="form-group">
                                     <label for="exampleInputEmail1" class="col-sm-3 control-label">Relation with Applicant <span style="color: red">*</span></label>
                                    <div class="col-sm-9">
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="icon-link"></i></div>
                                            <input type="text"  class="form-control" name="nominee_relation" value="{{$customer->nominee_relation}}" placeholder="Enter Relation">
                                        @if ($errors->has('nominee_relation'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('nominee_relation') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div> -->

                            

                                <div class="form-group text-center">
                                    <div class=" col-sm-4">&nbsp;</div>
                                    <div class=" col-sm-4">
                                        <button style="width: 100%" type="submit" class="btn btn-info waves-effect waves-light m-t-10">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>


            function validateCnic(self) 
        {
           var cnic = $(self).val();

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('validate.dnfbp.cnic') }}",
        method:'POST',
        dataType:'json',
        data: {cnic:cnic},
        success:function(data)
        {
          if (data.response == 'invalid') 
          {
                $(self).closest('.input-group').find('#cnic_error1').show();
          }

        }
        })



        return false;
        }


    $(":input").inputmask();

    $('input[type="checkbox"]').click(function(){
            if($(this).prop("checked") == true){
                $('textarea#permanent_address').val($('textarea#mailing_address').val());
            }
            else if($(this).prop("checked") == false){
                $('textarea#permanent_address').val('');
            }
        });


   </script>

@stop