@extends('layouts.app')

@section('title')
All Customers 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Customers</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop

@section('content')


            <div class="container-fluid">

                <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Customer</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                 <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Reference No.</label>
                                                        <select id="ref_id" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                        @foreach($referenceNumbers as $r)
                                                        <option value="{{$r->id}}">{{$r->membership_no}}</option>
                                                        @endforeach
                                                        </select>

                                                         </div>
                                                </div> 
                                                <!--/span-->
                                                <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Customer Name</label>
                                                        
                                                        <select id="cus_id" class="form-control chosen-select">
                                                        <option  value="0">None</option>
                                                        @foreach($customerNames as $c)
                                                        <option value="{{$c->id}}">{{$c->name}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>
                                            
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								<!-- <a href="{{route('customer.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Customer
								</a> -->
							</div>
                            <h3 class="box-title">All Customers (<b>{{$customerCount}}</b>)</h3>

                            <div class="table-responsive" >
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                           <th>Type</th>
                                            <th>Member Name</th>
                                            <th>Code</th>
                                            <th>Mobile Number</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allCustomers as $customer)
                                        <tr>
                                            <td>{{$count++}}</td>

                                             <td>
                                                @if($customer->type == '1')
                                                {{'Company'}}
                                                @elseif($customer->type == '0')
                                                {{'Individual'}}
                                                @endif
                                               </td>
                                            
                                            <td>
                                                @permission('view-customer')
                                                <a href="{{route('customer.detail',['id'=>$customer->id])}}">{{$customer->name}}</a>
                                                @else
                                                {{$customer->name}}
                                                @endpermission
                                            </td>
                                            <td>
                                                <?php $words = explode(" ",$customer->name);
                                                $acronym = "";
                                                foreach ($words as $w) {
                                                    $acronym .= $w;
                                                   
                                                }
                                                ?>

                                                {{$acronym}}00{{$customer->id}}
                                            </td>
<!--                                            <td>{{$customer->father_name}}</td>-->
                                            <td>{{$customer->mobile_number}}</td>


                                           
                                           @if($customer->status == true)
                                            <td><span class="label label-success">Active</span></td>
                                            @else
                                            <td><span class="label label-danger">InActive</span></td>
                                            @endif
                                            <td class="text-nowrap">
                                                @permission('view-customer')
                                                <a href="{{route('customer.detail',['id'=>$customer->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endpermission
                                                @permission('edit-customer')
                                                <a href="{{route('customer.editView',['id'=>$customer->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission
                                                @permission('delete-customer')
                                                <a href="{{route('customer.delete',['id'=>$customer->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" > <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                                <div style="float: right;">{{$allCustomers->links()}}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':false,
            'searching':false,
            'info':true,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        });
    });

        $('.search-customer').on('click',function(){
            
            refId = $('#ref_id').val();
            cusId = $('#cus_id').val();

            if(refId == 0 && cusId == 0) {
                toastr.warning("please select ref no or customer name.");
                return false;
            }

            var data = {'ref':refId,'cus':cusId};
            $.get('/customer/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'paging':false,
                    'searching':false,
                    'info':true,
                    'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
                });
                toastr.success("Search updated.");
            });
        });

       
    </script>
@stop