@extends('layouts.app')

@section('title')
New Sms 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">New SMS</li>
      </ol>
@stop

@section('css')
<link href="{{asset('css/jquery-confirm.css')}}" rel="stylesheet">
@stop

@section('content')

  <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div id="status" style="text-align: center;color:green;display: none"></div>
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Select Customers</h3>
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr #</th>
                                            <th><input type="checkbox" name="select_all" value="1" class="select_all"></th>
                                            <th>Name</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($clients as $c)
                                        <tr>
                                            <td>{{$count++}}</td>
                                             <td><input type="checkbox" name="check_list" value="{{$c->id}}"></td>
                                            <td>{{$c->name}}</td>
                                           
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                            <hr>
                            <h3>Message Box</h3>
                            <textarea class="form-control" id='msg' rows='7' name="message"></textarea>
                            <br>
                            <button class="btn btn-success" onclick="checkSelectedCheckbox()" style="float: right">
                                Send Sms
                            </button>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->


@stop

@section('js')
<script type="text/javascript" src="{{ URL :: asset('js/jquery-confirm.js') }}"></script>
<script>
   function sendSms(check_ids,message) {

    $.confirm({
        title: 'Are You Sure!..',
        content: "You won't be able to revert this!",
        buttons: {
            confirm: function () {
                var data = { 'ids': check_ids,'message':message };
                $.get('/sendMessage', data, function (data) {
                    if(data == 1) {
                        document.getElementById('status').style.display = 'block';
                        document.getElementById('status').style.color = 'green';
                        document.getElementById('status').innerHTML = '<strong><h3>Message Sent Successfully.</h3></strong>';
                        $('#status').delay(9000).fadeOut();
                        location.reload();
                    }
                    else {
                        document.getElementById('status').style.display = 'block';
                        document.getElementById('status').style.color = 'red';
                        document.getElementById('status').innerHTML = '<strong><h3>Error in query!</h3></strong>';
                        $('#status').delay(2000).fadeOut();
                    }
                });
            },
            cancel: function (val) {

            }
        }
    });
}

     
    $(".select_all").click(function(){
        $('input:checkbox').not(this).prop('checked', this.checked);
    });

    function checkSelectedCheckbox()
    {
        var message = $('#msg').val();
        if(!message) {
            document.getElementById('status').style.display = 'block';
            document.getElementById('status').style.color = 'red';
            document.getElementById('status').innerHTML = '<strong><h3>Message box is empty!</h3></strong>';
            $('#status').delay(3000).fadeOut();
            return;
        }

        var check_ids = [];
        
        $.each($("input[name='check_list']:checked"), function(){
                check_ids.push($(this).val());
            });

        // $.each($("input[name='check_list']:checked"), function(){
        //         check_ids.push($(this).val());
        //     });
        if(check_ids.length==0)
        {
            document.getElementById('status').style.display = 'block';
            document.getElementById('status').style.color = 'red';
            document.getElementById('status').innerHTML = '<strong><h3>please select any client!</h3></strong>';
            $('#status').delay(3000).fadeOut();
        }
        else {
          sendSms(check_ids,message); }
           //alert("selected IDS :"+check_ids.length);


    }


</script>

@stop
