@extends('layouts.app')

@section('title')
Sms History 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Sms History</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <div class="pull-right">
                                
                                <a href="{{route('message.add')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Add new Message
                                </a>
                               
                            </div>

                            @permission('manage-messages')
                            <h3 class="box-title">All Messages</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr #</th>
                                            <th style="width:30%;">Message</th>
                                            <th style="width:40%;">Numbers</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allMessages as $m)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td><?php echo $m->message;?></td>
                                            
                                            <td >
                                                <ol start="1" style="overflow-y:auto;height: 100px;">
                                                @foreach($m->smsClients as $c)
                                            <li>{{$c->client->name}}</li>
                                            @endforeach
                                            </ol>
                                            </td>
                                            <td>{{date('d-m-Y', strtotime($m->created_at)) }}</td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>

                             @endpermission
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            "paging":true,
            'info':true,
            'pageLength':100
        });
    });
       
    
    </script>
@stop