@extends('layouts.app')

@section('title')
New Bill
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-expense')
        <li ><a href="{{route('expense.all')}}">Bill</a></li>
        @endpermission
        <li class="active">New Bill</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> New Bill</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('expense.insert')}}" method="post" enctype="multipart/form-data">
                               {{csrf_field()}}
                               
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Expense Type <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="expense_type">
                                                <option value="{{\App\Expense::CONSTRUCTION}}">Construction</option>
                                                <option value="{{\App\Expense::SERVICE}}">Service</option>
                                               
                                               
                                            </select>
                                        @if ($errors->has('expense_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('expense_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Vendor <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="vendor_id">
                                                <option>None</option>
                                               @foreach($vendors as $v)
                                               @if(old('vendor_id') == $v->id)
                                               <option selected="" value="{{$v->id}}">{{$v->name}} - {{$v->phone_number}}</option> 
                                               @else
                                               <option value="{{$v->id}}">{{$v->name}} - {{$v->phone_number}}</option> 
                                               @endif
                                               @endforeach
                                            </select>
                                        @if ($errors->has('vendor_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('vendor_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Account Head <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="category_id">
                                                <option>None</option>
                                               @foreach($accounts as $c)
                                               @if(old('category_id') == $c->id)
                                               <option selected="" value="{{$c->id}}">{{$c->number}} - {{$c->name}}</option> 
                                               @else
                                               <option value="{{$c->id}}">{{$c->number}} - {{$c->name}}</option> 
                                               @endif
                                               @endforeach
                                            </select>
                                        @if ($errors->has('category_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('category_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="amount" value="{{old('amount')}}" id="exampleInputuname" placeholder="Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bill Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="billed_at" value="{{old('billed_at')}}" id="exampleInputuname" placeholder="Bill Date">
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Due Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="due_at" value="{{old('due_at')}}" id="exampleInputuname" placeholder="Due Date">
                                        @if ($errors->has('due_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('due_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Notes </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea name="notes" class="form-control" rows="3" placeholder="Enter Notes">{{old('notes')}} </textarea>
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="status" value="0">

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Attachment </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="file" class="form-control" name="image"   placeholder="Image">
                                        @if ($errors->has('image'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('image') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-sm-12 col-xs-12"  >
                        <div class="white-box">
                            <h3 class="box-title">Make Payment <input type = "checkbox" name="receipt" onclick="receiptBox()" value="1" id="receipt"></h3>
                            <div  id="receipt_div" style="display: none">

                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Mode <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='account_id' >
                                                                @foreach($accounts as $acc)
                                                                <option value="{{$acc->id}}">{{$acc->number}} - {{$acc->name}}</option>
                                                                @endforeach
                                                            </select>
                                                            @if ($errors->has('account_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                           
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="pay_amount" value="{{old('pay_amount')}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Amount">
                                                        @if ($errors->has('pay_amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('pay_amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Method <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_method' >
                                                                <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                                                
                                                            </select>
                                                            @if ($errors->has('payment_method'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_method') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Payment Description (optional)</label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="payment_description" value="{{old('payment_description')}}" class="form-control" id="exampleInputEmail1" placeholder="Enter payment_description">
                                                        @if ($errors->has('payment_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_description') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <br><div class="clearfix"></div>
                            
                           
                            <br><div class="clearfix"></div>

                        </div>
                    </div>


                                    <div class="col-sm-4">&nbsp;</div>
                                    <div class="col-sm-4">
                                <div class="form-group">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10" style="width: 100%">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')
<script type="text/javascript">
    function receiptBox(){
    if($('#receipt').prop("checked") == true) {
        $('#receipt_div').css('display','block');
    }
    else if($('#receipt').prop("checked") == false) {
        $('#receipt_div').css('display','none');
    }
}
</script>
@stop