@extends('layouts.app')

@section('title')
Edit Bill
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-expense')
        <li ><a href="{{route('expense.all')}}">Bill</a></li>
        @endpermission
        <li class="active">Edit Bill</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> Edit Bill : BILL-00{{$expense->id}}</h3>
                            <p class="text-muted m-b-30 font-13"> Update  Information </p>
                            <form class="form-horizontal" action="{{route('expense.update')}}" method="post" enctype="multipart/form-data">
                               {{csrf_field()}}

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Expense Type <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="expense_type">
                                                @if($expense->expens_type == \App\Expense::Construction)
                                                <option selected="" value="{{\App\Expense::CONSTRUCTION}}">Construction</option>
                                                <option value="{{\App\Expense::SERVICE}}">Service</option>
                                                @else
                                                <option value="{{\App\Expense::CONSTRUCTION}}">Construction</option>
                                                <option selected="" value="{{\App\Expense::SERVICE}}">Service</option>


                                                @endif
                                               
                                               
                                            </select>
                                        @if ($errors->has('expense_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('expense_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Vendor <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="vendor_id">
                                                <option>None</option>
                                               @foreach($vendors as $v)
                                               @if($expense->vendor_id == $v->id)
                                               <option selected="" value="{{$v->id}}">{{$v->name}} - {{$v->phone_number}}</option> 
                                               @else
                                               <option value="{{$v->id}}">{{$v->name}} - {{$v->phone_number}}</option> 
                                               @endif
                                               @endforeach
                                            </select>
                                        @if ($errors->has('vendor_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('vendor_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Account Head <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="category_id">
                                                <option>None</option>
                                               @foreach($categories as $c)
                                               @if($expense->category_id == $c->id)
                                               <option selected="" value="{{$c->id}}">{{$c->number}} - {{$c->name}}</option> 
                                               @else
                                               <option value="{{$c->id}}">{{$c->number}} - {{$c->name}}</option> 
                                               @endif
                                               @endforeach
                                            </select>
                                        @if ($errors->has('category_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('category_id') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Amount <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="numeric" class="form-control" name="amount" value="{{$expense->amount}}" id="exampleInputuname" placeholder="Amount">
                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bill Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="billed_at" value="{{$expense->billed_at}}" id="exampleInputuname" placeholder="Bill Date">
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Due Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="due_at" value="{{$expense->due_at}}" id="exampleInputuname" placeholder="Due Date">
                                        @if ($errors->has('due_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('due_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Notes </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea name="notes" class="form-control" rows="3" placeholder="Enter Notes">{{$expense->notes}} </textarea>
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Attachment </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="file" class="form-control" name="image"   placeholder="Image">
                                        @if ($errors->has('image'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('image') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <input type="hidden" name="status" value="{{$expense->status}}">
                                <input type="hidden" name="id" value="{{$expense->id}}">

                                



                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop