@extends('layouts.app')

@section('title')
Add Payment 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-expense')
        <li ><a href="{{route('payment.all')}}">Payments</a></li>
        @endpermission
        <li class="active">Add Payment</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
    <form method="post" action="{{route('payment.insert')}}" class="form-horizontal">
        {{csrf_field()}}

        
    <div class="row">
        <div class="col-lg-12 col-sm-12 col-xs-12">
             @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
            <div class="white-box">
                <h3 class="box-title">Payment Information</h3>
                            <hr>
                            
                            <input type="hidden" name="is_approved" value="0">
                            
                 <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Select Vendor <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select name="vendor_id" id='vendor_id' class="form-control chosen-select" onchange="updateBill(this.value)">
                                                                <option value="" selected="">None</option>
                                                              @foreach($vendors as $vendor)
                                                              @if(old('vendor_id') == $vendor->id)
                                                              <option selected="" value="{{$vendor->id}}">{{$vendor->name}} - {{$vendor->phone_number}}</option>
                                                              @else
                                                               <option  value="{{$vendor->id}}">{{$vendor->name}} - {{$vendor->phone_number}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                            @if ($errors->has('vendor_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('vendor_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-12" id='bill'></div>
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Account<span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="account_id">
                                                                <option value="">None</option>

                                                                @foreach($accounts as $account)
                                                                <option value="{{$account->id}}">{{$account->name}}
                                                                </option>
                                                                @endforeach
                                                              
                                                            </select>
                                                            @if ($errors->has('account_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Date <span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="date" class="form-control" name='date' value="{{old('date')}}" id="exampleInputEmail1" placeholder="Enter  Date">
                    @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Method <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_method' >
                                                                <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                                                
                                                            </select>
                                                            @if ($errors->has('payment_method'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_method') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="amount" value="{{old('amount')}}" class="form-control" id="amount" placeholder="Enter Amount">
                                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Balance Due</label>
                                                        <div class="col-md-8">
                                                            <input readonly="" type="text" name="due" value="{{old('due')}}" class="form-control" id="due" >

                                                        </div>
                                                    </div>
                            </div>
                           
                           <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Description</label>
                    <div class="col-md-8">
                        <textarea class="form-control" rows="5" name="notes" placeholder="Enter Description"></textarea>
                    @if ($errors->has('notes'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Reference</label>
                    <div class="col-md-8">
                      
                        <input type="text" class="form-control" name='reference' value="{{old('reference')}}" id="exampleInputEmail1" placeholder="Enter Reference">
                       
                    @if ($errors->has('reference'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('reference') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
              <div class="clearfix"></div>
              <div class=" col-sm-4">&nbsp;</div>
             <div class=" col-sm-4">
              <div class="form-group">
                        <button type="submit" class="btn btn-info  waves-effect waves-light" style="width: 100%">Save</button>
                    </div>
              </div>
            </div>
        </div>
    </div>
    </form>
</div>


@stop

@section('js')
<script>
    

function updateBill(){
    $('.preloader').fadeIn();

    var vendor_id = $('#vendor_id').val();


    var data = {'vendor_id':vendor_id};

    $.get('/payment/add/getVendorBills', data, function (data) {

        document.getElementById('bill').innerHTML = data;
        $('#myTable').DataTable({
            "paging":   false,
        "ordering": false,
        "info":     false
        });
    });

  //  $('#wait').hide();
   $('.preloader').fadeOut();
}

$('#amount').keyup(function(){

  amount = parseInt($('#amount').val());

  if(amount){
  property = $('input[name="bill_id"]:checked').val();

  id = "#rem" + property;

  remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount - amount);
  }
  else {
      property = $('input[name="bill_id"]:checked').val();

      id = "#rem" + property;
      remaining_amount = parseInt($(id).val());

  $('#due').val(remaining_amount);
  }







});
</script>
@stop