@extends('layouts.app')

@section('title')
Edit Payment
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-payment')
        <li ><a href="{{route('payment.all')}}">Payemnts</a></li>
        @endpermission
        <li class="active">Edit Payment</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
    <form method="post" action="{{route('payment.update')}}" class="form-horizontal" enctype="multipart/form-data">
        {{csrf_field()}}

        
        <input type="hidden" name="id" value="{{$payment->id}}">
    <div class="row">
        <div class="col-lg-12 col-sm-12 col-xs-12">
             @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
            <div class="white-box">
                <h3 class="box-title">Payment Information</h3>
                            <hr>
                            
                        
                        
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Account<span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="account_id">

                                                                <option value="">None</option>

                                                                @foreach($accounts as $account)
                                                                @if($payment->account_id == $account->id)
                                                                <option selected="" value="{{$account->id}}">{{$account->name}}
                                                                </option>
                                                                @else
                                                                <option  value="{{$account->id}}">{{$account->name}}
                                                                </option>


                                                                @endif
                                                                @endforeach
                                                              
                                                            </select>
                                                            @if ($errors->has('account_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('account_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Date <span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="date" class="form-control" name='date' value="{{$payment->date}}" id="exampleInputEmail1" placeholder="Enter  Date">
                    @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Method <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_method' >
                                                                @if($payment->payment_method == \App\ExpensePayment::CASH)
                                                                <option selected="" value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>
                                                                @else

                                                                <option  value="{{\App\ExpensePayment::CASH}}">Cash</option>

                                                                <option selected="" value="{{\App\ExpensePayment::BANK_TRANSFER}}">Bank Transfer</option>


                                                                @endif
                                                                
                                                            </select>
                                                            @if ($errors->has('payment_method'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_method') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="text" name="amount" value="{{$payment->amount}}" class="form-control" id="amount" placeholder="Enter Amount">
                                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <!-- <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Balance Due</label>
                                                        <div class="col-md-8">
                                                            <input readonly="" type="text" name="due" value="{{old('due')}}" class="form-control" id="due" >

                                                        </div>
                                                    </div>
                            </div> -->
                           
                           <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Memo</label>
                    <div class="col-md-8">
                        <textarea class="form-control" rows="5" name="notes" placeholder="Enter Description">{{$payment->notes}}</textarea>
                    @if ($errors->has('notes'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('notes') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Reference</label>
                    <div class="col-md-8">
                      
                        <input type="text" class="form-control" name='reference' value="{{$payment->reference}}" id="exampleInputEmail1" placeholder="Enter Reference">
                       
                    @if ($errors->has('reference'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('reference') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Approval Status</label>
                    <div class="col-md-8">
                      
                        <select class="form-control chosen-select" name="approval_status">
                            <option value="0">Pending</option>
                            <option value="1">Approved</option>
                        </select>
                       
                    @if ($errors->has('approval_status'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('approval_status') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Upload</label>
                    <div class="col-md-8">
                      
                        <input type="file" name="file">
                       
                    @if ($errors->has('file'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('file') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>

              <div class="clearfix"></div>
              <div class=" col-sm-4">&nbsp;</div>
             <div class=" col-sm-4">
              <div class="form-group">
                        <button type="submit" class="btn btn-info  waves-effect waves-light" style="width: 100%">Save</button>
                    </div>
              </div>
            </div>
        </div>
    </div>
    </form>
</div>

@stop