@extends('layouts.app')
@section('title')
Payment Voucher
@stop

@section('css')
<style type="text/css">
    @page  
{ 
    size: auto;   /* auto is the initial value */ 

    /* this affects the margin in the printer settings */ 
    margin: 0mm 0mm 0mm 0mm;  
} 
.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}
.container-fluid {
    padding: 3px 30px 0;
}
.table>tbody>tr>td{
    border-top: 1px solid #734c4c;
    background: #dadada;
    padding: 0 18px
}
.receipt{
    font-size: 20px;
}
</style>
@stop
@section('content')

<div class="container-fluid">
    <div class="row printableArea"  id="content">

        <div class="col-lg-12">
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-sm-4 col-xs-4">
                                <img width="100px" height="100px" src="{{asset('images/logo.png')}}" class="img-responsive" style="z-index: 9">
                            </div>
                            <div class="col-sm-4 col-xs-4 text-center">
                                <span class="receipt">Payment Voucher</span><br>
                                <span class="payment">Office Copy</span>
                            </div>
                            <div class="col-sm-4 col-xs-4"></div>
                            </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none mt-35">
                <div class="row" style="text-transform: uppercase; font-weight: 600;">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0" style="font-weight: 900">REF.No.</div>
                                <div class="col-sm-7 col-xs-7">&nbsp; Bill-000{{$payment->bill->id}}</div>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                &nbsp;
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b>Date:&nbsp;{{date('d/m/Y',strtotime($payment->date))}}</b><br>
                                <b>Pay to:&nbsp; {{$payment->bill->vendor->name}}</b><br>
                                <b>Expense Type:&nbsp; {{$payment->bill->category->name}}</b>
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <br>
                                <div class="table-responsive">
                                <table class="table">
                                    <thead style="background: #777">
                                        <tr>
                                            <th style="color: white">Description</th>
                                            <th style="color: white" class="text-right">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{$payment->notes}}</td>
                                            <td class="text-right">{{number_format($payment->amount)}} PKR</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            </div>
                            <div class="clearfix" style="margin-bottom: 12px"></div>
                            <div class="col-sm-8 col-xs-8">
                               <div class="col-xs-12 col-sm-12">
                                Amount in words (PKR):<i> &nbsp;&nbsp;&nbsp;  {{$words}} Only</i>
                            </div>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b style="font-weight: 900">TOTAL: {{number_format($payment->amount)}} PKR</b>
                            </div>
                            <div class="col-sm-8 col-xs-8">
                               <div class="col-xs-4 col-sm-4">Payment Mode</div>
                               @if($payment->payment_method == 1)
                            <div class="col-sm-8 col-xs-8"><b>CASH /<strike> CHEQUE </strike>/ <strike>PAY ORDER</strike></b></div> 
                            @else

                            <div class="col-sm-8 col-xs-8"><b><strike>CASH </strike>/ CHEQUE / <strike>PAY ORDER</strike></b></div> 

                            @endif
                            </div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            <div class="col-xs-8 col-sm-8">
                                <b style="font-weight: 900">Payment Recieved By</b>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b style="font-weight: 900">Payment Approved By</b>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
        <div class="sperator"></div>
        <div class="col-lg-12">
            <div class="white-box border-none ">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-sm-4 col-xs-4">
                                <img width="100px" height="auto" src="{{asset('images/logo.png')}}" class="img-responsive" style="z-index: 9">
                            </div>
                            <div class="col-sm-4 col-xs-4 text-center">
                                <span class="receipt">Payment Voucher</span><br>
                                <span class="payment">Office Copy</span>
                            </div>
                            <div class="col-sm-4 col-xs-4"></div>
                            </div>
                    </div>
                </div>
            </div>
            <div class="white-box border-none mt-35">
                <div class="row" style="text-transform: uppercase; font-weight: 600;">
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0" style="font-weight: 900">REF.No.</div>
                                <div class="col-sm-7 col-xs-7">&nbsp; Bill-000{{$payment->bill->id}}</div>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                &nbsp;
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b>Date:&nbsp;{{date('d/m/Y',strtotime($payment->date))}}</b><br>
                                <b>Pay to:&nbsp; {{$payment->bill->vendor->name}}</b><br>
                                <b>Expense Type:&nbsp; {{$payment->bill->category->name}}</b>
                            </div>
                            <div class="col-sm-12 col-xs-12">
                                <br>
                                <div class="table-responsive">
                                <table class="table">
                                    <thead style="background: #777">
                                        <tr>
                                            <th style="color: white">Description</th>
                                            <th style="color: white" class="text-right">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{$payment->notes}}</td>
                                            <td class="text-right">{{number_format($payment->amount)}} PKR</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            </div>
                            <div class="clearfix" style="margin-bottom: 12px"></div>
                            <div class="col-sm-8 col-xs-8">
                               <div class="col-xs-12 col-sm-12">
                                Amount in words (PKR):<i> &nbsp;&nbsp;&nbsp;  {{$words}} Only</i>
                            </div>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b style="font-weight: 900">TOTAL: {{number_format($payment->amount)}} PKR</b>
                            </div>
                            <div class="col-sm-8 col-xs-8">
                               <div class="col-xs-4 col-sm-4">Payment Mode</div>
                               @if($payment->payment_method == 1)
                            <div class="col-sm-8 col-xs-8"><b>CASH /<strike> CHEQUE </strike>/ <strike>PAY ORDER</strike></b></div> 
                            @else

                            <div class="col-sm-8 col-xs-8"><b><strike>CASH </strike>/ CHEQUE / <strike>PAY ORDER</strike></b></div> 

                            @endif
                            </div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            <div class="col-xs-8 col-sm-8">
                                <b style="font-weight: 900">Payment Recieved By</b>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <b style="font-weight: 900">Payment Approved By</b>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
        

    </div>
    <div style="display: inline-block; ">
       
    <!-- <div class="text-left" style="display: inline-block;"><a target="_blank" href="#">
        <button  class="btn btn-default btn-outline" type="button"> <span><i class="fa fa-download"></i> Download</span> </button></a>
    </div> -->
    

  

    <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
    </div>
    
</div>
</div>
<!-- /.container-fluid -->



@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>
$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>
@stop