@extends('layouts.app')

@section('title')
UpComing Follow ups | Hamdard City
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Follow ups</li>
      </ol>
@stop

@section('css')

<link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">

<style>

table.dataTable thead .sorting_asc {
    background-image: none !important;
}

.table.dataTable, table.dataTable {
    width: 99.8%!important;
}
</style>

@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	
                            <h3 class="box-title">All Upcoming FollowUps</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr.No</th>
                                            <th>Created At</th>
                                            <th>Unit</th>
                                            <th>Customer</th>
                                            <th>Remarks</th>
                                            
                                            <th>Next Follow up</th>
                                            <th>Status</th>
                                            <th>Follow Up By</th>
                                            <th>Assign To</th>
                                            <th>Action</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        <?php $count =1;?>
                                        


                                        @foreach($followUps as $f)
                                        
                                        @if($f->next_follow_up == date('Y-m-d'))
                                        
                                        <tr style="color:green;">
                                            
                                            <td><b>{{$count++}}<b></td>
                                            <td><b>{{date('d-m-Y h:i',strtotime($f->created_at))}}</b></td>
                                            
                                            <td><b>{{$f->property->inventory->unit_number}}</b></td>
                                            <td><b>{{$f->property->customer->name}}</b></td>
                                            <td><b>{{$f->remarks}}</b></td>
                                            
                                            <td><b>Today</b></td>
                                            <td><b>{{$f->status}}</b></td>
                                            <td><b>{{$f->user->name}}</b></td>
                                            <td><b>{{$f->user_asign->name}}</b></td>
                                            
                                            <td class="text-nowrap">

                                                
                                                <a onclick="openHistoryModal({{$f->property->id}})" href="#!" data-toggle="tooltip" data-original-title="Follow up" class="btn btn-success"> </i> Show History </a>
                                                 
                                            </td>
                                        </tr>

                                            @else
                                            <tr>
                                                <td>{{$count++}}</td>
                                            <td>{{date('d-m-Y h:i',strtotime($f->created_at))}}</td>
                                            <!--plot_number-->
                                            <td>{{$f->property->inventory->unit_number}}</td>
                                            <td>{{$f->property->customer->name}}</td>
                                            <td>{{$f->remarks}}</td>
                                            
                                            <td>{{date('d-m-Y',strtotime($f->next_follow_up))}}</td>
                                            <td><b>{{$f->status}}</b></td>
                                            
                                            <td><b>{{$f->user->name}}</b></td>
                                            
                                            <td><b>{{$f->user_asign->name}}</b></td>
                                            
                                            <td class="text-nowrap">

                                                
                                                <a onclick="openHistoryModal({{$f->property->id}})" href="#!" data-toggle="tooltip" data-original-title="Follow up" class="btn btn-success"> </i> Show History </a>
                                             
                                            </td>
                                        </tr>

                                            @endif
                                            
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

            <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  
</div>

@stop

@section('js')

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':50,
            'dom': 'Bfrtip',
        'buttons': [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
            
        });
    });

    function openHistoryModal(property_id) {

        var data={'property_id':property_id};
        $.get('/show_followup_history', data, function (data) {
            document.getElementById('exampleModal1').innerHTML = data;
            $('#exampleModal1').modal();
        });
    }
    
function updateChat() {

    data = {'pro_id':$('#property_id').val(),'remarks':$('#remarks').val(),'next_follow_up':$('#next_follow_up').val(),'status':$('#status').val(),'user_assign':$('#user_assign').val()};

    $.get('/update_history', data, function (data) {

        
        
         if(data.remarks || data.next_follow_up || data.status || data.user_assign ){

           $("#remarks_eror").text(data.remarks);
           $("#next_follow_up_error").text(data.next_follow_up);
           $("#status_error").text(data.status);
           $("#user_error").text(data.user_assign);
            
          }
          else if(data.success == true){
                        

           toastr.success(data.message);
            $("#exampleModal1").click();
     } 

      

    } , 'json');
}

function deleteFollowup(id) {

    data = {'id':id};

    $.get('/delete_followup', data, function (data) {

        document.getElementById('exampleModal1').innerHTML = data;

        toastr.success("Follow up Deleted Successfully.");

    });
}

        
    </script>
@stop