@extends('layouts.app')

@section('title')
New Bill
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        
        <li ><a href="{{route('vendor-vouchers')}}">Bill</a></li>
        
        <li class="active">New Bill</li>
      </ol>
@stop
@section('css')

<style type="text/css">
    
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 14px;
    text-align: left;
}
</style>
@endsection
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-settings fa-fw"></i> New Bill</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form id="create-bill" class="form-horizontal" action="{{route('create-bill')}}" method="post" enctype="multipart/form-data">
                               {{csrf_field()}}
                               

                               <b>Voucher Type</b> <input type="radio" name="voucher_type" disabled="" value="{{\App\GeneralJournalEntry::CRV}}" required=""> CRV &nbsp;&nbsp;&nbsp; <input disabled="" type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::BRV}}" required=""> BRV &nbsp;&nbsp;&nbsp;  <input  type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::CPV}}" required=""> CPV &nbsp;&nbsp;&nbsp; <input  type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::BPV}}" required=""> BPV &nbsp;&nbsp;&nbsp;
                                        <input type="radio" name="voucher_type" value="{{\App\GeneralJournalEntry::JV}}" required=""> JV &nbsp;&nbsp;&nbsp
                                        <br>

                                        <div class="row">
                                        <div class="col-md-4">
                                            Bank Name &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text"  name="bank_name" id="bank_name">

                                        </div>

                                        <div class="col-md-4">
                                            Chq # / Ins. # &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text" id="cheaque_no" name="cheaque_no" >

                                        </div>

                                    </div>
                                    <br>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label">Expense Type <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <select class="form-control chosen-select" name="expense_type" >
                                                <option value="{{\App\Expense::CONSTRUCTION}}">Construction</option>
                                                <option value="{{\App\Expense::SERVICE}}">Non-Construction</option>
                                               
                                               
                                            </select>
                                        @if ($errors->has('expense_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('expense_type') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                               <div class=col-md-12 style="overflow-y:auto;height: 220px;">
                                            <table class="table table-bordered table-responsive-md table-striped text-center">
                                                <thead>
                                                    <tr>
                                                        
                                                        <th class="text-center">ACCOUNT</th>
                                                        <th class="text-center">DEBIT</th>
                                                        <th class="text-center">CREDIT</th>
                                                        
                                                        <th class="text-center">NAME</th>
                                                        
                                                        
                                                    </tr>

                                                </thead>
                                                <tbody>
                                                    <?php for($i =0 ; $i<20; $i++) {?>
                                                    <tr height="2px">

                                                        <td class="pt-3-half account"  style="width: 40%" contenteditable="true">
                                                            <select class="form-control chosen-select"  style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="account[]">
                                                                <option value="0">None</option>
                                                                @foreach($accounts as $a)
                                                                @if($a->sub_account_id)
                                                                <option style="font-size: 11px;" value="{{$a->id}}">&nbsp;&nbsp;&nbsp;{{$a->number}} - {{$a->name}}</option>
                                                                @else
                                                                <option style="font-size: 11px;" value="{{$a->id}}">{{$a->number}} - {{$a->name}}</option>
                                                                @endif
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td class="pt-3-half debit"   contenteditable="true" onkeyup="addDebit()">0</td>
                                                        <td class="pt-3-half credit"  contenteditable="true" onkeyup="addCredit()">0</td>

                                                        
                                                        <td class="pt-3-half name" contenteditable="true">
                                                            <select class="form-control chosen-select"  style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;" name="name1[]">
                                                                <option value="0">None</option>
                                                                
                                                                @foreach($vendors as $v)
                                                                <option style="font-size: 11px;" value="{{$v->id}}">{{$v->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>

                                                        
                                                        

                                                        
                                                    </tr>
                                                <?php } ?>


                                            </tbody>
                                        </table>
                                    </div>

                                    <table class="table">
                                        <tr>
                                            <th style="text-align: right;width: 37%;">Totals</th>
                                            <th style="text-align: center; width: 10%; font-size: 16px;font-weight: 600;" id="debit-total">0</th>
                                            <th style="text-align: center;width: 10%; font-size: 16px; font-weight: 600;" id="credit-total">0</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </table>

                                    <div class="clearfix"></div>

                                    <br><br>

                               <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Bill Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="billed_at" value="{{old('billed_at')}}" id="exampleInputuname" placeholder="Bill Date"  required="">
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Due Date <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="date" class="form-control" name="due_at" value="{{old('due_at')}}" id="exampleInputuname" placeholder="Due Date" required="">
                                        @if ($errors->has('due_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('due_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Notes </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <textarea name="notes" class="form-control" rows="3" placeholder="Enter Notes">{{old('notes')}} </textarea>
                                        @if ($errors->has('billed_at'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('billed_at') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="status" value="0">

                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Attachment </label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="file" class="form-control" name="image"   placeholder="Image">
                                        @if ($errors->has('image'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('image') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-sm-12 col-xs-12"  >
                        


                                    <div class="col-sm-4">&nbsp;</div>
                                    <div class="col-sm-4">
                                <div class="form-group">
                                        <button type="button" class="btn btn-info waves-effect waves-light m-t-10 search" id="search" style="width: 100%" disabled="">Save</button>
                                    </div>
                                </div>


                                <input type="hidden" id="debitB" name="debitB" value="">
                                <input type="hidden" id="creditB" name="creditB" value="">

                                <input type="hidden" id="memoB" name="memoB" value="">
                                

                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop


@section('js')
<script type="text/javascript">
    function receiptBox(){
    if($('#receipt').prop("checked") == true) {
        $('#receipt_div').css('display','block');
    }
    else if($('#receipt').prop("checked") == false) {
        $('#receipt_div').css('display','none');
    }


}

function addDebit() {
        sum = 0;
        $('.debit').each(function(){
            if(this.innerHTML) {
                sum += parseInt(this.innerHTML);
            }
        });
        document.getElementById('debit-total').innerHTML = sum;
        checkTotal();
    }

    function addCredit() {
        sum = 0;
        $('.credit').each(function(){
            if(this.innerHTML) {
                sum += parseInt(this.innerHTML);
            }
        });
        document.getElementById('credit-total').innerHTML = sum;
        checkTotal();
    }

    function checkTotal() {

        debit = parseInt(document.getElementById('debit-total').innerHTML);
        credit = parseInt(document.getElementById('credit-total').innerHTML);
        if(debit == credit) {
            $( "#search" ).prop( "disabled",false );

            document.getElementById('debit-total').style.color = 'black';
            document.getElementById('credit-total').style.color = 'black';
            $( "#update" ).prop( "disabled",false );
        }
        else
        {
            $( "#search" ).prop( "disabled", true );

            document.getElementById('debit-total').style.color = 'red';
            document.getElementById('credit-total').style.color = 'red';
            $( "#update" ).prop( "disabled",false );
        }

    }


$('#search').click(function(){

        

        debit = [];
        $('.debit').each(function(){
            if(this.innerHTML) {
                debit.push(parseInt(this.innerHTML));
            }
        });

        $('#debitB').val(debit);



        credit = [];
        $('.credit').each(function(){
            if(this.innerHTML) {
                credit.push(parseInt(this.innerHTML));
            }
        });

        $('#creditB').val(credit);

        voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

        if(!voucher_type) {
            alert('voucher type required.');
        
        return false;}

       


        $('#create-bill').submit();

        
    });
</script>
@stop