@extends( 'layouts.app' )

@section('title')
Control Account Detail
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        
        <li class="active">Account Detail</li>
      </ol>
@stop
@section('css')

<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style type="text/css">
    
    @media print {
  .page-wrapper{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif !important;
        color: black !important
        }
        
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }
     table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
        border-collapse: collapse;
    }
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    table.dataTable thead td, table.dataTable thead th {
    border-bottom: none !important;
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    a{
        color: black !important
    }
    .page-wrapper {
    padding-top: 0px;
    }
       .table>thead>tr>th, .user-table .table tbody>tr:last-child td {
    border-bottom: 1px solid #2e3233;
    line-height: 2.2;
    background: #eee;
    border-right: 1px solid;
    }
    table.dataTable thead th {
    padding: 0 5px 0px 5px !important;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
}
    }
</style>
@endsection
@section('content')
            <div class="container-fluid">

                <!--.row-->
                <div class="row no-print">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Customize Report</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">

                                                <div class="col-md-6">
                                                
                                                
                                               <div class="form-group">
                <label class="col-sm-3 control-label">Date range</label>
        <div class="col-sm-9">
                <div class="input-group" id="date-div">
                  <div class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" class="form-control pull-right" id="daterange-btn"   name='date_range' >
                
                </div>
                @if($errors->has('date_range'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('date_range') }}</strong>
                                    </span>
                                @endif
        </div>
                <!-- /.input group -->
              </div>
              </div>
              <div class="form-actions">
                                            <button type="button" class="btn btn-success update-report"> <i class="fa fa-check" ></i> Update</button>
                                            
                                        </div>
                
                                            </div>
                                            
                                        </div>

                                        
                                        
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
<div id="update-report">

                <!-- /row -->
                <div class="row">
                   
                    <div class="col-sm-12" >
                        <div class="white-box">
                            <div class="row text-center">
                                       <h3><strong>{{env('APP_NAME')}}</strong></h3>
                                       <h4><strong>Subsidiary Ledger</strong></h4>
                                       <h6>{{date('M d,Y',strtotime($from))}} - {{date('M d,Y',strtotime($to))}}</h6>
                                       <h4><strong><u> {{$account->name}}  {{$account->rep_name}} </u></strong></h4> 
                                    </div>
                                     <div class="text-right">User ID:&nbsp; {{Auth::user()->name}}</div>

                            
                                                @if($account->file)

                                                <div class="col-md-6">
                                                    

                                                    <a target="_blank" href="{{asset('uploads/'.$account->file)}}">

                                                        @if(strpos($account->file, 'docx') !== false)

                                                        <img src="{{asset('uploads/word.png')}}" width="250" height="150" />

                                                        @elseif(strpos($account->file, 'pdf') !== false)

                                                       
                                                        </script>

                                                        <iframe src="{{asset('uploads/'.$account->file)}}" width="250" height="150" />
                                                        </iframe>



                                                            @else

                                                            <embed src="{{asset('uploads/'.$account->file)}}" width="250" height="150" />

                                                            @endif

                                                            

                                                    
                                                
                                                   
                                                    <br>
                                                    <label style="font-size: 12px; cursor: pointer;"><b>&nbsp;Vendor Agreement</b></label>
                                                     </a>
                                                    <br>
                                                    @if(strpos($account->file, 'docx') !== false)
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('uploads/'.$account->file)}}"><i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                                    @else
                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('uploads/'.$account->file)}}"><i class="fa fa-eye" style="text-transform: none;">&nbsp;</i>Preview</a>&nbsp;&nbsp;

                                                    <a target="_blank" style="color:blue;text-decoration: underline;font-size: 11px" href="{{asset('uploads/'.$account->file)}}" download=""> <i class="fa fa-download" style="text-transform: none;">&nbsp;</i>Download</a>&nbsp;&nbsp;

                                                    @endif
                                                    
                                            </div>
                                            @endif
                                                


                            

                            <div class="clearfix"></div>

                                    <div class="table-responsive">

                                        <table  class="table table-bordered" >
                                            <thead>
                                                <tr style="border: 1px solid;">
                                                    <th style="border-left: 1px solid;" >Date</th>
                                                    <th  >Voucher No.</th>
                                                    <th  style="width: 40%;"  colspan="2">Narration</th>
                                                    <th class="text-center" >Debit</th>
                                                    <th class="text-center" >Credit</th>
                                                    <th class="text-center" >Balance</th>
                                                </tr>
                                                
                                            </thead>
                                            <tbody>
                                                <?php $balance = $openingBalance; $debit = 0; $credit = 0;?>

                                                <tr>
                                                    <td ></td>
                                                    <td ></td>
                                                    <td  colspan="2"> Opening Balance</td>
                                                    <td class="text-right"></td>
                                                    <td class="text-right"></td>
                                                        @if($balance < 0)
                                                    <td class="text-right">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td class="text-right">{{$balance > 0? number_format($balance) : '-'}}</td>
                                                    @endif
                                                   
                                                </tr>

                                                @if($accountEntries)
                                                @foreach($accountEntries->entry as $entry)
                                                <tr>
                                                    <td >{{date('d/m/Y',strtotime($entry->date))}}</td>

                                                    @if($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                            <td >CRV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                            <td >BRV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                            <td >CPV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                            <td >BPV-{{$entry->voucher_no}}</td>
                                            @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                            <td >JV-{{$entry->voucher_no}}</td>
                                            @else
                                            <td ></td>
                                            @endif

                                            <td  colspan="2"> {{$entry->memo}}</td>


                                            
                                                    
                                                    <td class="text-right">{{$entry->amount > 0 ? number_format(abs($entry->amount)) : ''}}

                                                    <?php $debit += $entry->amount > 0 ? $entry->amount : 0;

                                                    $balance += $entry->amount > 0 ? $entry->amount : 0;?>
                                                        
                                                    </td>
                                                    <td class="text-right">{{$entry->amount < 0 ? number_format(abs($entry->amount)) : ''}}

                                                        <?php $credit += $entry->amount < 0 ? abs($entry->amount) : 0;
                                                        $balance += $entry->amount < 0 ? $entry->amount : 0;
                                                    ?></td>
                                                    @if($balance < 0)
                                                    <td class="text-right">({{number_format(abs($balance))}})</td>
                                                    @else
                                                    <td class="text-right">{{$balance > 0 ? number_format($balance) : '-'}}</td>
                                                    @endif
                                                    
                                                </tr>
                                                
                                                @endforeach
                                                @endif
                                                <!-- <tr>
                                                    <td colspan="4" class="text-right"><b>Monthly Total</b></td>
                                                    <td class="text-right"><b>150000</b></td>
                                                    <td class="text-right"><b>200000</b></td>
                                                    <td class="text-right"><b>250000</b></td>
                                                </tr> -->
                                                <tr>
                                                    <td colspan="4" class="text-right"><b>Grand Total</b></td>
                                                    <td class="text-right"><u><b>{{$debit != 0 ? number_format($debit) : '-'}}</b></u></td>
                                                    <td class="text-right"><u><b>{{$credit != 0 ? number_format($credit) : '-'}}</b></u></td>
                                                    @if($balance < 0)
                                                    <td class="text-right"><u><b>({{number_format(abs($balance))}})</b></u></td>
                                                    @else
                                                    <td class="text-right"><u><b>{{$balance > 0? number_format($balance) : '-'}}</b></u></td>
                                                    @endif
                                                </tr>
                                            </tbody>
                                        </table>

                                       

                                    </div>

                        </div>
                    </div>
                

                </div>
                <!-- /.row -->

            </div>

 @permission('print-voucher')
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
        <button  class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        @endpermission

              </div>
            <!-- /.container-fluid -->

<input type="hidden" name="account_id" id="account_id" value="{{$account->id}}">


@stop

@section('js')


<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>

    $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

    $('#daterange-btn').daterangepicker(
        {
          

            ranges: {
                'Today': [moment(), moment()],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
          },
        
        );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });

     $('.update-report').on('click',function(){

        $('.preloader').fadeIn();
            
            date_range = $('#daterange-btn').val();
            account_id = $('#account_id').val();

            var data = {'date_range':date_range,'account_id':account_id};
            $.get('/update-control-account-detail',data,function(data){
                document.getElementById('update-report').innerHTML = data;

                $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    } );

                
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });
     
    </script>


@stop