@extends('layouts.app')

@section('title')
    Generate Reversal Voucher
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Vouchers</li>
    </ol>
@stop

@section('css')

    <link href="{{ asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <style type="text/css">
        .table>tbody>tr>td,
        .table>tbody>tr>th {
            font-size: 14px;
            text-align: left;
        }
    </style>
@endsection

@section('content')


    <div class="container-fluid">
        @can('isSuperAdmin')
        @include('partial.multiproject_forinsert')
        @endcan
        <!--.row-->
        <div class="row">
            <div class="col-md-12" style="padding:0px;">
                <div class="panel panel-info">
                    <div class="panel-heading">Make Reversal Voucher</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body">


                            <hr>
                            <form id="form-div">

                                {{ csrf_field() }}




                                <b>Voucher Type</b>

                                @if ($entries[0]->voucher_type == \App\GeneralJournalEntry::CPV)
                                    <input type="radio" checked="" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CRV }}"> CRV &nbsp;&nbsp;&nbsp;
                                @else
                                    <input type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::CRV }}">
                                    CRV &nbsp;&nbsp;&nbsp;
                                @endif

                                @if ($entries[0]->voucher_type == \App\GeneralJournalEntry::BPV)
                                    <input type="radio" checked="" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BRV }}"> BRV &nbsp;&nbsp;&nbsp;
                                @else
                                    <input type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::BRV }}">
                                    BRV &nbsp;&nbsp;&nbsp;
                                @endif

                                @if ($entries[0]->voucher_type == \App\GeneralJournalEntry::CRV)
                                    <input checked="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CPV }}"> CPV &nbsp;&nbsp;&nbsp;
                                @else
                                    <input type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::CPV }}">
                                    CPV &nbsp;&nbsp;&nbsp;
                                @endif

                                @if ($entries[0]->voucher_type == \App\GeneralJournalEntry::BRV)
                                    <input checked="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BPV }}"> BPV &nbsp;&nbsp;&nbsp;
                                @else
                                    <input type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::BPV }}">
                                    BPV &nbsp;&nbsp;&nbsp;
                                @endif

                                @if ($entries[0]->voucher_type == \App\GeneralJournalEntry::JV)
                                    <input type="radio" checked="" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::JV }}"> JV &nbsp;&nbsp;&nbsp;
                                @else
                                    <input type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::JV }}">
                                    JV &nbsp;&nbsp;&nbsp;
                                @endif






                                <br><br>
                                <input type="hidden" id="transaction_id" name="transaction_id"
                                    value="{{ $transaction_id }}">

                                <input type="hidden" id="transaction_type" name="transaction_type"
                                    value="{{ $transaction_type }}">
                                    <div class="row">
                                        <div class="col-md-4">
                                            Bank Name &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text"
                                                name="bank_name" id="bank_name">
    
                                        </div>
    
                                        <div class="col-md-4">
                                            Ins. # &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text"
                                                id="cheaque_no" name="cheaque_no">
    
                                        </div>
    
                                    </div>
                                    <br><br>
                                <div class="row">
                                    <div class="col-md-3">
                                        DATE &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="date"
                                            id="date" name="date" value="<?php echo date('Y-m-d'); ?>">

                                    </div>






                                    <div class="col-md-3">
                                        <input type="checkbox" style="background-color: #f7fafc;" checked=""
                                            name="adjusting_entry" id="adjusting_entry" value="1">
                                        &nbsp;&nbsp;ADJUSTING ENTRY
                                    </div>

                                    <br>

                                    <br> <br>

                                    <div class="col-md-12">
                                        <table class="table table-bordered table-responsive-md table-striped text-center">
                                            <thead>
                                                <tr>

                                                    <th class="text-center">ACCOUNT</th>
                                                    <th class="text-center">DEBIT</th>
                                                    <th class="text-center">CREDIT</th>

                                                    <th class="text-center">NAME</th>

                                                </tr>

                                            </thead>
                                            <tbody>

                                                @foreach ($entries as $entry)
                                                    <tr height="2px">

                                                        <td class="pt-3-half account" style="width: 40%"
                                                            contenteditable="true">
                                                            <select class="form-control chosen-select"
                                                                style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                                name="account[]">
                                                                <option value="0">None</option>
                                                                @foreach ($accounts as $a)
                                                                    @if ($entry->account_id == $a->id)
                                                                        @if ($a->sub_account_id)
                                                                            <option style="font-size: 11px;" selected=""
                                                                                value="{{ $a->id }}">
                                                                                &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                                {{ $a->name }}</option>
                                                                        @else
                                                                            <option selected="" style="font-size: 11px;"
                                                                                value="{{ $a->id }}">
                                                                                {{ $a->number }} - {{ $a->name }}
                                                                            </option>
                                                                        @endif
                                                                    @else
                                                                        @if ($a->sub_account_id)
                                                                            <option style="font-size: 11px;"
                                                                                value="{{ $a->id }}">
                                                                                &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                                {{ $a->name }}</option>
                                                                        @else
                                                                            <option style="font-size: 11px;"
                                                                                value="{{ $a->id }}">
                                                                                {{ $a->number }} - {{ $a->name }}
                                                                            </option>
                                                                        @endif
                                                                    @endif
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td class="pt-3-half debit" onkeyup="addDebit()"
                                                            contenteditable="true">
                                                            {{ $entry->amount < 0 ? abs($entry->amount) : 0 }}</td>
                                                        <td class="pt-3-half credit" onkeyup="addCredit()"
                                                            contenteditable="true">
                                                            {{ $entry->amount > 0 ? abs($entry->amount) : 0 }}</td>


                                                        <td class="pt-3-half name" contenteditable="true">
                                                            <select class="form-control chosen-select"
                                                                style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                                name="name1[]">
                                                                <option value="0">None</option>
                                                                @foreach ($names as $n)
                                                                    @if ($entry->name == $n->id)
                                                                        <option selected=""
                                                                            value="{{ $n->id }}">
                                                                            {{ $n->name }}</option>
                                                                    @endif
                                                                @endforeach
                                                            </select>
                                                        </td>





                                                    </tr>
                                                    <tr height="2px">
                                                        <td colspan="4"
                                                            style="text-align: center;width: 90%; padding-left:50px;padding-right:30px">
                                                            <input class="form-control" type="text"
                                                                name="line_narration[]" id="line_narration[]"
                                                                placeholder="Line Narration" value="{{ $entry->memo }}">
                                                        </td>
                                                    </tr>
                                                @endforeach





                                                <?php for($i =0 ; $i<5; $i++) {?>
                                                <tr height="2px">

                                                    <td class="pt-3-half account" style="width: 40%"
                                                        contenteditable="true">
                                                        <select class="form-control chosen-select"
                                                            style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                            name="account[]">
                                                            <option value="0">None</option>
                                                            @foreach ($accounts as $a)
                                                                @if ($a->sub_account_id)
                                                                    <option style="font-size: 11px;"
                                                                        value="{{ $a->id }}">
                                                                        &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                        {{ $a->name }}</option>
                                                                @else
                                                                    <option style="font-size: 11px;"
                                                                        value="{{ $a->id }}">{{ $a->number }} -
                                                                        {{ $a->name }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="pt-3-half debit" onkeyup="addDebit()"
                                                        contenteditable="true">0</td>
                                                    <td class="pt-3-half credit" onkeyup="addCredit()"
                                                        contenteditable="true">0</td>


                                                    <td class="pt-3-half name" contenteditable="true">
                                                        <select class="form-control chosen-select"
                                                            style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                            name="name1[]">
                                                            <option value="0">None</option>
                                                            @foreach ($names as $n)
                                                                <option style="font-size: 11px;"
                                                                    value="{{ $n->id }}">{{ $n->name }}
                                                                </option>
                                                            @endforeach

                                                        </select>
                                                    </td>
                                                </tr>
                                                <tr height="2px">
                                                    <td colspan="4"
                                                        style="text-align: center;width: 90%; padding-left:50px;padding-right:30px">
                                                        <input class="form-control" type="text" name="line_narration"
                                                            id="line_narration[]" placeholder="Line Narration">
                                                    </td>
                                                </tr>
                                                <?php } ?>


                                            </tbody>
                                        </table>
                                    </div>
                                    <table class="table">
                                        <tr>
                                            <th style="text-align: right;width: 37%;">Totals</th>
                                            <th style="text-align: center; width: 30%; font-size: 16px;font-weight: 600;"
                                                id="debit-total">0</th>
                                            <th style="text-align: center;width: 30%; font-size: 16px; font-weight: 600;"
                                                id="credit-total">0</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </table>

                                    <div class="col-md-4">
                                        Description : &nbsp;&nbsp;
                                        <textarea class="form-control" name="memo" id="memo"></textarea>
                                    </div>



                                    <div class="form-actions">
                                        <button style="float: right;margin-right: 20px;" type="button"
                                            class="btn btn-success search-customer  " id="search" disabled=""> <i
                                                class="fa fa-check"></i> Save </button>
                                    </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->




    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 50,
                'ordering': false,
            });

        });

        const year = new Date().getFullYear();

        const this_fiscal_year_start_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} + '-01');

        const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');

        const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} +
            '-01');

        const last_fiscal_year_end_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');




        $('#daterange-btn').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                        'month')],
                    'This Fiscal Year': [this_fiscal_year_start_date, this_fiscal_year_end_date],
                    'Last Fiscal Year': [last_fiscal_year_start_date, last_fiscal_year_end_date]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function(start, end) {
                $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }
        );

        // $('.update-record').on('click', function() {

        //     $('.preloader').fadeIn();

        //     date_range = $('#daterange-btn').val();
        //     account = $('#c_account').val();
        //     name = $('#c_name').val();


        //     var data = {
        //         'date_range': date_range,
        //         'account': account,
        //         'name': name
        //     };
        //     $.get('/general-journal-entries/update-entries', data, function(data) {
        //         document.getElementById('update-table').innerHTML = data;

        //         $('#myTable').DataTable({
        //             'paging': false,
        //             'searching': false,
        //             'info': true
        //         });
        //         toastr.success("Report updated.");
        //     });

        //     $('.preloader').fadeOut();
        // });

        function addDebit() {
            sum = 0;
            $('.debit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('debit-total').innerHTML = sum;
            checkTotal();
        }

        function addCredit() {
            sum = 0;
            $('.credit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('credit-total').innerHTML = sum;
            checkTotal();
        }

        function checkTotal() {

            debit = parseInt(document.getElementById('debit-total').innerHTML);
            credit = parseInt(document.getElementById('credit-total').innerHTML);
            if (debit == credit) {
                $("#search").prop("disabled", false);

                document.getElementById('debit-total').style.color = 'black';
                document.getElementById('credit-total').style.color = 'black';
                $("#update").prop("disabled", false);
            } else {
                $("#search").prop("disabled", true);

                document.getElementById('debit-total').style.color = 'red';
                document.getElementById('credit-total').style.color = 'red';
                $("#update").prop("disabled", false);
            }

        }

        // $('#search').click(function(){

        //     document.getElementById("search").disabled = true;

        //     date = $('#date').val();

        //     adjusting_entry = 0;
        //     if($('#adjusting_entry').prop("checked") == true){
        //         adjusting_entry = 1;   
        //     }
        //     account = [];
        //     $('select[name="account[]"]').each(function(){
        //         if($(this).val() != 0)
        //             account.push($(this).val());});
        //     name1 = [];
        //     $('select[name="name1[]"]').each(function(){
        //             name1.push($(this).val());});

        //     class_id = [];
        //     $('select[name="class_id[]"]').each(function(){
        //             class_id.push($(this).val());});

        //     debit = [];
        //     $('.debit').each(function(){
        //         if(this.innerHTML) {
        //             debit.push(parseInt(this.innerHTML));
        //         }
        //     });

        //     credit = [];
        //     $('.credit').each(function(){
        //         if(this.innerHTML) {
        //             credit.push(parseInt(this.innerHTML));
        //         }
        //     });

        //     memo = $('#memo').val();

        //     var line_narration = $("input[name='line_narration[]']")
        //           .map(function(){return $(this).val();}).get();

        //     voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();
        //     transaction_id = $('#transaction_id').val();
        //     transaction_type = $('#transaction_type').val();

        //     data = {'date':date,'adjusting_entry':adjusting_entry,'account':account,'debit':debit,'credit':credit,'memo':memo,'name':name1,'class_id':class_id,'voucher_type': voucher_type,'transaction_id' : transaction_id,'transaction_type' : transaction_type,'line_narration':line_narration};

        //     $.get('/general-journal-entries/create-voucher',data,function(data){

        //         toastr.success("Entry added successfully.");

        //        // window.location.reload('/general-journal-entries/voucher-detail/' + data.entry_no);

        //         window.location.href = '/general-journal-entries/voucher-detail/' + data.entry_no;



        //     });
        // });
        $('#search').click(function() {

            document.getElementById("search").disabled = true;

            date = $('#date').val();

            adjusting_entry = 0;
            if ($('#adjusting_entry').prop("checked") == true) {
                adjusting_entry = 1;
            }
            account = [];
            $('select[name="account[]"]').each(function() {
                if ($(this).val() != 0)
                    account.push($(this).val());

            });

            name1 = [];
            $('select[name="name1[]"]').each(function() {
                name1.push($(this).val());

            });

            class_id = [];
            $('select[name="class_id[]"]').each(function() {
                class_id.push($(this).val());

            });

            debit = [];
            $('.debit').each(function() {
                if (this.innerHTML) {
                    debit.push(parseInt(this.innerHTML));
                }
            });

            credit = [];
            $('.credit').each(function() {
                if (this.innerHTML) {
                    credit.push(parseInt(this.innerHTML));
                }
            });

            memo = $('#memo').val();

            var line_narration = $("input[name='line_narration[]']")
                .map(function() {
                    return $(this).val();
                }).get();

            voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

            if (!voucher_type) {
                alert('voucher type required.');

                return false;

            }

            transaction_id = $('#transaction_id').val();
            transaction_type = $('#transaction_type').val();

            bank_name = $('#bank_name').val();
            cheaque_no = $('#cheaque_no').val();
            multi_project_id = $('#multipro').val();

            document.getElementById("search").disabled = true;
            data = {
                "_token": "{{ csrf_token() }}",
                'date': date,
                'adjusting_entry': adjusting_entry,
                'account': account,
                'debit': debit,
                'credit': credit,
                'memo': memo,
                'name': name1,
                'class_id': class_id,
                'voucher_type': voucher_type,
                'transaction_id': transaction_id,
                'transaction_type': transaction_type,
                'bank_name': bank_name,
                'cheaque_no': cheaque_no,
                'line_narration': line_narration,
                'multipro_id':multi_project_id
            };

            
            $.post('/general-journal-entries/create-vouchers', data, function(data) {    
                if (data == 'date_error') {
                    toastr.error("Invalid date!");
                    document.getElementById("search").disabled = false;
                } else {
                    console.log(data);
                    if(data.success == false){
                        toastr.error(data.errors);
                    }
                    else{

                        toastr.success("Entry added successfully.");
                    window.location.href = '/general-journal-entries/voucher-detail/' + data.entry_no;
                }
            }

            });
        });

        addDebit();
        addCredit();
    </script>

@stop
