@extends('layouts.app')

@section('title')
    Generate Voucher
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Vouchers</li>
    </ol>
@stop

@section('css')

    <link href="{{ asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css') }}" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <style type="text/css">
        .h30 {
            /* height: 30px;*/
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            font-size: 14px;
            text-align: left;
        }
    </style>

@endsection

@section('content')


    <div class="container-fluid">

        <!--.row-->
        <div class="row">


            @if ($customer_tax_receipt)

                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Receipt Information</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Receipt #</td>
                                        <td>{{ $customer_tax_receipt->receipt_no }}</td>
                                    </tr>
                                    <tr>
                                        <td>Date</td>
                                        <td>{{ date('d-m-Y', strtotime($customer_tax_receipt->receipt_date)) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Customer</td>
                                        <td>{{ $customer_tax_receipt->customerPropertyTax->statement->receipt->customer->name }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Unit No.</td>
                                        <td> {{ $customer_tax_receipt->customerPropertyTax->statement->receipt->property->inventory->unit_number }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Payment Head</td>
                                        <td>
                                            @if ($customer_tax_receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::down_payment)
                                                Down Payment
                                            @elseif($customer_tax_receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::installment)
                                                Installment
                                            @elseif($customer_tax_receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::others)
                                                Others
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Payment Mode</td>
                                        @if ($customer_tax_receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                        @elseif($customer_tax_receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank transfer
                                                <br>
                                                <b>Depositor bank:</b>

                                                {{ $customer_tax_receipt->DepositorBank ? $customer_tax_receipt->DepositorBank->name : '' }}

                                                <br>
                                                <b>Company bank:</b>

                                                {{ $customer_tax_receipt->companyAccount ? $customer_tax_receipt->companyAccount->name : '' }}


                                            </td>
                                        @elseif($customer_tax_receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                        @elseif($customer_tax_receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                        @endif
                                    </tr>


                                    @if (
                                        $customer_tax_receipt->payment_method == \App\Receipt::cheque ||
                                            $customer_tax_receipt->payment_method == \App\Receipt::bank)
                                        <tr>
                                            <td>Instrument No </td>
                                            <td>{{ $customer_tax_receipt->instrument_no }}</td>
                                        </tr>
                                    @endif

                                    <tr>
                                        <td>Net Amount</td>
                                        @if ($customer_tax_receipt->tax_paid_by == \App\Receipt::company)
                                            <td>{{ number_format($customer_tax_receipt->receipt_amount) }}</td>
                                        @else
                                            <td>{{ number_format($customer_tax_receipt->receipt_amount) }}</td>
                                        @endif
                                    </tr>



                                    <tr>
                                        <td>Tax Payment Received</td>
                                        <td>
                                            @if ($customer_tax_receipt->customerPropertyTax->statement->receipt->tax_payment_received)
                                                YES
                                            @else
                                                NO
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Notes</td>
                                        <td>{{ $customer_tax_receipt->note }}</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            @endif


            @if ($receipt)

                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Receipt Information</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Receipt #</td>
                                        <td>{{ $receipt->receipt_no }}</td>
                                    </tr>
                                    <tr>
                                        <td>Date</td>
                                        <td>{{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Customer</td>
                                        <td>{{ $receipt->customer->name }} </td>
                                    </tr>
                                    <tr>
                                        <td>Unit No.</td>
                                        <td> {{ $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Payment Head</td>
                                        <td>
                                            @if ($receipt->payment_head == \App\Receipt::down_payment)
                                                Down Payment
                                            @elseif($receipt->payment_head == \App\Receipt::installment)
                                                Installment
                                            @elseif($receipt->payment_head == \App\Receipt::others)
                                                Others
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Payment Mode</td>
                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank transfer
                                                <br>
                                                <b>Depositor bank:</b>

                                                {{ $receipt->DepositorBank ? $receipt->DepositorBank->name : '' }}

                                                <br>
                                                <b>Company bank:</b>

                                                {{ $receipt->companyAccount ? $receipt->companyAccount->name : '' }}


                                            </td>
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                        @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                        @endif
                                    </tr>

                                    @if ($receipt->payment_method == \App\Receipt::cheque || $receipt->payment_method == \App\Receipt::bank)
                                        <tr>
                                            <td>Instrument No </td>
                                            <td>{{ $receipt->cheque_number }}</td>
                                        </tr>
                                    @endif

                                    <tr>
                                        <td>Gross Amount</td>
                                        <td>{{ number_format($receipt->amount) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Tax Amount</td>
                                        <td>
                                            @if ($receipt->tax_paid_by == \App\Receipt::company)
                                                {{ number_format($receipt->tax_amount) }}
                                            @else
                                                {{ number_format(0) }}
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Net Amount</td>
                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            <td>{{ number_format($receipt->amount + $receipt->tax_amount) }}</td>
                                        @else
                                            <td>{{ number_format($receipt->amount) }}</td>
                                        @endif
                                    </tr>

                                    <tr>
                                        <td>Tax Pay By</td>
                                        <td>
                                            @if ($receipt->tax_paid_by == \App\Receipt::customer)
                                                Customer
                                            @else
                                                Company
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Tax Payment Received</td>
                                        <td>
                                            @if ($receipt->tax_payment_received)
                                                YES
                                            @else
                                                NO
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Notes</td>
                                        <td>{{ $receipt->notes }}</td>
                                    </tr>


                                    @if ($receipt->payment_method == \App\Receipt::adjustment)
                                        <tr>
                                            <td>Adjustment Detail</td>
                                            <td>{{ $receipt->adjustment_detail }}</td>
                                        </tr>

                                        @if ($receipt->dealer_adjustment_unit_id)
                                            <tr>
                                                <td>Rebate Detail</td>
                                                <td>Adjust againt {{ $receipt->rebate->property->inventory->unit_number }}
                                                </td>
                                            </tr>
                                        @endif

                                    @endif



                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            @endif


            @if ($property)


                <div class="col-lg-12">
                    <div class="white-box">
                        <h4 class="box-title " style=" color: white; background-color:#1c3752;line-height: 30px">
                            &nbsp;&nbsp;Unit's Details</h4>

                        <div class="table-responsive pull-left">
                            <table class="table bottom-table">

                                <tbody>
                                    <tr>
                                        <td style="font-weight: 600;">Floor:</td>
                                        <td>
                                            @if ($property->inventory->floor)
                                                {{ $property->inventory->floor->name }}
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Category:</td>
                                        <td>
                                            @foreach ($property->inventory->categories as $c)
                                                @if ($loop->last)
                                                    {{ $c->category->name }} ({{ $c->category->percent }} )
                                                @else
                                                    {{ $c->category->name }} ({{ $c->category->percent }} ),
                                                @endif
                                            @endforeach
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Size:</td>
                                        <td>
                                            {{ $property->inventory->size->name }} {{ env('SIZE') }}
                                        </td>

                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Total Price:</td>
                                        <td> {{ number_format($property->inventory->total_price - $property->inventory->extra_amount) }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Net Amt.:</td>
                                        <td> {{ number_format($property->net_pay) }} </td>
                                    </tr>

                                    @if ($property->down_payment_note)
                                        <tr class="no-print">
                                            <td style="font-weight: 600;">Notes:</td>
                                            <td>{{ $property->down_payment_note }}</td>
                                        </tr>
                                    @endif
                                    <tr class="no-print">
                                        <td style="font-weight: 600;">Automatic Sms Alerts</td>
                                        @if ($property->sms_alert == true)
                                            <td>On</td>
                                        @else
                                            <td>Off</td>
                                        @endif
                                    </tr>
                                    <tr class="no-print">
                                        <td style="font-weight: 600;">Automatic Email Alerts</td>
                                        @if ($property->email_alert == true)
                                            <td>On</td>
                                        @else
                                            <td>Off</td>
                                        @endif
                                    </tr>






                                    <!-- <tr>
                                                <td>Discount:</td>
                                                <td> {{ $property->discount }} </td>
                                            </tr> -->

                                </tbody>
                            </table>
                        </div>
                        <div class="table-responsive pull-right">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td style="font-weight: 600;">Unit #:</td>
                                        <td>{{ $property->inventory->unit_number }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Unit Type:</td>
                                        <td>{{ $property->inventory->type->name }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Area:</td>
                                        <td>{{ $property->inventory->area }}</td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Discount:</td>
                                        <td> {{ $property->discount }} </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Category Cost:</td>
                                        <td> {{ number_format($property->inventory->extra_amount) }} </td>
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Booking Type : </td>
                                        @if ($property->booking_type == \App\CustomerProperty::normal)
                                            <td>Installment</td>
                                        @elseif($property->booking_type == \App\CustomerProperty::full_payment)
                                            <td>Full Payment</td>
                                        @endif
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Booking Date:</td>
                                        @if ($property->inventory->registration)
                                            @if ($property->inventory->registration->booking_date)
                                                <td> {{ date('d-m-Y', strtotime($property->inventory->registration->booking_date)) }}
                                                </td>
                                            @else
                                                <td> {{ date('d-m-Y', strtotime($property->booking_date)) }}</td>
                                            @endif
                                        @else
                                            <td> {{ date('d-m-Y', strtotime($property->booking_date)) }}</td>
                                        @endif
                                    </tr>
                                    <tr>
                                        <td style="font-weight: 600;">Schedule Start Date:</td>
                                        <td>
                                            @if ($property->schedule_start_date)
                                                {{ date('d-m-Y', strtotime($property->schedule_start_date)) }}
                                            @endif
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>

            @endif

            @if ($rebate)

                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Rebate Information</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Dealer</td>
                                        <td>{{ $rebate->dealer->name }}</td>
                                    </tr>

                                    <tr>
                                        <td>Unit #</td>
                                        <td>
                                            @if ($rebate->property)
                                                @if ($rebate->property->inventory)
                                                    {{ $rebate->property->inventory->unit_number }}
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Date</td>
                                        <td>{{ date('d-m-Y', strtotime($rebate->date)) }}</td>
                                    </tr>

                                    <tr>
                                        <td>Payment Mode</td>
                                        @if ($rebate->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                        @else
                                            <td>Bank transfer</td>
                                        @endif

                                    </tr>

                                    <tr>
                                        <td>Gross Amount</td>
                                        <td>{{ number_format($rebate->amount - $rebate->tax_amount) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Tax Amount</td>
                                        <td>{{ number_format($rebate->tax_amount) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Net Amount</td>
                                        <td>{{ number_format($rebate->amount) }}</td>
                                    </tr>

                                    <tr>
                                        <td>Description</td>
                                        <td>{{ $rebate->description }}</td>
                                    </tr>


                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>


            @endif

            @if ($pending_rebate)

                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Pending Rebate Information</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Dealer</td>
                                        <td>{{ $pending_rebate->dealer->name }}</td>
                                    </tr>

                                    <tr>
                                        <td>Unit #</td>
                                        <td>
                                            @if ($pending_rebate->property)
                                                @if ($pending_rebate->property->inventory)
                                                    {{ $pending_rebate->property->inventory->unit_number }}
                                                @endif
                                            @endif
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>Rebate </td>
                                        <td>{{ number_format($pending_rebate->amount) }}</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>


            @endif

            @if ($pending_refund)
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Pending Refund Information</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Project</td>
                                        <td> 
                                            {{$pending_refund->multiProject?$pending_refund->multiProject->name:'None'}}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Member Name</td>
                                        <td> 
                                            {{$pending_refund->customer?$pending_refund->customer->name:'None'}}
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Unit #</td>


                                        
                                        <td> 
                                            {{$pending_refund->property ?  $pending_refund->property->inventory ? $pending_refund->property->inventory->unit_number : '' : ''}}</td>

                                         
                                    </tr>

                                    
                                    <tr>
                                        <td>Total Refund </td>
                                        <td>{{ number_format($pending_refund->property->unitRefundHistory->total_refund) }} PKR</td>
                                    </tr>
                                    <tr>
                                        <td>Total Deduction </td>
                                        <td>{{number_format($pending_refund->amount)}}  PKR</td>
                                    </tr>
                                    
                                    <tr>
                                        <td> Date </td>
                                        <td>  {{date('d-m-Y', strtotime($pending_refund->receipt_date)) }}
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            @endif


            @if ($pending_open_file_package)
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Dealer Open File Package Buy Detail</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Receipt #</td>
                                        <td> {{ $pending_open_file_package->receipt_no }}</td>
                                    </tr>
                                    <tr>
                                        <td>Receipt Date</td>
                                        <td> {{ $pending_open_file_package->receipt_date }}</td>
                                    </tr>
                                    <tr>
                                        <td>Dealer Code</td>
                                        <td> {{ $pending_open_file_package->dealerPackage->dealer->code }}</td>
                                    </tr>
                                    <tr>
                                        <td>Dealer Name</td>
                                        <td> {{ $pending_open_file_package->dealerPackage->dealer->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>Package Name</td>
                                        <td> {{ $pending_open_file_package->dealerPackage->package->name }}</td>
                                    </tr>



                                    <tr>
                                        <td>Receipt Amount </td>
                                        <td>{{ $pending_open_file_package->amount }} pkr </td>
                                    </tr>




                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            @endif

            @if ($pending_refund_openfile)
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">Dealer Open File Unit Buy Detail</h3>
                        <hr>
                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Project</td>
                                        <td> 
                                            {{$pending_refund_openfile->multiProject?$pending_refund_openfile->multiProject->name:'None'}}
                                        </td>
                                        <td>Open File Inventory Number:</td>
                                        <td> 
                                            {{ $pending_refund_openfile->openFileDealerInfo->inventory->unit_number }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Dealer </td>
                                        <td>
                                            {{ $pending_refund_openfile->openFileDealerInfo->dealer->code }} ---
                                            {{ $pending_refund_openfile->openFileDealerInfo->dealer->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>Total Refund </td>
                                        <td>{{ number_format($pending_refund_openfile->openFileDealerInfo->cancelOpenFile->openFileRefunded->total_refund) }} PKR</td>
                                    </tr>
                                    <tr>
                                        <td>Total Deduction </td>
                                        <td>{{number_format($pending_refund_openfile->amount)}}  PKR</td>
                                    </tr>
                                    <tr>
                                        <td> Date </td>
                                        <td> {{ date('d-m-Y', strtotime($pending_refund_openfile->created_at)) }}</td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            @endif
            @if ($pending_cancel_closeunit)
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title"> Cancel Unit Detail</h3>
                    <hr>
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Project</td>
                                    <td> 
                                        {{$pending_cancel_closeunit->multiProject?$pending_cancel_closeunit->multiProject->name:'None'}}
                                    </td>
                                    
                                </tr>
                                <tr>
                                    <td>Unit Number:</td>
                                    <td> 
                                    {{ $pending_cancel_closeunit->property ? ($pending_cancel_closeunit->property->inventory ? $pending_cancel_closeunit->property->inventory->unit_number : '') : '' }}
                                          
                                    </td>
                                </tr>
                                <tr>
                                    <td>Payment Method:</td>
                                      
                                        @if ($pending_cancel_closeunit->payment_method == \App\Receipt::cash)
                                        <td>Cash</td>
                                    @elseif($pending_cancel_closeunit->payment_method == \App\Receipt::bank)
                                        <td>Bank</td>
                                    @elseif($pending_cancel_closeunit->payment_method == \App\Receipt::adjustment)
                                        <td>Adjustment</td>
                                    @elseif($pending_cancel_closeunit->payment_method == \App\Receipt::cheque)
                                        <td>Cheque</td>
                                    @elseif($pending_cancel_closeunit->payment_method == \App\Receipt::merging)
                                        <td>Merging</td>
                                    @else
                                        <td></td>
                                    @endif
                                     
                                </tr>

                                <tr>
                                    <td>Received Amount :</td>
                                      
                                    @if ($pending_cancel_closeunit->tax_paid_by == \App\Receipt::company)
                                    <td>{{ number_format($pending_cancel_closeunit->amount + $pending_cancel_closeunit->tax_amount) }} PKR</td>
                                @else
                                    <td>{{ number_format($pending_cancel_closeunit->amount) }} PKR</td>
                                @endif
                               
                                     
                               
                            </tr>
                            <tr>
                                <td>Date :</td>

                            <td> {{ date('d-m-Y', strtotime($pending_cancel_closeunit->receipt_date)) }}</td>
                            </tr>
                             <tr>
                                <td>Status :</td>
                                @if ($pending_cancel_closeunit->is_approved == true)
                                <td>
                                    <span class="label label-success">
                                        Approved
                                    </span>
                                </td>
                            @else
                                
                                    <td>
                                        <span class="label label-warning">
                                            Pending
                                        </span>
                                    </td>
                                @endif
                             </tr>
                                
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        @endif
        @if ($pending_cancel_openfile)
        <div class="col-sm-12">
            <div class="white-box">
                <h3 class="box-title"> Cancel Open Unit Detail</h3>
                <hr>
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td>Project</td>
                                <td> 
                                    {{$pending_cancel_openfile->multiProject?$pending_cancel_openfile->multiProject->name:'None'}}
                                </td>
                                
                            </tr>
                            <tr>
                                <td>Unit Number:</td>
                                
                                <td>{{ $pending_cancel_openfile->openFileDealerInfo ? ($pending_cancel_openfile->openFileDealerInfo->inventory ? $pending_cancel_openfile->openFileDealerInfo->inventory->unit_number : '') : '' }}
                                </td>

                            </tr>
                            <tr>
                                <td>Payment Method:</td>
                                  
                                @if ($pending_cancel_openfile->payment_method == \App\Receipt::cash)
                                <td>Cash</td>
                            @elseif($pending_cancel_openfile->payment_method == \App\Receipt::bank)
                                <td>Bank</td>
                            @elseif($pending_cancel_openfile->payment_method == \App\Receipt::adjustment)
                                <td>Adjustment</td>
                            @elseif($pending_cancel_openfile->payment_method == \App\Receipt::cheque)
                                <td>Cheque</td>
                            @elseif($pending_cancel_openfile->payment_method == \App\Receipt::merging)
                                <td>Merging</td>
                            @else
                                <td></td>
                            @endif
                                 
                            </tr>

                            <tr>
                                <td>Received Amount :</td>
                                  
                                @if ($pending_cancel_openfile->tax_paid_by == \App\Receipt::company)
                                <td>{{ number_format($pending_cancel_openfile->amount + $pending_cancel_openfile->tax_amount) }} PKR</td>
                            @else
                                <td>{{ number_format($pending_cancel_openfile->amount) }} PKR</td>
                            @endif
                           
                        </tr>
                        <tr>
                            <td>Date :</td>

                            <td> {{ date('d-m-Y', strtotime($pending_cancel_openfile->receipt_date)) }}</td>
                                                  
                        </tr>
                         <tr>
                            <td>Status :</td>
                            @if ($pending_cancel_openfile->is_approved == true)
                            <td>
                                <span class="label label-success">
                                    Approved
                                </span>
                            </td>
                        @else
                            
                                <td>
                                    <span class="label label-warning">
                                        Pending
                                    </span>
                                </td>
                            @endif
                         </tr>
                            
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    @endif



            <div class="col-md-12" style="padding:0px;">
                <div class="panel panel-info">
                    <div class="panel-heading">Make Voucher</div>
                  
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        @can('isSuperAdmin')
                        @include('partial.multiproject_forinsert')
                        @endcan
                        <div class="panel-body" style="    margin-bottom: 36px;">


                            <hr>
                            <form id="form-div">

                                {{ csrf_field() }}

                                @if ($transaction_type == \App\GeneralJournalEntry::booking)
                                    <b>Voucher Type</b> &nbsp;&nbsp;&nbsp;<input disabled="" type="radio"
                                        name="voucher_type" value="{{ \App\GeneralJournalEntry::BPV }}" required=""> BPV
                                    &nbsp;&nbsp;&nbsp; <input disabled="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CPV }}" required=""> CPV &nbsp;&nbsp;&nbsp;
                                    <input disabled="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BRV }}" required=""> BRV &nbsp;&nbsp;&nbsp;
                                    <input disabled="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CRV }}" required=""> CRV
                                    &nbsp;&nbsp;&nbsp;
                                    <input type="radio" checked="" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::JV }}" required=""> JV &nbsp;&nbsp;&nbsp;
                                @elseif($transaction_type == \App\GeneralJournalEntry::receipt)
                                    <b>Voucher Type</b> &nbsp;&nbsp;&nbsp;<input disabled="" type="radio"
                                        name="voucher_type" value="{{ \App\GeneralJournalEntry::BPV }}"> BPV
                                    &nbsp;&nbsp;&nbsp; <input disabled="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CPV }}"> CPV &nbsp;&nbsp;&nbsp; <input
                                        type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::BRV }}">
                                    BRV &nbsp;&nbsp;&nbsp; <input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::CRV }}"> CRV &nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::JV }}"> JV &nbsp;&nbsp;&nbsp;
                                @elseif(
                                    $transaction_type == \App\GeneralJournalEntry::bill ||
                                        $transaction_type == \App\GeneralJournalEntry::payment ||
                                        $transaction_type == \App\GeneralJournalEntry::massPayment)
                                    <b>Voucher Type</b> &nbsp;&nbsp;&nbsp;<input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BPV }}"> BPV &nbsp;&nbsp;&nbsp; <input
                                        type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::CPV }}">
                                    CPV &nbsp;&nbsp;&nbsp; <input disabled="" type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BRV }}"> BRV &nbsp;&nbsp;&nbsp; <input
                                        type="radio" name="voucher_type" disabled=""
                                        value="{{ \App\GeneralJournalEntry::CRV }}"> CRV &nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::JV }}"> JV &nbsp;&nbsp;&nbsp;
                                @else
                                    <b>Voucher Type</b> &nbsp;&nbsp;&nbsp;<input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BPV }}"> BPV &nbsp;&nbsp;&nbsp;<input
                                        type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::CPV }}">
                                    CPV &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; <input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::BRV }}"> BRV &nbsp;&nbsp;&nbsp; <input
                                        type="radio" name="voucher_type" value="{{ \App\GeneralJournalEntry::CRV }}">
                                    CRV &nbsp;&nbsp;&nbsp; <input type="radio" name="voucher_type"
                                        value="{{ \App\GeneralJournalEntry::JV }}"> JV &nbsp;&nbsp;&nbsp;
                                @endif


                                <br><br>
                                <input type="hidden" id="transaction_id" name="transaction_id"
                                    value="{{ $transaction_id }}">

                                <input type="hidden" id="transaction_type" name="transaction_type"
                                    value="{{ $transaction_type }}">

                                
                                <br><br>
                                <div class="row">

                                    <div class="col-md-4">
                                        Bank Name &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text"
                                            name="bank_name" id="bank_name">

                                    </div>

                                    <div class="col-md-4">
                                        Ins. # &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="text"
                                            id="cheaque_no" name="cheaque_no">

                                    </div>

                                </div>

                                <br><br>

                                <div class="row">
                                    <div class="col-md-3">
                                        DATE &nbsp;&nbsp;<input style="background-color: #f7fafc;" type="date"
                                            id="date" name="date" value="<?php echo date('Y-m-d'); ?>">

                                    </div>






                                    <div class="col-md-3">
                                        <input type="checkbox" style="background-color: #f7fafc;" name="adjusting_entry"
                                            id="adjusting_entry" value="1"> &nbsp;&nbsp;ADJUSTING ENTRY
                                    </div>

                                    <br>

                                    <br> <br>

                                    <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                        <table class="table table-bordered table-responsive-md table-striped text-center">
                                            <thead>
                                                <tr>

                                                    <th class="text-center">ACCOUNT</th>
                                                    <th class="text-center">DEBIT</th>
                                                    <th class="text-center">CREDIT</th>

                                                    <th class="text-center">NAME</th>


                                                </tr>

                                            </thead>
                                            <tbody id="tbody_data">
                                                <?php for($i =0 ; $i<10; $i++) {?>
                                                <tr height="2px" id="account_tr_{{ $i }}"
                                                    data-id="{{ $i }}">

                                                    <td class="pt-3-half account" style="width: 40%"
                                                        contenteditable="true">


                                                        <select class="form-control chosen-select us_acnt"
                                                            style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                            name="account[]">
                                                            <option value="0">None</option>
                                                            @foreach ($accounts as $a)
                                                                @if ($leafAccount[$a->id])
                                                                    @if ($a->sub_account_id)
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}">
                                                                            &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                            {{ $a->name }}</option>
                                                                    @else
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}">
                                                                            {{ $a->number }} - {{ $a->name }}
                                                                        </option>
                                                                    @endif
                                                                @else
                                                                    @if ($a->sub_account_id)
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}" disabled="">
                                                                            &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                            {{ $a->name }}</option>
                                                                    @else
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}" disabled="">
                                                                            {{ $a->number }} - {{ $a->name }}
                                                                        </option>
                                                                    @endif
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="pt-3-half debit" onfocusout="return setZeroBydefault(this)"
                                                        onkeyup="addDebit(this)" contenteditable="true">0</td>
                                                    <td class="pt-3-half credit"
                                                        onfocusout="return setZeroBydefault(this)"
                                                        onkeyup="addCredit(this)" contenteditable="true">0</td>


                                                    <td class="pt-3-half name" contenteditable="true">
                                                        <select class="form-control chosen-select"
                                                            style="    width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                            name="name1[]">
                                                            <option value="0">None</option>
                                                            @foreach ($names as $n)
                                                                <option style="font-size: 11px;"
                                                                    value="{{ $n->id }}">{{ $n->name }}
                                                                </option>
                                                            @endforeach

                                                        </select>
                                                    </td>

                                                    <td class="pt-3-half name">
                                                        <button type="button"
                                                            class="btn btn-sm btn-success btn-sm addRowBtn"
                                                            data-id="{{ $i }}" onclick="addNewRow(this)"><i
                                                                class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                            onclick="removeParentDiv(this)"><i
                                                                class="fa fa-times"></i></button>
                                                    </td>

                                                </tr>

                                                <tr id="narration_tr_{{ $i }}"
                                                    class="tr_{{ $i }}">
                                                    <td colspan="4"
                                                        style="text-align: center;width: 90%; padding-left:50px;padding-right:30px">
                                                        <input class="form-control h30" type="text"
                                                            name="line_narration[]" id="line_narration[]"
                                                            placeholder="Line Narration">
                                                    </td>
                                                </tr>

                                                <?php } ?>



                                                <tr height="2px" id="account_tr_{{ $i + 1 }}"
                                                    data-id="{{ $i + 1 }}" style="display:none;">

                                                    <td class="pt-3-half account" style="width: 40%"
                                                        contenteditable="true">


                                                        <select class="form-control chosen-select us_acnt"
                                                            style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                            name="account[]">
                                                            <option value="0">None</option>
                                                            @foreach ($accounts as $a)
                                                                @if ($leafAccount[$a->id])
                                                                    @if ($a->sub_account_id)
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}">
                                                                            &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                            {{ $a->name }}</option>
                                                                    @else
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}">
                                                                            {{ $a->number }} - {{ $a->name }}
                                                                        </option>
                                                                    @endif
                                                                @else
                                                                    @if ($a->sub_account_id)
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}" disabled="">
                                                                            &nbsp;&nbsp;&nbsp;{{ $a->number }} -
                                                                            {{ $a->name }}</option>
                                                                    @else
                                                                        <option style="font-size: 11px;"
                                                                            value="{{ $a->id }}" disabled="">
                                                                            {{ $a->number }} - {{ $a->name }}
                                                                        </option>
                                                                    @endif
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="pt-3-half debit" onfocusout="return setZeroBydefault(this)"
                                                        onkeyup="addDebit(this)" contenteditable="true"></td>
                                                    <td class="pt-3-half credit"
                                                        onfocusout="return setZeroBydefault(this)"
                                                        onkeyup="addCredit(this)" contenteditable="true"></td>


                                                    <td class="pt-3-half name" contenteditable="true">
                                                        <select class="form-control chosen-select name1"
                                                            style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;">
                                                            <option value="0">None</option>
                                                            @foreach ($names as $n)
                                                                <option style="font-size: 11px;"
                                                                    value="{{ $n->id }}">{{ $n->name }}
                                                                </option>
                                                            @endforeach

                                                        </select>
                                                    </td>

                                                    <td class="pt-3-half name">
                                                        <button type="button"
                                                            class="btn btn-sm btn-success btn-sm  addRowBtn"
                                                            onclick="addNewRow(this)"><i class="fa fa-plus"></i></button>
                                                        <button type="button" class="btn btn-sm btn-danger btn-sm"
                                                            onclick="removeParentDiv(this)"><i
                                                                class="fa fa-times"></i></button>
                                                    </td>

                                                </tr>

                                                <tr id="narration_tr_{{ $i + 1 }}" style="display:none;">
                                                    <td colspan="4"
                                                        style="text-align: center;width: 90%; padding-left:50px;padding-right:30px">
                                                        <input class="form-control h30 line_narration" type="text"
                                                            id="line_narration[]" placeholder="Line Narration">
                                                    </td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>
                                    <table class="table">
                                        <tr>
                                            <th style="text-align: right;width: 41%;">Totals</th>
                                            <th style="text-align: center; width: 17%; font-size: 16px;font-weight: 600;"
                                                id="debit-total">0</th>
                                            <th style="text-align: center;width: 16%; font-size: 16px; font-weight: 600;"
                                                id="credit-total">0</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </table>

                                    <div class="col-md-4">
                                        Narration : &nbsp;&nbsp;
                                        <textarea class="form-control" name="memo" id="memo"></textarea>
                                    </div>



                                    <div class="form-actions">

                                        <button style="float: right;margin-right: 20px;" type="button"
                                            class="btn btn-success search-customer" id="search" disabled=""> <i
                                                class="fa fa-check"></i> Save </button>

                                        <!--<button style="float: right;margin-right: 20px;" type="button" class="btn btn-info" onclick="return addNewRow(this)"> <i class="fa fa-plus" ></i> Add </button>-->


                                    </div>
                            </form>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->




    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        function removeParentDiv(self) {
            var id = $(self).closest('tr').data("id");

            $('#account_tr_' + id).remove()
            $('#narration_tr_' + id).remove()
        }

        $('.us_acnt').on('change', function() {

            if (($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit').html() >
                    0) && $(this).val() == 0) {
                $("#search").prop("disabled", true);
            } else if (($(this).closest('tr').find('.debit').html() > 0 || $(this).closest('tr').find('.credit')
                    .html() > 0) && $(this).val() > 0) {
                $("#search").prop("disabled", false);
            }


            if (($('#debit-total').html() > 0 && $('#credit-total').html() > 0) && ($('#credit-total').html() != $(
                    '#debit-total').html())) {
                $("#search").prop("disabled", true);
            }


        });




        function addNewRow(self) {
            $(".chosen-select").chosen("destroy");

            var narration_row = $('#narration_tr_{{ $i + 1 }}').html();
            var account_row = $('#account_tr_{{ $i + 1 }}').html();
            var rand_id = Math.floor(Math.random() * 100);
            var tr_id = $(self).data("id");

            $('.tr_' + tr_id).after('<tr  id="account_tr_' + rand_id + '"  data-id="' + rand_id + '" >' + account_row +
                '</tr> <tr id="narration_tr_' + rand_id + '"   class="tr_' + rand_id + '">' + narration_row + '</tr>');
            $("#account_tr_" + rand_id).find('.debit').text(0)
            $("#account_tr_" + rand_id).find('.credit').text(0)
            $("#account_tr_" + rand_id).find('.name1').attr('name', 'name1[]');
            $("#account_tr_" + rand_id).find('.addRowBtn').data('id', rand_id);
            $("#narration_tr_" + rand_id).find('.line_narration').attr('name', 'line_narration[]');

            $("#narration_tr_" + rand_id).show();
            $("#account_tr_" + rand_id).show();

            $(".chosen-select").chosen();

            return false;
        }

        $(function() {
            $('#myTable').DataTable({
                'pageLength': 50,
                'ordering': false,
            });
        });

        function setZeroBydefault(self) {
            if ($(self).text().length == 0) {
                $(self).text('0');
            }
        }

        const year = new Date().getFullYear();

        const this_fiscal_year_start_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} + '-01');

        const this_fiscal_year_end_date = new Date((year + 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');

        const last_fiscal_year_start_date = new Date((year - 1) + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_START }} +
            '-01');

        const last_fiscal_year_end_date = new Date(year + '-' + {{ \App\ChartOfAccount::FISCAL_YEAR_END }} + '-30');




        $('#daterange-btn').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf(
                        'month')],
                    'This Fiscal Year': [this_fiscal_year_start_date, this_fiscal_year_end_date],
                    'Last Fiscal Year': [last_fiscal_year_start_date, last_fiscal_year_end_date]
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            },
            function(start, end) {
                $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            }
        );

        $('.update-record').on('click', function() {

            $('.preloader').fadeIn();

            date_range = $('#daterange-btn').val();
            account = $('#c_account').val();
            name = $('#c_name').val();


            var data = {
                'date_range': date_range,
                'account': account,
                'name': name
            };
            $.get('/general-journal-entries/update-entries', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'paging': false,
                    'searching': false,
                    'info': true
                });
                toastr.success("Report updated.");
            });

            $('.preloader').fadeOut();
        });


        window.setInterval(function() {

            $('.debit').each(function() {
                if (this.innerHTML === "") {
                    this.innerHTML = 0;
                }
            });


            $('.credit').each(function() {
                if (this.innerHTML === "") {
                    this.innerHTML = 0;
                }
            });


            $('.line_narration').each(function() {
                if (!$(this).attr("name")) {
                    $(this).attr('name', 'line_narration[]')
                }
            });


            $('.name1').each(function() {
                if (!$(this).attr("name")) {
                    $(this).attr('name', 'name1[]')
                }
            });


            $('#account_tr_{{ $i + 1 }}').find('.name1').removeAttr('name', 'name1[]');
            $('#narration_tr_{{ $i + 1 }}').find('.line_narration').removeAttr('name', 'line_narration[]');


        }, 1000);

        function addDebit() {
            sum = 0;
            $response = 1;
            $('.debit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('debit-total').innerHTML = sum;
            if ($(self).closest('tr').find('.us_acnt').val() == 0) {
                $response = 0;
            }


            if ($response == 1) {
                checkTotal();
            } else {
                $("#search").prop("disabled", true);
            }
        }

        function addCredit() {
            sum = 0;
            $response = 1;
            $('.credit').each(function() {
                if (this.innerHTML) {
                    sum += parseInt(this.innerHTML);
                }
            });
            document.getElementById('credit-total').innerHTML = sum;

            if ($(self).closest('tr').find('.us_acnt').val() == 0) {
                $response = 0;
            }


            if ($response == 1) {
                checkTotal();
            } else {
                $("#search").prop("disabled", true);
            }
        }

        function checkTotal() {

            debit = parseInt(document.getElementById('debit-total').innerHTML);
            credit = parseInt(document.getElementById('credit-total').innerHTML);
            if (debit == credit) {
                $("#search").prop("disabled", false);

                document.getElementById('debit-total').style.color = 'black';
                document.getElementById('credit-total').style.color = 'black';
                $("#update").prop("disabled", false);
            } else {
                $("#search").prop("disabled", true);

                document.getElementById('debit-total').style.color = 'red';
                document.getElementById('credit-total').style.color = 'red';
                $("#update").prop("disabled", false);
            }

        }

        $('#search').click(function() {

            document.getElementById("search").disabled = true;

            date = $('#date').val();

            adjusting_entry = 0;
            if ($('#adjusting_entry').prop("checked") == true) {
                adjusting_entry = 1;
            }
            account = [];
            $('select[name="account[]"]').each(function() {
                if ($(this).val() != 0)
                    account.push($(this).val());

            });

            name1 = [];
            $('select[name="name1[]"]').each(function() {
                name1.push($(this).val());

            });

            class_id = [];
            $('select[name="class_id[]"]').each(function() {
                class_id.push($(this).val());

            });

            debit = [];
            $('.debit').each(function() {
                if (this.innerHTML) {
                    debit.push(parseInt(this.innerHTML));
                }
            });

            credit = [];
            $('.credit').each(function() {
                if (this.innerHTML) {
                    credit.push(parseInt(this.innerHTML));
                }
            });

            memo = $('#memo').val();

            var line_narration = $("input[name='line_narration[]']")
                .map(function() {
                    return $(this).val();
                }).get();

            voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

            if (!voucher_type) {
               
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Voucher type required!',
                   
                })
                document.getElementById("search").disabled = false;

                return false;

            }

            transaction_id = $('#transaction_id').val();
            transaction_type = $('#transaction_type').val();

            bank_name = $('#bank_name').val();
            cheaque_no = $('#cheaque_no').val();
            multi_project_id = $('#multipro').val();
            // if (!multi_project_id) {
            //     Swal.fire({
            //         icon: 'error',
            //         title: 'Oops...',
            //         text: 'Please Select Project first!',
                   
            //     })

            //     return false;

            // }

            data = {
                "_token": "{{ csrf_token() }}",
                'date': date,
                'adjusting_entry': adjusting_entry,
                'account': account,
                'debit': debit,
                'credit': credit,
                'memo': memo,
                'name': name1,
                'class_id': class_id,
                'voucher_type': voucher_type,
                'transaction_id': transaction_id,
                'transaction_type': transaction_type,
                'bank_name': bank_name,
                'cheaque_no': cheaque_no,
                'line_narration': line_narration,
                'multipro_id':multi_project_id
            };

           
            $.post('/general-journal-entries/create-vouchers', data)
    .done(function(data) {
        // Success callback function
        if(data.success == false){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: "Please Select Project first",
                   
                });
                document.getElementById("search").disabled = false;

                }
                else{
if (data == 'date_error') {
                    toastr.error("Invalid date!");
                    document.getElementById("search").disabled = false;
                } else {

                    toastr.success("Entry added successfully.");

                    window.location.href = '/general-journal-entries/voucher-detail/' + data.entry_no;
                }
                }

               

                
    })
    .fail(function(jqXHR, textStatus, errorThrown) {
        // Error callback function
        
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'An error occurred:',
            });
        
    });

        });
        // $('#search').click(function() {

        //     document.getElementById("search").disabled = true;

        //     date = $('#date').val();
        //     var documents = $('#documents').prop('files').length;


        //     adjusting_entry = 0;
        //     if ($('#adjusting_entry').prop("checked") == true) {
        //         adjusting_entry = 1;
        //     }
        //     account = [];
        //     $('select[name="account[]"]').each(function() {
        //         if ($(this).val() != 0)
        //             account.push($(this).val());
        //     });
        //     name1 = [];
        //     $('select[name="name1[]"]').each(function() {
        //         name1.push($(this).val());
        //     });

        //     class_id = [];
        //     $('select[name="class_id[]"]').each(function() {
        //         class_id.push($(this).val());
        //     });

        //     debit = [];
        //     $('.debit').each(function() {
        //         if (this.innerHTML) {
        //             debit.push(parseInt(this.innerHTML));
        //         }
        //     });

        //     credit = [];
        //     $('.credit').each(function() {
        //         if (this.innerHTML) {
        //             credit.push(parseInt(this.innerHTML));
        //         }
        //     });

        //     memo = $('#memo').val();

        //     var line_narration = $("input[name='line_narration[]']")
        //         .map(function() {
        //             return $(this).val();
        //         }).get();

        //     voucher_type = $("input[type='radio'][name='voucher_type']:checked").val();

        //     if (!voucher_type) {
        //         alert('voucher type required.');
        //         document.getElementById("search").disabled = false;
        //         return false;
        //     }

        //     transaction_id = $('#transaction_id').val();
        //     transaction_type = $('#transaction_type').val();
        //     bank_name = $('#bank_name').val();
        //     cheaque_no = $('#cheaque_no').val();


        //     var formData = new FormData($('#form-div')[0]);

        //     for (var i = 0; i < documents; i++) {
        //         formData.append(i, $('#documents').prop('files')[i]);
        //     }

        //     formData.append('date', date);
        //     formData.append('adjusting_entry', adjusting_entry);
        //     formData.append('account', account);
        //     formData.append('debit', debit);
        //     formData.append('credit', credit);
        //     formData.append('memo', memo);
        //     formData.append('name', name1);
        //     formData.append('class_id', class_id);
        //     formData.append('voucher_type', voucher_type);
        //     formData.append('transaction_id', transaction_id);
        //     formData.append('transaction_type', transaction_type);
        //     formData.append('bank_name', bank_name);
        //     formData.append('line_narration', line_narration);
        //     formData.append('cheaque_no', cheaque_no);
        //     formData.append('file_length', documents);


        //     $.ajax({
        //         type: 'POST',
        //         url: '/general-journal-entries/create-vouchers',
        //         cache: false,
        //         processData: false,
        //         contentType: false,
        //         data: formData,
        //         success: function(data) {
        //             if (data == 'date_error') {
        //                 toastr.error("Invalid date!");
        //                 document.getElementById("search").disabled = false;
        //             } else if (data == 'invalid_document') {
        //                 toastr.error("Invalid Document Type");
        //                 document.getElementById("search").disabled = false;
        //             } else {

        //                 toastr.success("Entry added successfully.");

        //                 window.location.href = '/general-journal-entries/voucher-detail/' + data
        //                     .entry_no;
        //             }
        //         }
        //     });

        // });
    </script>

@stop
