@extends('layouts.app')

@section('title')
    Customer Vouchers
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Customer Vouchers</li>
    </ol>
@stop


@section('content')


    <div class="container-fluid">


        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">

                <div class="white-box">
                    <h3 class="box-title">Customers</h3>

                    <!-- Nav tabs -->
                    <ul class="nav customtab nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                        class="ti-home"></i></span><span class="hidden-xs">List</span></a></li>
                        <!-- <li role="presentation" class=""><a href="#home1" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs">Pending Bookings @if (count($allStatements) > 0)
    )<span class="label label-rounded pull-right" style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($allStatements) }}</span>
    @endif
        </span>
        </a></li> -->
                        <li role="presentation" class=""><a href="#profile1" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Receipts @if (count($receipts) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($receipts) }}</span>
                                    @endif
                                </span>
                            </a></li>
                        <li role="presentation" class=""><a href="#profile3" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Customer Tax Pending Receipts
                                    @if (count($customer_tax_receipts) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($customer_tax_receipts) }}</span>
                                    @endif
                                </span>
                            </a></li>
                        <li role="presentation" class=""><a href="#cancelreceipt" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Cancel Receipt
                                    @if (count($cancel_receipts) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($cancel_receipts) }}</span>
                                    @endif
                                </span></a></li>
                        <li role="presentation" class=""><a href="#profile4" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Refunded Receipt
                                    @if (count($refund_properties) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($refund_properties) }}</span>
                                    @endif
                                </span></a></li>

                        <li role="presentation" class=""><a href="#profile2" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Vouchers</span></a></li>


                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">

                        <div role="tabpanel" class="tab-pane fade active in" id="home">
                            <div class="table-responsive">

                                <a href="{{ route('control-account.addView', ['id' => \App\ControlAccount::CUSTOMER]) }}"
                                    target="_blank" class="btn btn-default pull-right"> Add New </a>
                                <br>
                                <br>
                                <div class="clearfix"></div>
                                <table id="myTable8" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>

                                            <th>Name</th>
                                            <th>Description</th>
                                            <th>balance</th>


                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>


                                        @foreach ($list as $l)
                                            <tr>
                                                <td>{{ $count++ }}</td>
                                                <td>
                                                    {{ $l->name }}


                                                </td>

                                                <td>{{ $l->description }}</td>
                                                <td>
                                                    @if ($balance[$l->id] < 0)
                                                        ({{ number_format(abs($balance[$l->id])) }})
                                                    @elseif($balance[$l->id] > 0)
                                                        {{ number_format($balance[$l->id]) }}
                                                    @else
                                                        -
                                                    @endif
                                                </td>


                                                <td class="text-nowrap">

                                                    <a href="{{ route('control-account.detail', ['id' => $l->id]) }}"
                                                        target="_blank" class="btn btn-default"> View </a>


                                                    <a href="{{ route('control-account.editView', ['id' => $l->id]) }}"
                                                        target="_blank" class="btn btn-default"> Edit</a>



                                                </td>

                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>


                        <div role="tabpanel" class="tab-pane fade" id="home1">
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>

                                            <th>Registration #</th>
                                            <th>Unit #</th>
                                            <th>Size</th>
                                            <th>Member Name</th>
                                            <th>Net Amount</th>



                                            <th>Booking Date</th>

                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>


                                        @foreach ($allStatements as $statement)
                                            <tr>
                                                <td>{{ $count++ }}</td>
                                                <td>
                                                    <a href="{{ route('statement.detail', ['id' => $statement->id]) }}">
                                                        {{ $statement->membership_no }}
                                                    </a>

                                                </td>

                                                <td>{{ $statement->inventory->unit_number }}</td>
                                                <td>
                                                    @if ($statement->inventory)
                                                        @if ($statement->inventory->size)
                                                            {{ $statement->inventory->size->name }} {{ env('SIZE') }}
                                                        @endif
                                                    @endif
                                                </td>
                                                <td>{{ $statement->customer ? $statement->customer->name : '' }}<br><b>Dealer:
                                                    </b>{{ $statement->dealer ? $statement->dealer->name : '' }}</td>

                                                <td><b>{{ number_format($statement->net_pay) }}</b></td>

                                                <td>{{ date('d-m-Y', strtotime($statement->booking_date)) }}</td>

                                                <td class="text-nowrap">

                                                    @permission('create-voucher')
                                                        <a href="{{ route('statement.detail', ['id' => $statement->id]) }}"
                                                            target="_blank" class="btn btn-default"> View </a>
                                                        <a href="#" onclick="$('#voucher-form').submit()"
                                                            class="btn btn-primary"> Make JV</a>
                                                    @endpermission

                                                    <form id="voucher-form" method="post"
                                                        action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::booking }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $statement->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::CUSTOMER }}">

                                                    </form>




                                                </td>

                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="profile3">
                            <div class="table-responsive">
                                <table id="myTable6" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>



                                        @foreach ($customer_tax_receipts as $receipt)
                                            <tr>
                                                <td>{{ $receipt->receipt_no }}</td>


                                                <td>{{ $receipt->customerPropertyTax->statement->receipt->customer->name }}
                                                </td>





                                                @if ($receipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($receipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @else
                                                    <td></td>
                                                @endif


                                                @if ($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::down_payment)
                                                    <td class="printFV">Down Payment</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::possession)
                                                    <td class="printFV">Possession Fee</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::installment)
                                                    <td class="printFV">Installment </td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::other)
                                                    <td class="printFV">Other</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::allotment)
                                                    <td class="printFV">Allotment</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::confirmation)
                                                    <td class="printFV">Confirmation</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::booking)
                                                    <td class="printFV">Booking</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::development)
                                                    <td class="printFV">Development</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::file_processing)
                                                    <td class="printFV">File Processing</td>
                                                @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\CustomerStatement::registration)
                                                    <td class="printFV">Registration</td>
                                                @else
                                                    <td class="printFV"></td>
                                                @endif



                                                <td>{{ number_format($receipt->receipt_amount) }} PKR</td>


                                                <td> {{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>

                                                <td class="text-nowrap">

                                                    <a href="{{ route('pending-customer-tax-receipts.detail', ['id' => $receipt->id]) }}"
                                                        class="btn btn-default">View</a>

                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>


                        <div role="tabpanel" class="tab-pane fade" id="cancelreceipt">
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Project</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
        
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
        
        
        
                                        @foreach ($cancel_receipts as $c_receipt)
                                            <tr>
                                                <td>{{ $c_receipt->receipt_no }}</td>
                                                <td>{{ $c_receipt->multiProject ? $c_receipt->multiProject->name : 'None' }}</td>
        
                                                <td>{{ $c_receipt->property ? ($c_receipt->property->inventory ? $c_receipt->property->inventory->unit_number : '') : '' }}
                                                </td>
        
        
                                                @if ($c_receipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($c_receipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($c_receipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @elseif($c_receipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                @elseif($c_receipt->payment_method == \App\Receipt::merging)
                                                    <td>Merging</td>
                                                @else
                                                    <td></td>
                                                @endif
        
        
        
        
        
                                                @if ($c_receipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{ number_format($c_receipt->amount + $c_receipt->tax_amount) }} PKR</td>
                                                @else
                                                    <td>{{ number_format($c_receipt->amount) }} PKR</td>
                                                @endif
                                                <td> {{ date('d-m-Y', strtotime($c_receipt->receipt_date)) }}</td>
                                             
                                             
    
    
    
    
                                               
                                                @if ($c_receipt->is_approved == true)
                                                    <td>
                                                        <span class="label label-success">
                                                            Approved
                                                        </span>
                                                    </td>
                                                @else
                                                    
                                                        <td>
                                                            <span class="label label-warning">
                                                                Pending
                                                            </span>
                                                        </td>
                                                    @endif
                                              
    
    
                                             
                                                    <td class="text-nowrap">

                                                    
                                                        @permission('create-voucher')
                                                            <a onclick="$('#voucher-cancel-form{{ $c_receipt->id }}').submit()"
                                                                href="#"><button class="btn btn-default btn-outline"
                                                                    type="button"> <span><i class="fa fa-money "></i> Make
                                                                        JV</span> </button></a>
                                                        @endpermission
    
    
    
                                                        <form id="voucher-cancel-form{{ $c_receipt->id }}" method="post"
                                                            action="{{ route('create-voucher') }}">
                                                            {{ csrf_field() }}
                                                            <input type="hidden" name="type"
                                                                value="{{ \App\GeneralJournalEntry::customer_cancel_unit }}">
                                                            <input type="hidden" name="id"
                                                                value="{{ $c_receipt->id }}">
                                                            <input type="hidden" name="control"
                                                                value="{{ \App\ControlAccount::CUSTOMER }}">
    
                                                        </form>
                                                    </td>
                                            </tr>
                                        @endforeach
        
        
                                    </tbody>
                                </table>
                            </div>
                            <div class="clearfix"></div>
                        </div>


                        <div role="tabpanel" class="tab-pane fade" id="profile4">
                            <div class="table-responsive">
                                <table id="myTable4" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Project</th>
                                            <th>Member Name .</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>

                                            <th>Received Amount </th>
                                            <th>Total Amount</th>
                                            <th>Total Refunded Amount</th>
                                            <th>Total Deduction</th>
                                            <th>Cancellation Process Charges</th>
                                            <th>Date</th>


                                           
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($refund_properties as $refund)
                                            <tr>

                                                <td>{{ $refund->receipt_no }}</td>
                                                <td>{{ $refund->multiProject ? $refund->multiProject->name : 'None' }}</td>

                                                <td>{{ $refund->customer ? $refund->customer->name : 'None' }}</td>

                                                <td>{{ $refund->property ? ($refund->property->inventory ? $refund->property->inventory->unit_number : '') : '' }}
                                                </td>


                                                @if ($refund->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($refund->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($refund->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @elseif($refund->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                @elseif($refund->payment_method == \App\Receipt::merging)
                                                    <td>Merging</td>
                                                @else
                                                    <td></td>
                                                @endif





                                                @if ($refund->tax_paid_by == \App\Receipt::company)
                                                    <td>{{ number_format($refund->amount + $refund->tax_amount) }} PKR</td>
                                                @else
                                                    <td>{{ number_format($refund->amount) }} PKR</td>
                                                @endif

                                                <td><b>{{ number_format($refund->property->unitRefundHistory->total_amount) }}</b>
                                                </td>

                                                <td><b>{{ number_format($refund->property->unitRefundHistory->total_refund) }}</b>
                                                </td>

                                                <td><b>{{ number_format($refund->property->unitRefundHistory->total_deduct) }}</b>
                                                </td>


                                                <td>Cancellation Charges</td>



                                                <td> {{ date('d-m-Y', strtotime($refund->receipt_date)) }}</td>















                                                <td class="text-nowrap">

                                                    
                                                    @permission('create-voucher')
                                                        <a onclick="$('#voucher-form{{ $refund->id }}').submit()"
                                                            href="#"><button class="btn btn-default btn-outline"
                                                                type="button"> <span><i class="fa fa-money "></i> Make
                                                                    JV</span> </button></a>
                                                    @endpermission



                                                    <form id="voucher-form{{ $refund->id }}" method="post"
                                                        action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::customer_refund_unit }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $refund->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::CUSTOMER }}">

                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach




                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="profile1">
                            <div class="table-responsive">
                                <table id="myTable1" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Project.</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>



                                        @foreach ($receipts as $receipt)
                                            <tr>
                                                <td>{{ $receipt->receipt_no }}</td>

                                                <td>{{ $receipt->multiProject ? $receipt->multiProject->name : 'None' }}</td>

                                                <td>{{ $receipt->property->inventory->unit_number }}</td>





                                                @if ($receipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($receipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @elseif($receipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                @else
                                                    <td></td>
                                                @endif


                                                @if ($receipt->payment_head == \App\Receipt::down_payment)
                                                    <td>Down Payment</td>
                                                @elseif($receipt->payment_head == \App\Receipt::possession_fee)
                                                    <td>Possession Fee</td>
                                                @elseif($receipt->payment_head == \App\Receipt::installment)
                                                    <td>Installment</td>
                                                @elseif($receipt->payment_head == \App\Receipt::other)
                                                    <td>Other</td>
                                                @elseif($receipt->payment_head == \App\Receipt::confirmation)
                                                    <td>Confirmation</td>
                                                @elseif($receipt->payment_head == \App\Receipt::allotment)
                                                    <td>Allotment</td>
                                                @elseif($receipt->payment_head == \App\Receipt::booking)
                                                    <td>Booking</td>
                                                @elseif($receipt->payment_head == \App\Receipt::ballon)
                                                    <td>Ballon</td>
                                                @elseif($receipt->payment_head == \App\Receipt::balloting)
                                                    <td>Balloting</td>
                                                @elseif($receipt->payment_head == \App\Receipt::file_processing)
                                                    <td>File Processing</td>
                                                @elseif($receipt->payment_head == \App\Receipt::token_amount)
                                                    <td>Token Amount</td>
                                                @else
                                                    <td></td>
                                                @endif
                                                @if ($receipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{ number_format($receipt->amount + $receipt->tax_amount) }} PKR
                                                    </td>
                                                @else
                                                    <td>{{ number_format($receipt->amount) }} PKR</td>
                                                @endif
                                                <td> {{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                                <td class="text-nowrap">

                                                    <a href="{{ route('pending-receipts.detail', ['id' => $receipt->id]) }}"
                                                        class="btn btn-default">View</a>


                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="profile2">
                            <div class="table-responsive">
                                <table id="myTable3" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Checked</th>
                                            <th>Posted</th>
                                            <th>Date</th>
                                            <th>Entry No.</th>
                                            <th>Receipt No</th>
                                            <th>ADJ</th>
                                            <th>Account</th>
                                            <th>Memo</th>
                                            <!-- <th>Class</th> -->
                                            <th>Debit/Credit (+/-)</th>
                                            <th>Action</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($allEntries as $entry)
                                            <tr ondblclick="showEntry('{{ $entry->entry_no }}')">

                                                @if ($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    <td>CRV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    <td>BRV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    <td>CPV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    <td>BPV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    <td>JV-{{ $entry->voucher_no }}</td>
                                                @else
                                                    <td></td>
                                                @endif

                                                <td>
                                                    @if ($entry->is_check)
                                                        <i class="fa fa-check" style="color:green"></i>
                                                    @else
                                                        <i class="fa fa-close" style="color: red;"></i>
                                                    @endif

                                                <td>
                                                    @if ($entry->is_post)
                                                        <i class="fa fa-check" style="color:green"></i>
                                                    @else
                                                        <i class="fa fa-close" style="color: red;"></i>
                                                    @endif
                                                </td>

                                                <td>{{ date('d/m/Y', strtotime($entry->date)) }}</td>
                                                <td>{{ $entry->entry_no }}</td>

                                                <td>


                                                    @if ($entry->transaction_type == \App\GeneralJournalEntry::receipt && $entry->receipt)
                                                        {{ $entry->receipt->receipt_no }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($entry->adjusting_entry)
                                                        <i class="fa fa-check"></i>
                                                    @endif
                                                </td>
                                                <td>{{ $entry->account ? $entry->account->name : '' }}</td>
                                                <td>{{ $entry->memo }}</td>
                                                <td>{{ number_format($totalAmount[$entry->entry_no]) }}</td>


                                                <td>
                                                    <!-- <span onclick="showEntry('{{ $entry->entry_no }}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

                                                    <a href="{{ route('voucher-detail', ['id' => $entry->entry_no]) }}"
                                                        class="btn btn-default">View</a>

                                                    @if (!$entry->is_approved)
                                                        <br><br>
                                                        <span onclick="approveEntryModal('{{ $entry->entry_no }}')"
                                                            style="cursor: pointer;" class="btn btn-default btn-sm">
                                                            Approve</span>
                                                    @endif

                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>


                    </div>
                </div>


            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>



    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });

            $('#myTable1').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
            $('#myTable6').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
            $('#myTable3').DataTable({

                'paging': false,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });

            $('#myTable8').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });

            $('#myTable4').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
    </script>
@stop
