@extends('layouts.app')

@section('title')
    Dealer Vouchers
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Dealer Vouchers</li>
    </ol>
@stop


@section('content')


    <div class="container-fluid">


        <!-- /row -->
        <div class="row">
            <div class="col-sm-12">

                <div class="white-box">
                    <h3 class="box-title">Dealers</h3>

                    <!-- Nav tabs -->
                    <ul class="nav customtab nav-tabs" role="tablist">

                        <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                        class="ti-home"></i></span><span class="hidden-xs">List</span></a></li>
                        <li role="presentation" class=""><a href="#profile1" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Payments @if (count($allRebates) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($allRebates) }}</span>
                                    @endif
                                </span>
                            </a></li>
                        <li role="presentation" class=""><a href="#pending-rebate-booking" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Package Rebate Payments
                                    @if (count($pendingRebateBookings) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($pendingRebateBookings) }}</span>
                                    @endif
                                </span>
                            </a></li>
                        <li role="presentation" class=""><a href="#pending-openfile-package" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Package Receipts
                                    @if (count($pendingopenfilepackage) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($pendingopenfilepackage) }}</span>
                                    @endif
                                </span>
                            </a></li>

                            <li role="presentation" class=""><a href="#pending-cancel-openfile" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Cancel OpenFile
                                    @if (count($cancel_openfile_receipts) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($cancel_openfile_receipts) }}</span>
                                    @endif
                                </span></a></li>
                            <li role="presentation" class=""><a href="#pending-refunded-openfile" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Pending Refunded OpenFile
                                    @if (count($openfile_receipts) > 0)
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ count($openfile_receipts) }}</span>
                                    @endif
                                </span></a></li>

                        <li role="presentation" class=""><a href="#profile2" aria-controls="profile" role="tab"
                                data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Vouchers</span></a></li>


                    </ul>
                    <!-- Tab panes -->
                    <div class="tab-content">

                        <div role="tabpanel" class="tab-pane fade active in" id="home">
                            <div class="table-responsive">

                                <a href="{{ route('control-account.addView', ['id' => \App\ControlAccount::DEALER]) }}"
                                    target="_blank" class="btn btn-default pull-right"> Add New </a>

                                <br>
                                <br>
                                <div class="clearfix"></div>
                                <table id="myTable8" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>

                                            <th>Name</th>
                                            <th>Description</th>
                                            <th>balance</th>


                                            <th style="width: 185px!important;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>


                                        @foreach ($list as $l)
                                            <tr>
                                                <td>{{ $count++ }}</td>
                                                <td>
                                                    {{ $l->name }}


                                                </td>

                                                <td>{{ $l->description }}</td>
                                                <td>
                                                    @if ($balance[$l->id] < 0)
                                                        ({{ number_format(abs($balance[$l->id])) }})
                                                    @elseif($balance[$l->id] > 0)
                                                        {{ number_format($balance[$l->id]) }}
                                                    @else
                                                        -
                                                    @endif
                                                </td>


                                                <td class="text-nowrap">

                                                    <a href="{{ route('control-account.detail', ['id' => $l->id]) }}"
                                                        target="_blank" class="btn btn-default"> View </a>


                                                    <a href="{{ route('control-account.editView', ['id' => $l->id]) }}"
                                                        target="_blank" class="btn btn-default"> Edit</a>



                                                </td>

                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>


                        <div role="tabpanel" class="tab-pane fade" id="profile1">
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project</th>
                                            <th>Dealer Name</th>
                                            <th>Property</th>

                                            <th>Net amount</th>
                                            <th>Tax amount</th>
                                            <th>Payment Method</th>
                                            <th>Description</th>

                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>
                                        @foreach ($allRebates as $rebate)
                                            <tr>
                                                <td>{{ $count++ }}</td>
                                                <td>{{ $rebate->property->multiProject->name }}</td>
                                                <td>{{ $rebate->dealer ? $rebate->dealer->name : '' }}</td>
                                                <td>
                                                    @if ($rebate->property)
                                                        @if ($rebate->property->inventory)
                                                            {{ $rebate->property->inventory->unit_number }}
                                                        @endif
                                                    @endif
                                                </td>

                                                <td>{{ number_format($rebate->amount) }}</td>
                                                <td>{{ number_format($rebate->tax_amount) }}</td>

                                                <td>
                                                    @if ($rebate->payment_method)
                                                        @if ($rebate->payment_method == 1)
                                                            CASH
                                                        @else
                                                            BANK TRANSFER
                                                        @endif
                                                    @endif
                                                </td>
                                                <td>{{ $rebate->description }}</td>
                                                <td>{{ date('d-m-Y', strtotime($rebate->date)) }}</td>
                                                <td class="text-nowrap">
                                                    @permission('create-voucher')
                                                        <a onclick="$('#voucher-pendingpayment-form{{ $rebate->id }}').submit()"
                                                            href="#"><button class="btn btn-default btn-outline"
                                                                type="button"> <span><i class="fa fa-money "></i> Make
                                                                    Voucher</span> </button></a>
                                                    @endpermission



                                                    <form id="voucher-pendingpayment-form{{ $rebate->id }}"
                                                        method="post" action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::rebate }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $rebate->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::DEALER }}">

                                                    </form>



                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="pending-rebate-booking">
                            <div class="table-responsive">
                                <table id="PendingRebateBooking" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Project</th>
                                            <th>Package </th>
                                            <th>Dealer Code</th>
                                            <th>Dealer Name</th>

                                            <th>Rebate Amount</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1; ?>
                                        @foreach ($pendingRebateBookings as $rebate)
                                            <tr>
                                                <td>{{ $count++ }}</td>
                                                <td>{{ $rebate->dealerPackage->multiProject->name }}</td>
                                                <td>
                                                    @if ($rebate->dealerPackage)
                                                        {{ $rebate->dealerPackage->package->name }}
                                                    @endif
                                                </td>
                                                <td>{{ $rebate->dealer ? $rebate->dealer->code : '' }}</td>
                                                <td>{{ $rebate->dealer ? $rebate->dealer->name : '' }}</td>


                                                <td>{{ number_format($rebate->amount) }}</td>
                                                <td>{{ date('d-m-Y', strtotime($rebate->created_at)) }}</td>
                                                <td class="text-nowrap">
                                                    @if ($rebate->property)
                                                        <a href="{{ route('statement.detail', ['id' => $rebate->property->id]) }}"
                                                            data-toggle="tooltip" data-original-title="View"> <i
                                                                class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                    @endif

                                                    @permission('create-voucher')
                                                        <a onclick="$('#voucher-form{{ $rebate->id }}').submit()"
                                                            href="#"><button class="btn btn-default btn-outline"
                                                                type="button"> <span><i class="fa fa-money "></i> Make
                                                                    JV</span> </button></a>
                                                    @endpermission



                                                    <form id="voucher-form{{ $rebate->id }}" method="post"
                                                        action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::dealer_receipt }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $rebate->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::DEALER }}">

                                                    </form>



                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="pending-openfile-package">
                            <div class="table-responsive">
                                <table id="PendingRebateBooking" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Project</th>
                                            <th>Receipt #</th>

                                            <th>Dealer Code</th>
                                            <th>Dealer Name</th>
                                            <th>Package Name</th>
                                            <th>Receipt Amount</th>
                                            <th>Receipt Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($pendingopenfilepackage as $op)
                                            <tr>
                                                <td>{{ $op->multiProject->name }}</td>
                                                <td>{{ $op->receipt_no }}</td>
                                                <td>
                                                    {{ $op->dealerPackage->dealer->code }}
                                                </td>
                                                <td>
                                                    {{ $op->dealerPackage->dealer->name }}
                                                </td>

                                                <td>
                                                    {{ $op->dealerPackage->package->name }}
                                                </td>

                                                <td>
                                                    {{ $op->amount }} pkr
                                                </td>
                                                <td>
                                                    {{ $op->receipt_date }}
                                                </td>



                                                <td class="text-nowrap">

                                                    @permission('create-voucher')
                                                        <a onclick="$('#voucher-form-openfile{{ $op->id }}').submit()"
                                                            href="#"><button class="btn btn-default btn-outline"
                                                                type="button"> <span><i class="fa fa-money "></i> Make
                                                                    JV</span> </button></a>
                                                    @endpermission



                                                    <form id="voucher-form-openfile{{ $op->id }}" method="post"
                                                        action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::dealer_open_file_package }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $op->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::DEALER }}">


                                                    </form>



                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="pending-cancel-openfile">
                            <div class="table-responsive">
                                <table id="pending-cancel-openfiletable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Project</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
        
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
        
        
        
                                        @foreach ($cancel_openfile_receipts as $c_open_filereceipt)
                                            <tr>
                                                <td>{{ $c_open_filereceipt->receipt_no }}</td>
                                                <td>{{ $c_open_filereceipt->multiProject ? $c_open_filereceipt->multiProject->name : 'None' }}</td>
        
                                                <td>{{ $c_open_filereceipt->openFileDealerInfo ? ($c_open_filereceipt->openFileDealerInfo->inventory ? $c_open_filereceipt->openFileDealerInfo->inventory->unit_number : '') : '' }}
                                                </td>
        
        
                                                @if ($c_open_filereceipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($c_open_filereceipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($c_open_filereceipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @elseif($c_open_filereceipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                @elseif($c_open_filereceipt->payment_method == \App\Receipt::merging)
                                                    <td>Merging</td>
                                                @else
                                                    <td></td>
                                                @endif
        
        
        
        
        
                                                @if ($c_open_filereceipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{ number_format($c_open_filereceipt->amount + $c_open_filereceipt->tax_amount) }} PKR</td>
                                                @else
                                                    <td>{{ number_format($c_open_filereceipt->amount) }} PKR</td>
                                                @endif
                                                <td> {{ date('d-m-Y', strtotime($c_open_filereceipt->receipt_date)) }}</td>
                                              
                                               
                                        @if ($c_open_filereceipt->is_approved == true)
                                        <td>
                                            <span class="label label-success">
                                                Approved
                                            </span>
                                        </td>
                                    @else
                                        
                                            <td>
                                                <span class="label label-warning">
                                                    Pending
                                                </span>
                                            </td>
                                        @endif
                                        <td class="text-nowrap">

                                            @permission('create-voucher')
                                                <a onclick="$('#voucher-cancel-openfile-form{{ $c_open_filereceipt->id }}').submit()"
                                                    href="#"><button class="btn btn-default btn-outline"
                                                        type="button"> <span><i class="fa fa-money "></i> Make
                                                            JV</span> </button></a>
                                            @endpermission



                                            <form id="voucher-cancel-openfile-form{{ $c_open_filereceipt->id }}"
                                                method="post" action="{{ route('create-voucher') }}">
                                                {{ csrf_field() }}
                                                <input type="hidden" name="type"
                                                    value="{{ \App\GeneralJournalEntry::dealer_cancel_open_unit }}">
                                                <input type="hidden" name="id"
                                                    value="{{ $c_open_filereceipt->id }}">
                                                <input type="hidden" name="control"
                                                    value="{{ \App\ControlAccount::DEALER }}">

                                            </form>
                                        </td>
                                            </tr>
                                        @endforeach
        
        
                                    </tbody>
                                </table>
        

                            </div>
                            <div class="clearfix"></div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="pending-refunded-openfile">
                            <div class="table-responsive">
                                <table id="pending-refunded-openfile" class="table table-striped">
                                    <thead>
                                        <tr>

                                            <th>Receipt No.</th>
                                            <th>Project</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>

                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($openfile_receipts as $open_filereceipt)
                                            <tr>
                                                <td>{{ $open_filereceipt->receipt_no }}</td>
                                                <td>{{ $open_filereceipt->multiProject ? $open_filereceipt->multiProject->name : 'None' }}
                                                </td>

                                                <td>{{ $open_filereceipt->openFileDealerInfo ? ($open_filereceipt->openFileDealerInfo->inventory ? $open_filereceipt->openFileDealerInfo->inventory->unit_number : '') : '' }}
                                                </td>


                                                @if ($open_filereceipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                @elseif($open_filereceipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank</td>
                                                @elseif($open_filereceipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                @elseif($open_filereceipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                @elseif($open_filereceipt->payment_method == \App\Receipt::merging)
                                                    <td>Merging</td>
                                                @else
                                                    <td></td>
                                                @endif





                                                @if ($open_filereceipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{ number_format($open_filereceipt->amount + $open_filereceipt->tax_amount) }}
                                                        PKR</td>
                                                @else
                                                    <td>{{ number_format($open_filereceipt->amount) }} PKR</td>
                                                @endif
                                                <td> {{ date('d-m-Y', strtotime($open_filereceipt->receipt_date)) }}</td>
                                                <td class="text-nowrap">

                                                    @permission('create-voucher')
                                                        <a onclick="$('#voucher-refundopenfile-form{{ $open_filereceipt->id }}').submit()"
                                                            href="#"><button class="btn btn-default btn-outline"
                                                                type="button"> <span><i class="fa fa-money "></i> Make
                                                                    JV</span> </button></a>
                                                    @endpermission



                                                    <form id="voucher-refundopenfile-form{{ $open_filereceipt->id }}"
                                                        method="post" action="{{ route('create-voucher') }}">
                                                        {{ csrf_field() }}
                                                        <input type="hidden" name="type"
                                                            value="{{ \App\GeneralJournalEntry::dealer_refunded_open_file }}">
                                                        <input type="hidden" name="id"
                                                            value="{{ $open_filereceipt->id }}">
                                                        <input type="hidden" name="control"
                                                            value="{{ \App\ControlAccount::DEALER }}">

                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach





                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="profile2">



                            <div class="table-responsive">

                                @permission('create-voucher')
                                    <a onclick="$('#voucher-form').submit()" href="#"><button
                                            class="btn btn-default btn-outline pull-right" type="button"> <span><i
                                                    class="fa fa-money "></i> Make Voucher</span> </button></a>
                                @endpermission



                                <form id="voucher-form" method="post" action="{{ route('create-voucher') }}">
                                    {{ csrf_field() }}
                                    <input type="hidden" name="type" value="">
                                    <input type="hidden" name="id" value="">
                                    <input type="hidden" name="control" value="{{ \App\ControlAccount::DEALER }}">

                                </form>

                                <table id="myTable3" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Checked</th>
                                            <th>Posted</th>
                                            <th>Date</th>
                                            <th>Entry No.</th>
                                            <th>ADJ</th>
                                            <th>Account</th>
                                            <th>Memo</th>
                                            <!-- <th>Class</th> -->
                                            <th>Debit/Credit</th>
                                            <th>Action</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($allEntries as $entry)
                                            <tr ondblclick="showEntry('{{ $entry->entry_no }}')">

                                                @if ($entry->voucher_type == \App\GeneralJournalEntry::CRV)
                                                    <td>CRV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BRV)
                                                    <td>BRV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::CPV)
                                                    <td>CPV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::BPV)
                                                    <td>BPV-{{ $entry->voucher_no }}</td>
                                                @elseif($entry->voucher_type == \App\GeneralJournalEntry::JV)
                                                    <td>JV-{{ $entry->voucher_no }}</td>
                                                @else
                                                    <td></td>
                                                @endif

                                                <td>
                                                    @if ($entry->is_check)
                                                        <i class="fa fa-check" style="color:green"></i>
                                                    @else
                                                        <i class="fa fa-close" style="color: red;"></i>
                                                    @endif

                                                <td>
                                                    @if ($entry->is_post)
                                                        <i class="fa fa-check" style="color:green"></i>
                                                    @else
                                                        <i class="fa fa-close" style="color: red;"></i>
                                                    @endif
                                                </td>

                                                <td>{{ date('d/m/Y', strtotime($entry->date)) }}</td>
                                                <td>{{ $entry->entry_no }}</td>
                                                <td>
                                                    @if ($entry->adjusting_entry)
                                                        <i class="fa fa-check"></i>
                                                    @endif
                                                </td>
                                                <td>{{ $entry->account ? $entry->account->name : '' }}</td>
                                                <td>{{ $entry->memo }}</td>
                                                <!-- <td>{{ $entry->class ? $entry->class->name : '' }}</td> -->
                                                <td>{{ number_format($totalAmount[$entry->entry_no]) }}</td>
                                                <td>
                                                    <!-- <span onclick="showEntry('{{ $entry->entry_no }}')" style="cursor: pointer;" class="btn btn-sm btn-primary"> Show</span> -->

                                                    <a href="{{ route('voucher-detail', ['id' => $entry->entry_no]) }}"
                                                        class="btn btn-default">View</a>

                                                    @if (!$entry->is_approved)
                                                        <br><br>
                                                        <span onclick="approveEntryModal('{{ $entry->entry_no }}')"
                                                            style="cursor: pointer;" class="btn btn-default btn-sm">
                                                            Approve</span>
                                                    @endif

                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>

                            </div>
                            <div class="clearfix"></div>
                        </div>





                    </div>
                </div>


            </div>
        </div>

        <form id="voucher-form" method="post" action="{{ route('create-voucher') }}">
            {{ csrf_field() }}
            <input type="hidden" name="type" value="{{ \App\GeneralJournalEntry::massPayment }}">
            <input type="hidden" name="id" id="id" value="">

        </form>

        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false
            });

            $('#myTable1').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false
            });
            $('#myTable3').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false
            });

            $('#myTable8').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false
            });
            $('#PendingRebateBooking').DataTable({
                'pageLength': 25,
                'paging': true,
                'searching': true,
                'info': true,
                'ordering': false
            });
        });


        function checkSelectedCheckbox() {


            var check_ids = [];

            $.each($("input[name='check_list']:checked"), function() {
                check_ids.push($(this).val());
            });


            if (check_ids.length == 0) {
                document.getElementById('status').style.display = 'block';
                document.getElementById('status').style.color = 'red';
                document.getElementById('status').innerHTML = '<strong><h3>please select any bill!</h3></strong>';
                $('#status').delay(3000).fadeOut();
            } else {
                paymentVoucher(check_ids);
            }



        }

        function paymentVoucher(check_ids) {

            $('#id').val(check_ids);

            $('#voucher-form').submit();

        }
    </script>

@stop
